<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CategoriaController extends Controller
{
    public function index()
    {
        $categorias = DB::table('categorias_usuario')
            ->orderBy('nome')
            ->get();

        return view('admin.categorias.index', compact('categorias'));
    }

    public function create()
    {
        return view('admin.categorias.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nome' => 'required|string|max:100',
            'slug' => 'required|string|max:50|unique:categorias_usuario,slug',
            'descricao' => 'nullable|string|max:255',
            'nivel_acesso' => 'required|integer|min:1|max:1000',
        ]);

        DB::table('categorias_usuario')->insert([
            'nome' => $request->nome,
            'slug' => $request->slug,
            'descricao' => $request->descricao,
            'nivel_acesso' => $request->nivel_acesso,
            'ativo' => 1,
            'criado_em' => now(),
            'atualizado_em' => now(),
        ]);

        return redirect()->route('admin.categorias.index')
            ->with('success', 'Categoria criada com sucesso!');
    }

    public function edit($id)
    {
        $categoria = DB::table('categorias_usuario')->where('id', $id)->first();
        
        if (!$categoria) {
            abort(404);
        }

        return view('admin.categorias.edit', compact('categoria'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nome' => 'required|string|max:100',
            'slug' => 'required|string|max:50',
            'descricao' => 'nullable|string|max:255',
            'nivel_acesso' => 'required|integer|min:1|max:1000',
            'ativo' => 'required|boolean',
        ]);

        DB::table('categorias_usuario')
            ->where('id', $id)
            ->update([
                'nome' => $request->nome,
                'slug' => $request->slug,
                'descricao' => $request->descricao,
                'nivel_acesso' => $request->nivel_acesso,
                'ativo' => $request->ativo,
                'atualizado_em' => now(),
            ]);

        return redirect()->route('admin.categorias.index')
            ->with('success', 'Categoria atualizada com sucesso!');
    }

    public function destroy($id)
    {
        // Verificar se tem usuários vinculados
        $temUsuarios = DB::table('usuario_categoria')
            ->where('categoria_id', $id)
            ->exists();

        if ($temUsuarios) {
            return back()->with('error', 'Não é possível excluir uma categoria com usuários vinculados.');
        }

        DB::table('categorias_usuario')->where('id', $id)->delete();

        return redirect()->route('admin.categorias.index')
            ->with('success', 'Categoria excluída com sucesso!');
    }

    public function toggleStatus($id)
    {
        $categoria = DB::table('categorias_usuario')->where('id', $id)->first();

        if (!$categoria) {
            return response()->json(['success' => false, 'message' => 'Categoria não encontrada'], 404);
        }

        DB::table('categorias_usuario')
            ->where('id', $id)
            ->update([
                'ativo' => !$categoria->ativo,
                'atualizado_em' => now(),
            ]);

        return response()->json([
            'success' => true,
            'message' => 'Status atualizado com sucesso!',
            'novo_status' => !$categoria->ativo,
        ]);
    }
}

