<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\RelatorioService;
use Illuminate\Http\Request;
use Carbon\Carbon;

class RelatorioController extends Controller
{
    protected $relatorioService;

    public function __construct(RelatorioService $relatorioService)
    {
        $this->relatorioService = $relatorioService;
    }

    public function index()
    {
        return view('admin.relatorios.index');
    }

    public function vendas(Request $request)
    {
        $dataInicio = $request->input('data_inicio', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $dataFim = $request->input('data_fim', Carbon::now()->format('Y-m-d'));
        $equipeId = $request->input('equipe_id');
        $especialistaId = $request->input('especialista_id');

        $relatorio = $this->relatorioService->relatorioVendas($dataInicio, $dataFim, $equipeId, $especialistaId);

        return view('admin.relatorios.vendas', compact('relatorio', 'dataInicio', 'dataFim'));
    }

    public function performance(Request $request)
    {
        $dataInicio = $request->input('data_inicio', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $dataFim = $request->input('data_fim', Carbon::now()->format('Y-m-d'));
        $equipeId = $request->input('equipe_id');

        $relatorio = $this->relatorioService->relatorioPerformance($dataInicio, $dataFim, $equipeId);

        return view('admin.relatorios.performance', compact('relatorio', 'dataInicio', 'dataFim'));
    }

    public function funil(Request $request)
    {
        $dataInicio = $request->input('data_inicio', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $dataFim = $request->input('data_fim', Carbon::now()->format('Y-m-d'));
        $equipeId = $request->input('equipe_id');

        $relatorio = $this->relatorioService->relatorioFunil($dataInicio, $dataFim, $equipeId);

        return view('admin.relatorios.funil', compact('relatorio', 'dataInicio', 'dataFim'));
    }

    public function exportar(Request $request)
    {
        $tipo = $request->input('tipo', 'vendas');
        $dataInicio = $request->input('data_inicio', Carbon::now()->startOfMonth()->format('Y-m-d'));
        $dataFim = $request->input('data_fim', Carbon::now()->format('Y-m-d'));

        $relatorio = match($tipo) {
            'vendas' => $this->relatorioService->relatorioVendas($dataInicio, $dataFim),
            'performance' => $this->relatorioService->relatorioPerformance($dataInicio, $dataFim),
            'funil' => $this->relatorioService->relatorioFunil($dataInicio, $dataFim),
            default => null,
        };

        if (!$relatorio) {
            return back()->with('error', 'Tipo de relatório inválido');
        }

        $filename = $this->relatorioService->exportarCSV($relatorio, $tipo);

        return response()->download($filename)->deleteFileAfterSend(true);
    }
}

