<?php

namespace App\Http\Controllers\Especialista;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class AlunoController extends Controller
{
    /**
     * Listar alunos do especialista
     */
    public function index(Request $request)
    {
        $especialista = Auth::user();

        // Filtros
        $filtroAceite = $request->input('aceite', 'todos');
        $filtroNegociacao = $request->input('negociacao', 'todas');
        $filtroPeriodo = $request->input('periodo', 'todos');

        // Definir período para filtro de data
        $whereData = "";
        switch ($filtroPeriodo) {
            case 'semana':
                $whereData = " AND a.data_cadastro >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
                break;
            case 'mes':
                $whereData = " AND a.data_cadastro >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
                break;
            case 'ano':
                $whereData = " AND a.data_cadastro >= DATE_SUB(NOW(), INTERVAL 1 YEAR)";
                break;
        }

        // Buscar alunos do especialista
        $query = DB::table('alunos as a')
            ->where('a.especialista_id', $especialista->id)
            ->select(
                'a.id',
                'a.nome',
                'a.email',
                'a.cpf',
                'a.celular',
                'a.data_cadastro',
                'a.data_aceite_contrato',
                'a.primeiro_acesso',
                'a.status',
                'a.tipo_contrato',
                DB::raw("CASE 
                    WHEN a.data_aceite_contrato IS NOT NULL THEN 'realizado'
                    WHEN a.primeiro_acesso = 1 AND a.data_aceite_contrato IS NULL THEN 'pendente'
                    ELSE 'não_aplicavel'
                END as status_aceite"),
                DB::raw("(SELECT n.id FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as negociacao_id"),
                DB::raw("(SELECT n.valor_total FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as valor_total"),
                DB::raw("(SELECT n.num_parcelas FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as num_parcelas"),
                DB::raw("(SELECT n.investimento_parcial FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as investimento_parcial"),
                DB::raw("(SELECT n.valor_pago FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as valor_pago"),
                DB::raw("(SELECT n.saldo_restante FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as saldo_restante"),
                DB::raw("(SELECT n.status FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as negociacao_status"),
                DB::raw("(SELECT n.data_criacao FROM negociacoes n WHERE n.aluno_id = a.id AND n.especialista_id = {$especialista->id} ORDER BY n.data_criacao DESC LIMIT 1) as negociacao_data"),
                DB::raw("(SELECT l.nome FROM leads l 
                    INNER JOIN vinculo vin ON vin.lead_id = l.id 
                    WHERE vin.aluno_id = a.id AND vin.status = 'ativo' 
                    LIMIT 1) as lead_nome"),
                DB::raw("(SELECT l.id FROM leads l 
                    INNER JOIN vinculo vin ON vin.lead_id = l.id 
                    WHERE vin.aluno_id = a.id AND vin.status = 'ativo' 
                    LIMIT 1) as lead_id")
            );

        if ($whereData) {
            $query->whereRaw("1=1 {$whereData}");
        }

        $alunosRaw = $query->orderBy('a.data_cadastro', 'desc')->get();

        // Aplicar filtros de status
        $alunos = $alunosRaw->filter(function($aluno) use ($filtroAceite, $filtroNegociacao) {
            // Filtro de aceite
            if ($filtroAceite !== 'todos' && $aluno->status_aceite !== $filtroAceite) {
                return false;
            }
            
            // Filtro de negociação
            if ($filtroNegociacao !== 'todas') {
                if (empty($aluno->negociacao_status)) {
                    return false;
                }
                if ($aluno->negociacao_status !== $filtroNegociacao) {
                    return false;
                }
            }
            
            return true;
        });

        // Estatísticas
        $totalAlunos = $alunos->count();
        $aceitesRealizados = $alunos->where('status_aceite', 'realizado')->count();
        $aceitesPendentes = $alunos->where('status_aceite', 'pendente')->count();
        $totalNegociacoes = $alunos->whereNotNull('negociacao_id')->count();
        $negociacoesAprovadas = $alunos->where('negociacao_status', 'aprovada')->count();
        $negociacoesPendentes = $alunos->where('negociacao_status', 'pendente')->count();
        $valorTotalNegociado = $alunos->sum(function($aluno) {
            return (float)($aluno->valor_total ?? 0);
        });

        // Estatísticas gerais (sem filtro)
        $totalAlunosGeral = $alunosRaw->count();
        $totalNegociacoesGeral = $alunosRaw->whereNotNull('negociacao_id')->count();

        return view('especialista.meus-alunos.index', compact(
            'alunos',
            'filtroAceite',
            'filtroNegociacao',
            'filtroPeriodo',
            'totalAlunos',
            'aceitesRealizados',
            'aceitesPendentes',
            'totalNegociacoes',
            'negociacoesAprovadas',
            'negociacoesPendentes',
            'valorTotalNegociado',
            'totalAlunosGeral',
            'totalNegociacoesGeral'
        ));
    }
}


