<?php

namespace App\Http\Controllers\Especialista;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LinkController extends Controller
{
    /**
     * Exibir links de cadastro do especialista
     */
    public function index()
    {
        $especialista = Auth::user();

        // Gerar links únicos
        $linkRegular = url('/cadastro?e=' . $especialista->id . '&tipo=regular');
        $linkBolsista = url('/cadastro?e=' . $especialista->id . '&tipo=bolsista');

        // Estatísticas
        $totalRegular = DB::table('alunos')
            ->where('especialista_id', $especialista->id)
            ->where('tipo_contrato', 'regular')
            ->count();

        $totalBolsista = DB::table('alunos')
            ->where('especialista_id', $especialista->id)
            ->where('tipo_contrato', 'bolsista')
            ->count();

        $totalGeral = $totalRegular + $totalBolsista;

        // Matrículas efetivadas (R$ 660+)
        $totalMatriculasEfetivadas = DB::table('matriculas as m')
            ->join('alunos as a', 'm.aluno_id', '=', 'a.id')
            ->where('a.especialista_id', $especialista->id)
            ->where('m.valor_total', '>=', 660)
            ->count();

        // Alunos cadastrados nos últimos 30 dias
        $alunos30Dias = DB::table('alunos')
            ->where('especialista_id', $especialista->id)
            ->where('data_cadastro', '>=', DB::raw('DATE_SUB(NOW(), INTERVAL 30 DAY)'))
            ->count();

        return view('especialista.meu-link.index', compact(
            'linkRegular',
            'linkBolsista',
            'totalRegular',
            'totalBolsista',
            'totalGeral',
            'totalMatriculasEfetivadas',
            'alunos30Dias'
        ));
    }
}


