<?php

namespace App\Http\Controllers\Especialista;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class PerfilController extends Controller
{
    /**
     * Exibir perfil do especialista
     */
    public function index()
    {
        $especialista = Auth::user();

        // Buscar dados completos do especialista
        $dadosEspecialista = DB::table('usuarios')
            ->where('id', $especialista->id)
            ->first();

        return view('especialista.perfil.index', compact('dadosEspecialista'));
    }

    /**
     * Atualizar perfil
     */
    public function update(Request $request)
    {
        $especialista = Auth::user();

        $request->validate([
            'nome' => 'required|string|max:255',
            'telefone' => 'nullable|string|max:20',
        ]);

        DB::table('usuarios')
            ->where('id', $especialista->id)
            ->update([
                'nome' => $request->nome,
                'telefone' => $request->telefone,
                'atualizado_em' => now(),
            ]);

        return redirect()->route('especialista.perfil.index')
            ->with('success', 'Perfil atualizado com sucesso!');
    }

    /**
     * Alterar senha
     */
    public function changePassword(Request $request)
    {
        $especialista = Auth::user();

        $request->validate([
            'senha_atual' => 'required',
            'nova_senha' => 'required|min:6|confirmed',
        ]);

        // Buscar senha atual do banco
        $usuario = DB::table('usuarios')
            ->where('id', $especialista->id)
            ->first();

        if (!Hash::check($request->senha_atual, $usuario->senha)) {
            return redirect()->route('especialista.perfil.index')
                ->with('error', 'Senha atual incorreta.');
        }

        DB::table('usuarios')
            ->where('id', $especialista->id)
            ->update([
                'senha' => Hash::make($request->nova_senha),
                'atualizado_em' => now(),
            ]);

        return redirect()->route('especialista.perfil.index')
            ->with('success', 'Senha alterada com sucesso!');
    }
}


