<?php

namespace App\Http\Controllers\Especialista;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class VoucherController extends Controller
{
    /**
     * Listar vouchers disponíveis para o especialista
     */
    public function index()
    {
        $especialista = Auth::user();

        // Buscar vouchers disponíveis (globais + individuais)
        $vouchers = DB::select("
            SELECT DISTINCT
                v.*,
                ve.especialista_id
            FROM vouchers v
            LEFT JOIN voucher_especialista ve ON v.id = ve.voucher_id
            WHERE v.ativo = 1
            AND v.quantidade_usada < v.quantidade_total
            AND (v.tipo = 'global' OR ve.especialista_id = ?)
            ORDER BY v.data_criacao DESC
        ", [$especialista->id]);

        // Buscar estatísticas de uso
        $stats = DB::selectOne("
            SELECT 
                COUNT(DISTINCT n.id) as total_usos,
                SUM(n.valor_total) as valor_total_vendas,
                COUNT(DISTINCT v.id) as total_vouchers_disponiveis
            FROM vouchers v
            LEFT JOIN voucher_especialista ve ON v.id = ve.voucher_id
            LEFT JOIN negociacoes n ON v.id = n.voucher_id AND n.especialista_id = ?
            WHERE v.ativo = 1
            AND v.quantidade_usada < v.quantidade_total
            AND (v.tipo = 'global' OR ve.especialista_id = ?)
        ", [$especialista->id, $especialista->id]);

        return view('especialista.vouchers.index', compact('vouchers', 'stats'));
    }
}


