<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Atendimento extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'atendimentos';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'lead_id',
        'especialista_id',
        'tipo',
        'status',
        'data_agendamento',
        'data_realizacao',
        'duracao_minutos',
        'observacoes',
        'resultado',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_agendamento' => 'datetime',
        'data_realizacao' => 'datetime',
    ];

    /**
     * Relacionamento com Lead
     */
    public function lead()
    {
        return $this->belongsTo(Lead::class, 'lead_id');
    }

    /**
     * Relacionamento com Especialista
     */
    public function especialista()
    {
        return $this->belongsTo(Especialista::class, 'especialista_id');
    }
}

