<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contrato extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'contratos_sistema';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'tipo',
        'arquivo',
        'ativo',
        'upload_por',
        'data_upload',
        'ano',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data_upload' => 'datetime',
        'ativo' => 'boolean',
    ];

    /**
     * Relacionamento com Usuario que fez upload
     */
    public function criador()
    {
        return $this->belongsTo(Usuario::class, 'upload_por');
    }

    /**
     * Verifica se o contrato está ativo
     */
    public function isAtivo(): bool
    {
        return $this->ativo == 1;
    }
}

