<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Equipe extends Model
{
    use HasFactory;

    /**
     * Nome da tabela no banco de dados
     */
    protected $table = 'equipes';

    /**
     * Desabilitar timestamps automáticos do Laravel
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'nome',
        'descricao',
        'coordenador_id',
        'status',
        'meta_mensal',
        'tipo',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'meta_mensal' => 'integer',
    ];

    /**
     * Relacionamento com Coordenador (Usuario)
     */
    public function coordenador()
    {
        return $this->belongsTo(Usuario::class, 'coordenador_id');
    }

    /**
     * Relacionamento com Especialistas (através da tabela pivot)
     */
    public function especialistas()
    {
        return $this->belongsToMany(
            Usuario::class,
            'equipe_especialistas',
            'equipe_id',
            'especialista_id'
        )->wherePivot('status', 'ativo');
    }

    /**
     * Relacionamento com Leads
     */
    public function leads()
    {
        return $this->hasMany(Lead::class, 'equipe_id');
    }

    /**
     * Verifica se a equipe está ativa
     */
    public function isAtiva(): bool
    {
        return $this->status === 'ativo';
    }

    /**
     * Scope para equipes ativas
     */
    public function scopeAtivas($query)
    {
        return $query->where('status', 'ativo');
    }
}

