<?php
// Função para buscar vouchers vigentes do especialista
function getVouchersVigentes($pdo, $especialista_id) {
    try {
        $hoje = date('Y-m-d');
        
        // Buscar vouchers disponíveis para este especialista
        // Para GLOBAIS: quantidade é POR ESPECIALISTA (ve.quantidade_usada < v.quantidade_total)
        // Para INDIVIDUAIS: quantidade é do voucher (v.quantidade_usada < v.quantidade_total)
        $sql = "SELECT DISTINCT
                    v.id, 
                    v.codigo, 
                    v.percentual_desconto, 
                    v.tipo,
                    v.data_expiracao as valido_ate,
                    v.quantidade_total,
                    CASE 
                        WHEN v.tipo = 'global' THEN COALESCE(ve.quantidade_usada, 0)
                        ELSE v.quantidade_usada
                    END as quantidade_usada
                FROM vouchers v
                LEFT JOIN voucher_especialista ve ON v.id = ve.voucher_id AND ve.especialista_id = ?
                WHERE v.ativo = 1 
                AND (v.data_expiracao IS NULL OR v.data_expiracao >= ?)
                AND (
                    (v.tipo = 'global' AND COALESCE(ve.quantidade_usada, 0) < v.quantidade_total)
                    OR (v.tipo = 'individual' AND ve.especialista_id = ? AND v.quantidade_usada < v.quantidade_total)
                )
                ORDER BY v.data_criacao DESC";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$especialista_id, $hoje, $especialista_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
        
    } catch (PDOException $e) {
        error_log("Erro ao buscar vouchers vigentes: " . $e->getMessage());
        return []; // Retornar array vazio em caso de erro
    }
}
