<?php
// Página de logs de pagamentos - Para testes da API Pagar.me
if (!isset($_SESSION['especialista_id'])) {
    echo '<div class="alert alert-danger">Sessão inválida. Faça login novamente.</div>';
    exit();
}

// Garantir que $pdo existe
if (!isset($pdo)) {
    require_once '../../includes/config.php';
}

$especialista_id = $_SESSION['especialista_id'];

// Buscar todos os links de pagamento gerados
try {
    $stmt = $pdo->prepare("
        SELECT 
            n.id as negociacao_id,
            n.valor_total,
            n.valor_pago,
            n.saldo_restante,
            n.pagarme_link_pagamento,
            n.pagarme_order_id,
            n.pagarme_transaction_id,
            n.data_envio_link,
            n.data_pagamento,
            n.pagamento_confirmado,
            n.status,
            n.data_criacao,
            a.nome as aluno_nome,
            a.email as aluno_email,
            a.celular as aluno_celular,
            l.nome as lead_nome
        FROM negociacoes n
        INNER JOIN alunos a ON n.aluno_id = a.id
        LEFT JOIN vinculo v ON v.aluno_id = a.id AND v.status = 'ativo'
        LEFT JOIN leads l ON l.id = v.lead_id
        WHERE n.especialista_id = ?
        ORDER BY n.data_criacao DESC
        LIMIT 50
    ");
    $stmt->execute([$especialista_id]);
    $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("ERRO ao buscar logs de pagamento: " . $e->getMessage());
    echo '<div class="alert alert-danger">Erro ao carregar logs: ' . htmlspecialchars($e->getMessage()) . '</div>';
    $logs = [];
}

// Estatísticas
$total_links = count(array_filter($logs, fn($l) => !empty($l['pagarme_link_pagamento'])));
$total_pagos = count(array_filter($logs, fn($l) => $l['pagamento_confirmado'] == 1));
$valor_total = array_sum(array_map(fn($l) => floatval($l['valor_total'] ?? 0), $logs));
$valor_pago = array_sum(array_map(fn($l) => floatval($l['valor_pago'] ?? 0), $logs));
?>

<div class="page-header mb-4">
    <h1 class="page-title">
        <i class="fas fa-link me-2"></i>
        Logs de Pagamentos - Pagar.me
    </h1>
    <p class="page-subtitle">Acompanhe os links gerados e status dos pagamentos (Modo Teste)</p>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="custom-card text-center">
            <div class="card-body">
                <i class="fas fa-list fa-2x mb-2 text-primary"></i>
                <h4><?php echo count($logs); ?></h4>
                <p class="mb-0 text-secondary">Total de Negociações</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="custom-card text-center">
            <div class="card-body">
                <i class="fas fa-link fa-2x mb-2 text-info"></i>
                <h4><?php echo $total_links; ?></h4>
                <p class="mb-0 text-secondary">Links Gerados</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="custom-card text-center">
            <div class="card-body">
                <i class="fas fa-check-circle fa-2x mb-2 text-success"></i>
                <h4><?php echo $total_pagos; ?></h4>
                <p class="mb-0 text-secondary">Pagamentos Confirmados</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="custom-card text-center">
            <div class="card-body">
                <i class="fas fa-dollar-sign fa-2x mb-2 text-success"></i>
                <h4>R$ <?php echo number_format($valor_pago, 2, ',', '.'); ?></h4>
                <p class="mb-0 text-secondary">Total Pago</p>
            </div>
        </div>
    </div>
</div>

<!-- Alert de informação -->
<div class="alert alert-info mb-4">
    <div class="d-flex align-items-start gap-3">
        <i class="fas fa-info-circle fa-2x"></i>
        <div>
            <h6 class="alert-heading mb-2">Modo de Testes Ativo</h6>
            <p class="mb-2">Esta página exibe todos os links de pagamento gerados pela integração com o Pagar.me.</p>
            <ul class="mb-0 small">
                <li><strong>Chave Pública:</strong> <code><?php echo PAGARME_API_KEY; ?></code></li>
                <li><strong>Ambiente:</strong> <?php echo PAGARME_SANDBOX ? 'Sandbox (Testes)' : 'Produção'; ?></li>
                <li><strong>Documentação:</strong> <a href="https://docs.pagar.me/" target="_blank">https://docs.pagar.me/</a></li>
                <li><strong>Para testar pagamentos:</strong> Use os cartões de teste disponíveis na documentação do Pagar.me</li>
            </ul>
        </div>
    </div>
</div>

<!-- Lista de Logs -->
<div class="custom-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-history me-2"></i>
            Histórico de Links de Pagamento (<?php echo count($logs); ?>)
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if (empty($logs)): ?>
            <div class="text-center py-5 text-muted">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p>Nenhuma negociação encontrada</p>
                <small>Crie uma negociação na página de Atendimentos para gerar links de pagamento</small>
            </div>
        <?php else: ?>
            <div class="logs-container">
                <?php foreach ($logs as $log): ?>
                    <div class="log-card">
                        <div class="log-header">
                            <div class="log-info-main">
                                <div class="log-title">
                                    <strong>Negociação #<?php echo $log['negociacao_id']; ?></strong>
                                    <span class="ms-2 text-muted">|</span>
                                    <span class="ms-2"><?php echo htmlspecialchars($log['aluno_nome']); ?></span>
                                    <?php if ($log['lead_nome']): ?>
                                        <span class="badge bg-info ms-2">
                                            <i class="fas fa-user-tag"></i> <?php echo htmlspecialchars($log['lead_nome']); ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="log-meta">
                                    <span class="text-muted">
                                        <i class="fas fa-calendar"></i> <?php echo date('d/m/Y H:i', strtotime($log['data_criacao'])); ?>
                                    </span>
                                    <span class="text-success ms-3">
                                        <i class="fas fa-dollar-sign"></i> <strong>R$ <?php echo number_format($log['valor_total'], 2, ',', '.'); ?></strong>
                                    </span>
                                    <?php if ($log['pagamento_confirmado']): ?>
                                        <span class="badge bg-success ms-3">
                                            <i class="fas fa-check-circle"></i> Pago
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-warning ms-3">
                                            <i class="fas fa-clock"></i> Pendente
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($log['pagarme_link_pagamento']): ?>
                            <div class="log-body">
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-link"></i> Link de Pagamento
                                        </small>
                                        <div class="input-group">
                                            <input type="text" 
                                                   class="form-control form-control-sm font-monospace" 
                                                   value="<?php echo htmlspecialchars($log['pagarme_link_pagamento']); ?>" 
                                                   readonly
                                                   id="link-<?php echo $log['negociacao_id']; ?>">
                                            <button class="btn btn-sm btn-outline-secondary" 
                                                    type="button" 
                                                    onclick="copiarLink(<?php echo $log['negociacao_id']; ?>)">
                                                <i class="fas fa-copy"></i> Copiar
                                            </button>
                                            <a href="<?php echo htmlspecialchars($log['pagarme_link_pagamento']); ?>" 
                                               target="_blank" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-external-link-alt"></i> Abrir
                                            </a>
                                        </div>
                                    </div>
                                    
                                    <?php if ($log['pagarme_order_id']): ?>
                                        <div class="col-md-6">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-tag"></i> Order ID (Pagar.me)
                                            </small>
                                            <code><?php echo htmlspecialchars($log['pagarme_order_id']); ?></code>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($log['pagarme_transaction_id']): ?>
                                        <div class="col-md-6">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-receipt"></i> Transaction ID
                                            </small>
                                            <code><?php echo htmlspecialchars($log['pagarme_transaction_id']); ?></code>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($log['data_envio_link']): ?>
                                        <div class="col-md-6">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-paper-plane"></i> Enviado em
                                            </small>
                                            <span><?php echo date('d/m/Y H:i:s', strtotime($log['data_envio_link'])); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ($log['data_pagamento']): ?>
                                        <div class="col-md-6">
                                            <small class="text-muted d-block mb-1">
                                                <i class="fas fa-check"></i> Pago em
                                            </small>
                                            <span class="text-success"><?php echo date('d/m/Y H:i:s', strtotime($log['data_pagamento'])); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="col-md-12">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-user"></i> Cliente
                                        </small>
                                        <div>
                                            <?php echo htmlspecialchars($log['aluno_nome']); ?>
                                            <span class="text-muted ms-2">|</span>
                                            <span class="text-muted ms-2"><?php echo htmlspecialchars($log['aluno_email']); ?></span>
                                            <?php if ($log['aluno_celular']): ?>
                                                <span class="text-muted ms-2">|</span>
                                                <a href="https://wa.me/55<?php echo preg_replace('/[^0-9]/', '', $log['aluno_celular']); ?>" 
                                                   target="_blank" class="text-success text-decoration-none ms-2">
                                                    <i class="fab fa-whatsapp"></i> <?php echo htmlspecialchars($log['aluno_celular']); ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="log-body">
                                <div class="alert alert-warning mb-0">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    Link de pagamento não gerado ainda
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.logs-container {
    padding: 1rem;
}

.log-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 1rem;
    overflow: hidden;
}

.log-card:hover {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.log-header {
    padding: 1rem;
    background: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
}

.log-title {
    font-size: 15px;
    margin-bottom: 6px;
}

.log-meta {
    font-size: 13px;
    margin-top: 4px;
}

.log-body {
    padding: 1rem;
}

.font-monospace {
    font-family: 'Courier New', Courier, monospace;
    font-size: 12px;
}
</style>

<script>
function copiarLink(negociacaoId) {
    const input = document.getElementById('link-' + negociacaoId);
    if (input) {
        input.select();
        document.execCommand('copy');
        
        // Feedback visual
        const btn = event.target.closest('button');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i> Copiado!';
        btn.classList.remove('btn-outline-secondary');
        btn.classList.add('btn-success');
        
        setTimeout(() => {
            btn.innerHTML = originalHTML;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline-secondary');
        }, 2000);
    }
}
</script>

