<?php
require_once '../includes/config.php';
require_once '../includes/pagarme.php';

$negociacao_id = $_GET['id'] ?? null;
$especialista_id = $_SESSION['especialista_id'];

if (!$negociacao_id) {
    header('Location: index.php');
    exit();
}

// Buscar detalhes da negociação
$stmt = $pdo->prepare("
    SELECT n.*, 
           a.nome as aluno_nome, 
           a.email as aluno_email,
           a.cpf as aluno_cpf,
           a.telefone as aluno_telefone
    FROM negociacoes n
    JOIN alunos a ON n.aluno_id = a.id
    WHERE n.id = ? AND n.especialista_id = ?
");
$stmt->execute([$negociacao_id, $especialista_id]);
$negociacao = $stmt->fetch();

if (!$negociacao) {
    header('Location: index.php');
    exit();
}

// Buscar parcelas
$stmt = $pdo->prepare("
    SELECT * FROM parcelas_negociacao 
    WHERE negociacao_id = ?
    ORDER BY numero_parcela
");
$stmt->execute([$negociacao_id]);

// Buscar valor original da parcela
$parcelas = $stmt->fetchAll();

// Buscar valor integral vigente
$stmt = $pdo->prepare("SELECT valor_integral FROM valores_curso WHERE ativo = 1 ORDER BY data_criacao DESC LIMIT 1");
$stmt->execute();
$valor_integral_vigente = $stmt->fetchColumn();

$parcelas = $stmt->fetchAll();

// Gerar link de pagamento
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['gerar_link'])) {
    $parcela_id = $_POST['parcela_id'];
    
    // Buscar parcela
    $stmt = $pdo->prepare("SELECT * FROM parcelas_negociacao WHERE id = ?");
    $stmt->execute([$parcela_id]);
    $parcela = $stmt->fetch();

    if ($parcela && $parcela['status'] == 'pendente') {
        $descricao = "Parcela {$parcela['numero_parcela']} - Curso";
        
        if ($negociacao['forma_pagamento'] == 'pix') {
            $response = criarLinkPagamentoPix($parcela['valor'], $descricao);
        } else {
            $response = criarLinkPagamentoCartao($parcela['valor'], 1, $descricao);
        }

        if ($response && isset($response['payment_link'])) {
            // Atualizar parcela com o link
            $stmt = $pdo->prepare("
                UPDATE parcelas_negociacao 
                SET link_pagamento = ?, transaction_id = ?
                WHERE id = ?
            ");
            $stmt->execute([$response['payment_link'], $response['id'], $parcela_id]);
            
            $success = 'Link de pagamento gerado com sucesso!';
            
            // Recarregar parcelas
            $stmt = $pdo->prepare("SELECT * FROM parcelas_negociacao WHERE negociacao_id = ? ORDER BY numero_parcela");
            $stmt->execute([$negociacao_id]);
            $parcelas = $stmt->fetchAll();
        } else {
            $error = 'Erro ao gerar link de pagamento.';
        }
    }
}
?>

<div class="row">
    <div class="col-12 mb-4">
        <div class="custom-card">
            <div class="card-header">
                <h5 class="mb-0">Detalhes da Negociação #<?php echo $negociacao_id; ?></h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Dados do Aluno</h6>
                        <p><strong>Nome:</strong> <?php echo htmlspecialchars($negociacao['aluno_nome']); ?></p>
                        <p><strong>Email:</strong> <?php echo htmlspecialchars($negociacao['aluno_email']); ?></p>
                        <p><strong>CPF:</strong> <?php echo htmlspecialchars($negociacao['aluno_cpf']); ?></p>
                        <p><strong>Telefone:</strong> <?php echo htmlspecialchars($negociacao['aluno_telefone']); ?></p>
                    </div>
                    <div class="col-md-6">
                        <h6>Dados da Negociação</h6>
                        <p><strong>Valor Total:</strong> R$ <?php echo number_format($negociacao['valor_total'], 2, ',', '.'); ?></p>
                        <p><strong>Tipo:</strong> <?php echo $negociacao['tipo_valor'] == 'integral' ? 'Valor Integral' : 'Valor Bolsista'; ?></p>
                        <p><strong>Forma de Pagamento:</strong> <?php echo $negociacao['forma_pagamento'] == 'credito' ? 'Cartão de Crédito' : 'PIX'; ?></p>
                        <p><strong>Número de Parcelas:</strong> <?php echo $negociacao['num_parcelas']; ?></p>
                        <p><strong>Status:</strong> 
                            <span class="badge bg-<?php 
                                echo $negociacao['status'] == 'aprovada' ? 'success' : 
                                    ($negociacao['status'] == 'pendente' ? 'warning' : 'danger');
                            ?>">
                                <?php echo ucfirst($negociacao['status']); ?>
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="custom-card">
            <div class="card-header">
                <h5 class="mb-0">Parcelas</h5>
            </div>
            <div class="card-body">
                <?php if (isset($success)): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Parcela</th>
                                <th>Valor (Integral Vigente)</th>
                                <th>Valor</th>
                                <th>Vencimento</th>
                                <th>Status</th>
                                <th>Link de Pagamento</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($parcelas as $parcela): ?>
                                <tr>
                                    <td><?php echo $parcela['numero_parcela']; ?>ª Parcela</td>
                                    <td>
                                        R$ <?php echo number_format($parcela['valor'], 2, ',', '.'); ?>
                                    </td>
                                    <td><?php echo date('d/m/Y', strtotime($parcela['data_vencimento'])); ?></td>
                                    <td>
                                        <span class="badge bg-<?php 
                                            echo $parcela['status'] == 'pago' ? 'success' : 
                                                ($parcela['status'] == 'pendente' ? 'warning' : 'danger');
                                        ?>">
                                            <?php echo ucfirst($parcela['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($parcela['link_pagamento']): ?>
                                            <a href="<?php echo $parcela['link_pagamento']; ?>" 
                                               target="_blank" class="btn btn-sm btn-success">
                                                Ver Link
                                            </a>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($parcela['status'] == 'pendente' && !$parcela['link_pagamento']): ?>
                                            <form method="POST" action="" class="d-inline">
                                                <input type="hidden" name="parcela_id" value="<?php echo $parcela['id']; ?>">
                                                <button type="submit" name="gerar_link" class="btn btn-sm btn-primary">
                                                    Gerar Link
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
