<?php
require_once '../includes/config.php';
require_once __DIR__ . '/helpers_voucher.php';

$especialista_id = $_SESSION['especialista_id'];

// Verificar se há um aluno pré-selecionado
$aluno_pre_selecionado = isset($_GET['aluno_id']) ? intval($_GET['aluno_id']) : null;

// Buscar vouchers vigentes do especialista
$vouchers_vigentes = getVouchersVigentes($pdo, $especialista_id);

// Buscar APENAS alunos deste especialista que NÃO estão vinculados a nenhum lead
$stmt = $pdo->prepare("
    SELECT 
        a.id, 
        a.nome, 
        a.email, 
        a.celular, 
        a.data_cadastro,
        a.tipo_contrato
    FROM alunos a
    LEFT JOIN vinculo v ON a.id = v.aluno_id AND v.status = 'ativo'
    WHERE a.status = 'ativo'
    AND a.especialista_id = ?
    AND v.id IS NULL
    ORDER BY a.data_cadastro DESC 
    LIMIT 100
");
$stmt->execute([$especialista_id]);
$alunos = $stmt->fetchAll();

$especialista_id = $_SESSION['especialista_id'];

// Buscar valor integral ativo do curso
$stmt = $pdo->prepare("
    SELECT * FROM valores_curso 
    WHERE ativo = 1
    ORDER BY data_criacao DESC 
    LIMIT 1
");
$stmt->execute();
$valores_curso = $stmt->fetch();

// Se não houver valor configurado, usar padrão
if (!$valores_curso) {
    $valores_curso = [
        'valor_integral' => 5000.00,
        'ativo' => 0
    ];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $pdo->beginTransaction();

        // Usar apenas aluno existente
        if (empty($_POST['aluno_existente_id'])) {
            throw new Exception('É necessário selecionar um aluno existente.');
        }
        
        $aluno_id = (int)$_POST['aluno_existente_id'];
        
        // Verificar se o aluno pertence ao especialista
        $stmt = $pdo->prepare("SELECT id FROM alunos WHERE id = ? AND especialista_id = ?");
        $stmt->execute([$aluno_id, $especialista_id]);
        if (!$stmt->fetch()) {
            throw new Exception('Aluno não encontrado ou não pertence a este especialista.');
        }

        // Dados da negociação
        $tipo_valor = $_POST['tipo_valor'];
        $valor_base = $tipo_valor == 'integral' ? $valores_curso['valor_integral'] : $valores_curso['valor_bolsista'];
        $forma_pagamento = $_POST['forma_pagamento'];
        $num_parcelas = $_POST['num_parcelas'];

        // Aplicar desconto do voucher, se selecionado
        $valor_total = $valor_base;
        $voucher_id = !empty($_POST['voucher_id']) ? $_POST['voucher_id'] : null;
        $percentual_desconto = 0;
        if ($voucher_id) {
            $stmt = $pdo->prepare("SELECT percentual_desconto FROM vouchers WHERE id = ? AND especialista_id = ? AND ativo = 1");
            $stmt->execute([$voucher_id, $especialista_id]);
            $percentual_desconto = (float)($stmt->fetchColumn() ?: 0);
            if ($percentual_desconto > 0) {
                $valor_total = $valor_base * (1 - $percentual_desconto / 100);
            }
        }
        if ($forma_pagamento == 'credito' && $num_parcelas > 1) {
            $juros = 0.0199; // 1.99% ao mês
            $valor_total = $valor_total * pow(1 + $juros, $num_parcelas);
        }

        // Inserir negociação
        $stmt = $pdo->prepare("
            INSERT INTO negociacoes (aluno_id, especialista_id, valor_total, tipo_valor, forma_pagamento, num_parcelas)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$aluno_id, $especialista_id, $valor_total, $tipo_valor, $forma_pagamento, $num_parcelas]);
        $negociacao_id = $pdo->lastInsertId();

        // Criar parcelas
        if ($forma_pagamento == 'pix' && $num_parcelas == 2) {
            // Para PIX em 2x, criar duas parcelas com datas específicas
            $valor_parcela = $valor_total / 2;
            
            // Primeira parcela - hoje
            $stmt = $pdo->prepare("
                INSERT INTO parcelas_negociacao (negociacao_id, numero_parcela, valor, data_vencimento)
                VALUES (?, 1, ?, CURRENT_DATE)
            ");
            $stmt->execute([$negociacao_id, $valor_parcela]);

            // Segunda parcela - data especificada
            $data_segunda_parcela = $_POST['data_segunda_parcela'];
            $stmt = $pdo->prepare("
                INSERT INTO parcelas_negociacao (negociacao_id, numero_parcela, valor, data_vencimento)
                VALUES (?, 2, ?, ?)
            ");
            $stmt->execute([$negociacao_id, $valor_parcela, $data_segunda_parcela]);
        } else {
            // Para cartão de crédito, criar todas as parcelas
            $valor_parcela = $valor_total / $num_parcelas;
            for ($i = 1; $i <= $num_parcelas; $i++) {
                $data_vencimento = date('Y-m-d', strtotime("+".($i-1)." month"));
                $stmt = $pdo->prepare("
                    INSERT INTO parcelas_negociacao (negociacao_id, numero_parcela, valor, data_vencimento)
                    VALUES (?, ?, ?, ?)
                ");
                $stmt->execute([$negociacao_id, $i, $valor_parcela, $data_vencimento]);
            }
        }

        // Atualizar aluno com a negociação
        $stmt = $pdo->prepare("UPDATE alunos SET negociacao_id = ? WHERE id = ?");
        $stmt->execute([$negociacao_id, $aluno_id]);

        $pdo->commit();
        $success = 'Negociação criada com sucesso! Aguardando processamento do pagamento.';

        // Redirecionar para a página de pagamento
        header("Location: pagamento.php?negociacao_id=" . $negociacao_id);
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        $error = 'Erro ao criar negociação: ' . $e->getMessage();
    }
}
?>

<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="custom-card">
            <div class="card-header">
                <h5 class="mb-0">Nova Negociação</h5>
            </div>
            <div class="card-body">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <form method="POST" action="" id="formNegociacao">
                    <!-- Seção para selecionar aluno existente -->
                    <?php if (!empty($alunos)): ?>
                    <div class="custom-card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">
                                <i class="fas fa-users me-2"></i>Selecionar Aluno Existente
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8 mb-3">
                                    <label class="form-label">Aluno Cadastrado</label>
                                    <select class="form-control" id="alunoExistente" onchange="preencherDadosAluno()">
                                        <option value="">Criar nova negociação para aluno já cadastrado...</option>
                                        <?php foreach ($alunos as $aluno_existente): ?>
                                            <option value="<?php echo $aluno_existente['id']; ?>" 
                                                    data-nome="<?php echo htmlspecialchars($aluno_existente['nome']); ?>"
                                                    data-email="<?php echo htmlspecialchars($aluno_existente['email']); ?>"
                                                    data-celular="<?php echo htmlspecialchars($aluno_existente['celular']); ?>"
                                                    <?php echo ($aluno_pre_selecionado == $aluno_existente['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($aluno_existente['nome']); ?> - <?php echo htmlspecialchars($aluno_existente['email']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3 d-flex align-items-end">
                                    <button type="button" class="btn btn-outline-secondary" onclick="limparSelecao()">
                                        <i class="fas fa-eraser me-1"></i>Limpar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <h6 class="mb-3">Dados do Aluno</h6>
                    <div class="row" id="pagamento-row">
                    <div class="col-md-12 mb-3">
                        <div id="valorTotalBox" class="alert alert-success mb-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong style="font-size: 1.1rem;">💰 Valor Total:</strong>
                                    <div id="descontoInfo" class="text-muted small mt-1" style="display: none;">
                                        <i class="fas fa-tag"></i> Desconto aplicado: <span id="descontoPercentual">0%</span>
                                    </div>
                                </div>
                                <div>
                                    <span id="valorOriginal" class="text-muted small" style="display: none; text-decoration: line-through;">
                                        R$ <?php echo number_format($valores_curso['valor_integral'], 2, ',', '.'); ?>
                                    </span>
                                    <div id="valorTotalSpan" style="font-size: 1.5rem; font-weight: bold; color: #28a745;">
                                        R$ <?php echo number_format($valores_curso['valor_integral'], 2, ',', '.'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    </div>

                    <hr>

                    <h6 class="mb-3">Dados do Pagamento</h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Valor do Curso (Integral Vigente)</label>
                            <input type="text" class="form-control" value="R$ <?php echo number_format($valores_curso['valor_integral'], 2, ',', '.'); ?>" readonly>
                            <input type="hidden" name="tipo_valor" value="integral">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Forma de Pagamento</label>
                            <select name="forma_pagamento" class="form-control" required>
                                <option value="credito">Cartão de Crédito</option>
                                <option value="pix">PIX</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">
                                Voucher de Desconto
                                <small class="text-muted">(Opcional)</small>
                            </label>
                            <select name="voucher_id" id="voucherSelect" class="form-control">
                                <option value="" data-desconto="0">➖ Nenhum voucher selecionado</option>
                                <?php if (empty($vouchers_vigentes)): ?>
                                    <option value="" disabled>Nenhum voucher vigente disponível</option>
                                <?php else: ?>
                                    <?php foreach ($vouchers_vigentes as $voucher): ?>
                                        <option value="<?php echo $voucher['id']; ?>" 
                                                data-desconto="<?php echo (float)$voucher['percentual_desconto']; ?>"
                                                data-codigo="<?php echo htmlspecialchars($voucher['codigo']); ?>">
                                            🎟️ <?php echo htmlspecialchars($voucher['codigo']); ?> - 
                                            <strong><?php echo $voucher['percentual_desconto']; ?>% OFF</strong>
                                            <?php if ($voucher['valido_ate']): ?>
                                                (válido até <?php echo date('d/m/Y', strtotime($voucher['valido_ate'])); ?>)
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <small class="text-muted">Desconto será aplicado sobre o valor integral do curso</small>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Número de Parcelas</label>
                            <select name="num_parcelas" class="form-control" required>
                                <option value="1">1x (sem juros)</option>
                                <option value="2">2x</option>
                                <option value="3">3x</option>
                                <option value="4">4x</option>
                                <option value="5">5x</option>
                                <option value="6">6x</option>
                                <option value="7">7x</option>
                                <option value="8">8x</option>
                                <option value="9">9x</option>
                                <option value="10">10x</option>
                                <option value="11">11x</option>
                                <option value="12">12x</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3 d-none" id="segundaParcelaDiv">
                            <label class="form-label">Data da Segunda Parcela (PIX)</label>
                            <input type="date" name="data_segunda_parcela" class="form-control">
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">Criar Negociação</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
// Função para preencher dados do aluno selecionado
function preencherDadosAluno() {
    const select = document.getElementById('alunoExistente');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        // Adicionar campo hidden com ID do aluno
        let hiddenField = document.getElementById('aluno_existente_id');
        if (!hiddenField) {
            hiddenField = document.createElement('input');
            hiddenField.type = 'hidden';
            hiddenField.name = 'aluno_existente_id';
            hiddenField.id = 'aluno_existente_id';
            document.getElementById('formNegociacao').appendChild(hiddenField);
        }
        hiddenField.value = selectedOption.value;
        
    } else {
        limparSelecao();
    }
}

// Função para limpar seleção
function limparSelecao() {
    document.getElementById('alunoExistente').value = '';
    
    // Remover campo hidden
    const hiddenField = document.getElementById('aluno_existente_id');
    if (hiddenField) {
        hiddenField.remove();
    }
}

$(document).ready(function() {
    $('.cpf').mask('000.000.000-00');
    $('.telefone').mask('(00) 00000-0000');

    // Verificar se há aluno pré-selecionado
    <?php if ($aluno_pre_selecionado): ?>
        preencherDadosAluno();
    <?php endif; ?>

    function atualizarValorTotal() {
        var valorBase = <?php echo (float)$valores_curso['valor_integral']; ?>;
        var percentualDesconto = 0;
        var selectedVoucher = $('[name="voucher_id"] option:selected');
        
        if (selectedVoucher.length && selectedVoucher.val()) {
            percentualDesconto = parseFloat(selectedVoucher.data('desconto')) || 0;
        }
        
        var valorComDesconto = valorBase * (1 - percentualDesconto / 100);
        var numParcelas = parseInt($('[name="num_parcelas"]').val() || '1');
        var formaPagamento = $('[name="forma_pagamento"]').val();
        
        if (formaPagamento === 'credito' && numParcelas > 1) {
            var juros = 0.0199;
            valorComDesconto = valorComDesconto * Math.pow(1 + juros, numParcelas);
        }
        
        // Atualizar valor total
        $('#valorTotalSpan').text('R$ ' + valorComDesconto.toLocaleString('pt-BR', {minimumFractionDigits: 2, maximumFractionDigits: 2}));
        
        // Mostrar/esconder informações de desconto
        if (percentualDesconto > 0) {
            // Tem desconto - mostrar informações visuais
            $('#descontoInfo').show();
            $('#descontoPercentual').text(percentualDesconto + '%');
            $('#valorOriginal').show();
            
            // Mudar cor do box para amarelo (destaque)
            $('#valorTotalBox').removeClass('alert-success').addClass('alert-warning');
            
            console.log('Desconto aplicado:', {
                voucher: selectedVoucher.data('codigo'),
                percentual: percentualDesconto + '%',
                valorOriginal: valorBase,
                valorComDesconto: valorBase * (1 - percentualDesconto / 100),
                valorFinal: valorComDesconto
            });
        } else {
            // Sem desconto - esconder informações
            $('#descontoInfo').hide();
            $('#valorOriginal').hide();
            
            // Voltar cor verde
            $('#valorTotalBox').removeClass('alert-warning').addClass('alert-success');
        }
    }

    $('[name="voucher_id"], [name="num_parcelas"], [name="forma_pagamento"]').on('change', atualizarValorTotal);
    atualizarValorTotal();

    $('[name="forma_pagamento"], [name="num_parcelas"]').change(function() {
        const formaPagamento = $('[name="forma_pagamento"]').val();
        const numParcelas = $('[name="num_parcelas"]').val();

        // Mostrar/esconder campo de data da segunda parcela para PIX
        if (formaPagamento === 'pix') {
            $('[name="num_parcelas"]').html('<option value="1">1x</option><option value="2">2x</option>');
            if (numParcelas === '2') {
                $('#segundaParcelaDiv').removeClass('d-none');
            } else {
                $('#segundaParcelaDiv').addClass('d-none');
            }
        } else {
            $('#segundaParcelaDiv').addClass('d-none');
            $('[name="num_parcelas"]').html(`
                <option value="1">1x (sem juros)</option>
                <option value="2">2x</option>
                <option value="3">3x</option>
                <option value="4">4x</option>
                <option value="5">5x</option>
                <option value="6">6x</option>
                <option value="7">7x</option>
                <option value="8">8x</option>
                <option value="9">9x</option>
                <option value="10">10x</option>
                <option value="11">11x</option>
                <option value="12">12x</option>
            `);
        }
        atualizarValorTotal();
    });
});
</script>
