<?php
require_once '../../includes/config.php';
require_once '../../includes/aprovacao_automatica.php';

// ID da negociação para testar
$negociacao_id = $_GET['negociacao_id'] ?? null;

if (!$negociacao_id) {
    echo "<h2>Teste de Aprovação Automática</h2>";
    echo "<p>Use: testar_aprovacao.php?negociacao_id=5</p>";
    exit;
}

echo "<h2>Testando Aprovação Automática</h2>";
echo "<p>Negociação ID: #$negociacao_id</p>";
echo "<hr>";

// Verificar status atual
$stmt = $pdo->prepare("
    SELECT n.*, a.nome, a.data_aceite_contrato
    FROM negociacoes n
    INNER JOIN alunos a ON n.aluno_id = a.id
    WHERE n.id = ?
");
$stmt->execute([$negociacao_id]);
$neg = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$neg) {
    echo "<div style='color:red'>❌ Negociação não encontrada!</div>";
    exit;
}

echo "<h3>Status Atual:</h3>";
echo "<ul>";
echo "<li><strong>Cliente:</strong> {$neg['nome']}</li>";
echo "<li><strong>Valor Total:</strong> R$ " . number_format($neg['valor_total'], 2, ',', '.') . "</li>";
echo "<li><strong>Status Negociação:</strong> {$neg['status']}</li>";
echo "<li><strong>Pagamento Confirmado:</strong> " . ($neg['pagamento_confirmado'] ? '✅ SIM' : '❌ NÃO') . "</li>";
echo "<li><strong>Contrato Aceito:</strong> " . ($neg['data_aceite_contrato'] ? '✅ SIM (' . $neg['data_aceite_contrato'] . ')' : '❌ NÃO') . "</li>";
echo "</ul>";

echo "<h3>Tentando Aprovar Automaticamente...</h3>";

$resultado = verificarAprovacaoAutomatica($pdo, $negociacao_id);

echo "<pre>";
print_r($resultado);
echo "</pre>";

if ($resultado['aprovada'] ?? false) {
    echo "<div style='background:#28a745;color:white;padding:20px;border-radius:8px;'>";
    echo "<h3>🎉 NEGOCIAÇÃO APROVADA AUTOMATICAMENTE!</h3>";
    echo "<p>O lead deveria estar na coluna 'Aprovada' agora.</p>";
    echo "</div>";
} else {
    echo "<div style='background:#ffc107;color:#000;padding:20px;border-radius:8px;'>";
    echo "<h3>⏳ Aprovação Pendente</h3>";
    echo "<p><strong>Motivos:</strong></p>";
    echo "<ul>";
    if (!empty($resultado['motivos_pendentes'])) {
        foreach ($resultado['motivos_pendentes'] as $motivo) {
            echo "<li>$motivo</li>";
        }
    }
    echo "</ul>";
    echo "</div>";
}

echo "<hr>";
echo "<a href='../index.php?page=atendimentos'>← Voltar para Atendimentos</a>";
?>

