<?php
if (!isset($_SESSION['especialista_id'])) {
    header('Location: ../login.php');
    exit();
}

$especialista_id = $_SESSION['especialista_id'];

// Buscar vouchers disponíveis para este especialista (globais + individuais)
require_once 'helpers_voucher.php';
$vouchers = getVouchersVigentes($pdo, $especialista_id);

// Buscar estatísticas de uso dos vouchers deste especialista
$stmt = $pdo->prepare("
    SELECT 
        COUNT(DISTINCT n.id) as total_usos,
        SUM(n.valor_total) as valor_total_vendas,
        COUNT(DISTINCT v.id) as total_vouchers_disponiveis
    FROM vouchers v
    LEFT JOIN voucher_especialista ve ON v.id = ve.voucher_id
    LEFT JOIN negociacoes n ON v.id = n.voucher_id AND n.especialista_id = ?
    WHERE v.ativo = 1
    AND v.quantidade_usada < v.quantidade_total
    AND (v.tipo = 'global' OR ve.especialista_id = ?)
");
$stmt->execute([$especialista_id, $especialista_id]);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-ticket-alt me-2"></i>
        Meus Vouchers de Desconto
    </h1>
    <p class="page-subtitle">Visualize os vouchers disponíveis para usar nas negociações</p>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="custom-card">
            <div class="card-body text-center">
                <i class="fas fa-ticket-alt fa-2x text-primary mb-2"></i>
                <h3 class="mb-0"><?php echo count($vouchers); ?></h3>
                <p class="text-muted mb-0">Vouchers Disponíveis</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="custom-card">
            <div class="card-body text-center">
                <i class="fas fa-chart-line fa-2x text-success mb-2"></i>
                <h3 class="mb-0"><?php echo $stats['total_usos'] ?? 0; ?></h3>
                <p class="text-muted mb-0">Vezes Utilizados</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="custom-card">
            <div class="card-body text-center">
                <i class="fas fa-dollar-sign fa-2x text-info mb-2"></i>
                <h3 class="mb-0">R$ <?php echo number_format($stats['valor_total_vendas'] ?? 0, 2, ',', '.'); ?></h3>
                <p class="text-muted mb-0">Total em Vendas</p>
            </div>
        </div>
    </div>
</div>

<!-- Alerta Informativo -->
<div class="alert alert-primary">
    <i class="fas fa-info-circle me-2"></i>
    <strong>Informação:</strong> Apenas o administrador pode criar novos vouchers. 
    Os vouchers criados pelo admin aparecerão automaticamente aqui.
</div>

<div class="custom-card">
    <div class="card-header">
        <h5 class="card-title">
            <i class="fas fa-list me-2"></i>
            Vouchers Disponíveis para Uso
        </h5>
        <span class="badge bg-primary"><?php echo count($vouchers); ?></span>
    </div>
    <div class="card-body">
        <?php if (empty($vouchers)): ?>
            <div class="text-center py-5">
                <i class="fas fa-ticket-alt fa-3x text-muted mb-3"></i>
                <p class="text-muted">Nenhum voucher disponível no momento</p>
                <small class="text-muted">O administrador pode criar vouchers para você em: Admin → Vouchers</small>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Desconto</th>
                            <th>Tipo</th>
                            <th>Quantidade Disponível</th>
                            <th>Validade</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($vouchers as $voucher): ?>
                            <?php
                            $hoje = date('Y-m-d');
                            $expirado = $voucher['valido_ate'] && $voucher['valido_ate'] < $hoje;
                            $disponiveis = $voucher['quantidade_total'] - $voucher['quantidade_usada'];
                            $esgotado = $disponiveis <= 0;
                            
                            // Determinar status e cor
                            if ($esgotado) {
                                $status_class = 'secondary';
                                $status_text = 'Esgotado';
                            } elseif ($expirado) {
                                $status_class = 'warning';
                                $status_text = 'Expirado';
                            } else {
                                $status_class = 'success';
                                $status_text = 'Disponível';
                            }
                            ?>
                            <tr class="<?php echo $esgotado || $expirado ? 'table-secondary' : ''; ?>">
                                <td>
                                    <strong class="text-primary" style="font-size: 1.1rem;">
                                        <?php echo htmlspecialchars($voucher['codigo']); ?>
                                    </strong>
                                </td>
                                <td>
                                    <span class="badge bg-success" style="font-size: 1rem;">
                                        <?php echo number_format($voucher['percentual_desconto'], 0); ?>%
                                    </span>
                                </td>
                                <td>
                                    <?php
                                    // Determinar tipo (global ou individual) baseado na query
                                    // Como a query já filtra, vamos verificar quantidade de especialistas
                                    $stmt_temp = $pdo->prepare("SELECT COUNT(*) FROM voucher_especialista WHERE voucher_id = ?");
                                    $stmt_temp->execute([$voucher['id']]);
                                    $total_especialistas = $stmt_temp->fetchColumn();
                                    
                                    $stmt_temp = $pdo->prepare("SELECT tipo FROM vouchers WHERE id = ?");
                                    $stmt_temp->execute([$voucher['id']]);
                                    $tipo_voucher = $stmt_temp->fetchColumn();
                                    
                                    if ($tipo_voucher === 'global'): ?>
                                        <span class="badge bg-warning text-dark">
                                            <i class="fas fa-globe me-1"></i>GLOBAL
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-info">
                                            <i class="fas fa-user me-1"></i>INDIVIDUAL
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    // Calcular disponível baseado no tipo
                                    $usado = $voucher['quantidade_usada'];
                                    $total = $voucher['quantidade_total'];
                                    $disponivel = $total - $usado;
                                    ?>
                                    <strong class="text-<?php echo $disponivel > 0 ? 'success' : 'danger'; ?>">
                                        <?php echo $disponivel; ?>
                                    </strong>
                                    <small class="text-muted">
                                        / <?php echo $total; ?>
                                    </small>
                                    <?php if ($disponivel <= 0): ?>
                                        <span class="badge bg-danger ms-2">Esgotado</span>
                                    <?php endif; ?>
                                    <?php if ($voucher['tipo'] === 'global'): ?>
                                        <br><small class="text-info">
                                            <i class="fas fa-info-circle me-1"></i>Por especialista
                                        </small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php 
                                    if ($voucher['valido_ate']) {
                                        echo date('d/m/Y', strtotime($voucher['valido_ate']));
                                        if ($expirado) {
                                            echo ' <span class="badge bg-warning">Expirado</span>';
                                        }
                                    } else {
                                        echo '<span class="text-success">Sem prazo</span>';
                                    }
                                    ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo $status_class; ?>">
                                        <?php echo $status_text; ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="alert alert-info mt-4">
    <h6><i class="fas fa-info-circle me-2"></i>Como funcionam os vouchers:</h6>
    <ul class="mb-0">
        <li><strong>Vouchers GLOBAIS:</strong> Criados pelo admin e disponíveis para todos os especialistas ativos</li>
        <li><strong>Vouchers INDIVIDUAIS:</strong> Criados pelo admin e atribuídos especificamente a você</li>
        <li><strong>Quantidade:</strong> Cada voucher tem um número limitado de usos disponíveis</li>
        <li><strong>Uso:</strong> Ao criar uma negociação no Kanban, selecione o voucher desejado para aplicar o desconto</li>
        <li><strong>Validade:</strong> Alguns vouchers podem ter prazo de expiração definido pelo admin</li>
    </ul>
</div>

<div class="alert alert-warning mt-4">
    <i class="fas fa-user-shield me-2"></i>
    <strong>Atenção:</strong> Para solicitar novos vouchers, entre em contato com o administrador do sistema.
</div>

