@extends('layouts.admin')

@section('title', 'Editar Comissão')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.comissoes.index') }}">Comissões</a></li>
            <li class="breadcrumb-item active">Editar</li>
        </ol>
    </nav>
    <h1 class="content-title">Editar Comissão #{{ $comissao->id }}</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.comissoes.update', $comissao->id) }}">
            @csrf
            @method('PUT')

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="especialista_id" class="form-label">Especialista *</label>
                    <select class="form-select @error('especialista_id') is-invalid @enderror" id="especialista_id" name="especialista_id" required>
                        <option value="">Selecione um especialista...</option>
                        @foreach($especialistas as $especialista)
                            <option value="{{ $especialista->id }}" {{ old('especialista_id', $comissao->especialista_id) == $especialista->id ? 'selected' : '' }}>
                                {{ $especialista->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('especialista_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6">
                    <label class="form-label">Negociação</label>
                    <input type="text" class="form-control" value="ID: {{ $comissao->negociacao_id }}" disabled>
                    <small class="text-muted">A negociação não pode ser alterada</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="percentual" class="form-label">Percentual (%) *</label>
                    <input type="number" step="0.01" min="0" max="100" class="form-control @error('percentual') is-invalid @enderror" 
                           id="percentual" name="percentual" value="{{ old('percentual', $comissao->percentual) }}" required>
                    @error('percentual')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4">
                    <label for="valor" class="form-label">Valor da Comissão (R$) *</label>
                    <input type="number" step="0.01" min="0" class="form-control @error('valor') is-invalid @enderror" 
                           id="valor" name="valor" value="{{ old('valor', $comissao->valor) }}" required>
                    @error('valor')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4">
                    <label for="data_prevista" class="form-label">Data Prevista para Pagamento *</label>
                    <input type="date" class="form-control @error('data_prevista') is-invalid @enderror" 
                           id="data_prevista" name="data_prevista" 
                           value="{{ old('data_prevista', $comissao->data_prevista ? \Carbon\Carbon::parse($comissao->data_prevista)->format('Y-m-d') : '') }}" required>
                    @error('data_prevista')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="status" class="form-label">Status *</label>
                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                    <option value="pendente" {{ old('status', $comissao->status) === 'pendente' ? 'selected' : '' }}>Pendente</option>
                    <option value="liberada" {{ old('status', $comissao->status) === 'liberada' ? 'selected' : '' }}>Liberada</option>
                    <option value="paga" {{ old('status', $comissao->status) === 'paga' ? 'selected' : '' }}>Paga</option>
                </select>
                @error('status')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="text-end">
                <a href="{{ route('admin.comissoes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

