@extends('layouts.admin')

@section('title', 'Detalhes da Comissão')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.comissoes.index') }}">Comissões</a></li>
                <li class="breadcrumb-item active">#{{ $comissao->id }}</li>
            </ol>
        </nav>
        <h1 class="content-title">Comissão #{{ $comissao->id }}</h1>
    </div>
    <div>
        <a href="{{ route('admin.comissoes.edit', $comissao->id) }}" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i>Editar
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-white border-bottom">
                <h5 class="mb-0">Informações da Comissão</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="200">ID:</th>
                        <td><strong>#{{ $comissao->id }}</strong></td>
                    </tr>
                    <tr>
                        <th>Especialista:</th>
                        <td>
                            <strong>{{ $comissao->especialista_nome }}</strong>
                            <br>
                            <small class="text-muted">{{ $comissao->especialista_email }}</small>
                        </td>
                    </tr>
                    <tr>
                        <th>Lead:</th>
                        <td>
                            {{ $comissao->lead_nome ?? '-' }}
                            @if($comissao->lead_email)
                                <br>
                                <small class="text-muted">{{ $comissao->lead_email }}</small>
                            @endif
                            @if($comissao->lead_telefone)
                                <br>
                                <small class="text-muted">{{ $comissao->lead_telefone }}</small>
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th>Negociação:</th>
                        <td>
                            <strong>ID: {{ $comissao->negociacao_id }}</strong>
                            <br>
                            <small class="text-muted">Valor: R$ {{ number_format($comissao->negociacao_valor, 2, ',', '.') }}</small>
                            <br>
                            <small class="text-muted">Status: 
                                <span class="badge bg-{{ $comissao->negociacao_status === 'fechado' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($comissao->negociacao_status) }}
                                </span>
                            </small>
                        </td>
                    </tr>
                    <tr>
                        <th>Percentual:</th>
                        <td><strong>{{ number_format($comissao->percentual, 2, ',', '.') }}%</strong></td>
                    </tr>
                    <tr>
                        <th>Valor da Comissão:</th>
                        <td>
                            <h4 class="text-success mb-0">R$ {{ number_format($comissao->valor, 2, ',', '.') }}</h4>
                        </td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            @php
                                $badges = [
                                    'pendente' => 'warning',
                                    'liberada' => 'info',
                                    'paga' => 'success',
                                ];
                                $badge = $badges[$comissao->status] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badge }} fs-6">
                                {{ ucfirst($comissao->status) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Data Prevista:</th>
                        <td>
                            @if($comissao->data_prevista)
                                {{ \Carbon\Carbon::parse($comissao->data_prevista)->format('d/m/Y') }}
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header bg-white border-bottom">
                <h5 class="mb-0">Ações Rápidas</h5>
            </div>
            <div class="card-body">
                @if($comissao->status !== 'paga')
                <button type="button" class="btn btn-success w-100 mb-2" onclick="atualizarStatus('{{ $comissao->status }}')">
                    <i class="fas fa-sync me-2"></i>Atualizar Status
                </button>
                @endif
                <a href="{{ route('admin.comissoes.index') }}" class="btn btn-secondary w-100">
                    <i class="fas fa-arrow-left me-2"></i>Voltar para Lista
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function atualizarStatus(statusAtual) {
    const novoStatus = statusAtual === 'pendente' ? 'liberada' : 'paga';
    
    if (confirm(`Deseja atualizar o status para "${novoStatus}"?`)) {
        fetch('{{ route("admin.comissoes.index") }}/{{ $comissao->id }}/toggle-status', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ status: novoStatus })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Erro: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao atualizar status');
        });
    }
}
</script>
@endpush

