@extends('layouts.admin')

@section('title', 'Configurações')

@section('content')
<div class="content-header">
    <h1 class="content-title">Configurações do Sistema</h1>
    <p class="content-subtitle">Configurações gerais e parâmetros do sistema</p>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.configuracoes.update') }}">
            @csrf
            
            <h5 class="mb-3">Informações Gerais</h5>
            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Nome do Sistema</label>
                    <input type="text" class="form-control" name="nome_sistema" value="{{ $config['nome_sistema'] }}" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Email do Sistema</label>
                    <input type="email" class="form-control" name="email_sistema" value="{{ $config['email_sistema'] }}" required>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Telefone do Sistema</label>
                    <input type="text" class="form-control" name="telefone_sistema" value="{{ $config['telefone_sistema'] }}">
                </div>
            </div>

            <hr class="my-4">

            <h5 class="mb-3">Configurações de Leads</h5>
            <div class="row mb-4">
                <div class="col-md-4">
                    <label class="form-label">Distribuição Automática</label>
                    <select class="form-select" name="distribuicao_automatica">
                        <option value="1" {{ $config['distribuicao_automatica'] == '1' ? 'selected' : '' }}>Ativada</option>
                        <option value="0" {{ $config['distribuicao_automatica'] == '0' ? 'selected' : '' }}>Desativada</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Tempo de Resposta (horas)</label>
                    <input type="number" class="form-control" name="tempo_resposta_lead" value="{{ $config['tempo_resposta_lead'] }}" min="1" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Meta de Conversão (%)</label>
                    <input type="number" class="form-control" name="meta_conversao" value="{{ $config['meta_conversao'] }}" min="0" max="100" step="0.1" required>
                </div>
            </div>

            <hr class="my-4">

            <h5 class="mb-3">Configurações Financeiras</h5>
            <div class="row mb-4">
                <div class="col-md-6">
                    <label class="form-label">Comissão Padrão (%)</label>
                    <input type="number" class="form-control" name="comissao_padrao" value="{{ $config['comissao_padrao'] }}" min="0" max="100" step="0.1" required>
                </div>
            </div>

            <div class="text-end">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="fas fa-save me-2"></i>Salvar Configurações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

