@extends('layouts.admin')

@section('title', 'Novo Contrato')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.contratos.index') }}">Contratos</a></li>
            <li class="breadcrumb-item active">Novo</li>
        </ol>
    </nav>
    <h1 class="content-title">Novo Contrato</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.contratos.store') }}" enctype="multipart/form-data">
            @csrf

            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Atenção:</strong> Faça upload do arquivo PDF do contrato. O sistema desativará automaticamente contratos anteriores do mesmo tipo.
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="tipo" class="form-label">Tipo de Contrato *</label>
                    <select class="form-select @error('tipo') is-invalid @enderror" id="tipo" name="tipo" required>
                        <option value="">Selecione...</option>
                        <option value="regular" {{ old('tipo') === 'regular' ? 'selected' : '' }}>Regular</option>
                        <option value="bolsista" {{ old('tipo') === 'bolsista' ? 'selected' : '' }}>Bolsista</option>
                    </select>
                    @error('tipo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6">
                    <label for="arquivo" class="form-label">Arquivo PDF *</label>
                    <input type="file" class="form-control @error('arquivo') is-invalid @enderror" 
                           id="arquivo" name="arquivo" accept=".pdf" required>
                    @error('arquivo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Apenas arquivos PDF (máx. 20MB)</small>
                </div>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.contratos.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-upload me-2"></i>Enviar Contrato
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

