@extends('layouts.admin')

@section('title', 'Contratos')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Contratos</h1>
        <p class="content-subtitle">Gerenciamento de contratos do sistema</p>
    </div>
    <a href="{{ route('admin.contratos.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Contrato
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Arquivo</th>
                        <th>Tipo</th>
                        <th>Ano</th>
                        <th>Status</th>
                        <th>Upload Por</th>
                        <th>Data Upload</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($contratos as $contrato)
                    <tr>
                        <td><code>{{ $contrato->arquivo }}</code></td>
                        <td>
                            @php
                                $tipos = [
                                    'regular' => 'Regular',
                                    'bolsista' => 'Bolsista',
                                ];
                            @endphp
                            <span class="badge bg-info">{{ $tipos[$contrato->tipo] ?? $contrato->tipo }}</span>
                        </td>
                        <td>{{ $contrato->ano ?? '-' }}</td>
                        <td>
                            <span class="badge bg-{{ $contrato->ativo ? 'success' : 'secondary' }}">
                                {{ $contrato->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                        <td>{{ $contrato->criador?->nome ?? '-' }}</td>
                        <td>{{ $contrato->data_upload ? \Carbon\Carbon::parse($contrato->data_upload)->format('d/m/Y H:i') : '-' }}</td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.contratos.show', $contrato->id) }}" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn btn-outline-{{ $contrato->ativo ? 'warning' : 'success' }}" 
                                        onclick="toggleStatus({{ $contrato->id }})" 
                                        title="{{ $contrato->ativo ? 'Desativar' : 'Ativar' }}">
                                    <i class="fas fa-{{ $contrato->ativo ? 'toggle-on' : 'toggle-off' }}"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum contrato encontrado</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($contratos->hasPages())
            <div class="mt-3">
                {{ $contratos->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/contratos/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
@endpush

