@extends('layouts.admin')

@section('title', 'Detalhes do Contrato')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.contratos.index') }}">Contratos</a></li>
                <li class="breadcrumb-item active">{{ $contrato->numero }}</li>
            </ol>
        </nav>
        <h1 class="content-title">Contrato {{ $contrato->numero }}</h1>
    </div>
    <a href="{{ route('admin.contratos.edit', $contrato->id) }}" class="btn btn-primary">
        <i class="fas fa-edit me-2"></i>Editar
    </a>
</div>

<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th>Arquivo:</th>
                        <td><code>{{ $contrato->arquivo }}</code></td>
                    </tr>
                    <tr>
                        <th>Tipo:</th>
                        <td>
                            @php
                                $tipos = [
                                    'regular' => 'Regular',
                                    'bolsista' => 'Bolsista',
                                ];
                            @endphp
                            <span class="badge bg-info">{{ $tipos[$contrato->tipo] ?? $contrato->tipo }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Ano:</th>
                        <td>{{ $contrato->ano ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $contrato->ativo ? 'success' : 'secondary' }}">
                                {{ $contrato->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Upload Por:</th>
                        <td>{{ $contrato->criador?->nome ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Data Upload:</th>
                        <td>{{ $contrato->data_upload ? \Carbon\Carbon::parse($contrato->data_upload)->format('d/m/Y H:i') : '-' }}</td>
                    </tr>
                </table>

                <div class="text-center mt-4">
                    @if($contrato->arquivo)
                        <a href="{{ asset('storage/contratos/' . $contrato->arquivo) }}" target="_blank" class="btn btn-primary btn-lg">
                            <i class="fas fa-file-pdf me-2"></i>Visualizar PDF
                        </a>
                        <a href="{{ asset('storage/contratos/' . $contrato->arquivo) }}" download class="btn btn-success btn-lg">
                            <i class="fas fa-download me-2"></i>Baixar PDF
                        </a>
                    @else
                        <p class="text-muted">Arquivo não encontrado</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

