@extends('layouts.admin')

@section('title', 'Nova Equipe')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.equipes.index') }}">Equipes</a></li>
            <li class="breadcrumb-item active">Nova</li>
        </ol>
    </nav>
    <h1 class="content-title">Nova Equipe</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.equipes.store') }}">
            @csrf

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nome" class="form-label">Nome da Equipe *</label>
                    <input type="text" class="form-control @error('nome') is-invalid @enderror" 
                           id="nome" name="nome" value="{{ old('nome') }}" required>
                    @error('nome')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6">
                    <label for="coordenador_id" class="form-label">Coordenador *</label>
                    <select class="form-select @error('coordenador_id') is-invalid @enderror" 
                            id="coordenador_id" name="coordenador_id" required>
                        <option value="">Selecione...</option>
                        @foreach($coordenadores as $coord)
                            <option value="{{ $coord->id }}" {{ old('coordenador_id') == $coord->id ? 'selected' : '' }}>
                                {{ $coord->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('coordenador_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="meta_mensal" class="form-label">Meta Mensal</label>
                    <input type="number" class="form-control" id="meta_mensal" name="meta_mensal" 
                           value="{{ old('meta_mensal', 0) }}" min="0">
                </div>
                <div class="col-md-6">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="ativo" {{ old('status') === 'ativo' ? 'selected' : '' }}>Ativo</option>
                        <option value="inativo" {{ old('status') === 'inativo' ? 'selected' : '' }}>Inativo</option>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Especialistas</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    @forelse($especialistas as $esp)
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="especialistas[]" 
                                   value="{{ $esp->id }}" id="esp{{ $esp->id }}">
                            <label class="form-check-label" for="esp{{ $esp->id }}">
                                {{ $esp->nome }}
                            </label>
                        </div>
                    @empty
                        <p class="text-muted">Nenhum especialista disponível</p>
                    @endforelse
                </div>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.equipes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Equipe
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

