@extends('layouts.admin')

@section('title', 'Editar Equipe')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.equipes.index') }}">Equipes</a></li>
            <li class="breadcrumb-item active">Editar</li>
        </ol>
    </nav>
    <h1 class="content-title">Editar Equipe</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.equipes.update', $equipe->id) }}">
            @csrf
            @method('PUT')

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nome" class="form-label">Nome da Equipe *</label>
                    <input type="text" class="form-control" id="nome" name="nome" 
                           value="{{ old('nome', $equipe->nome) }}" required>
                </div>
                <div class="col-md-6">
                    <label for="coordenador_id" class="form-label">Coordenador *</label>
                    <select class="form-select" id="coordenador_id" name="coordenador_id" required>
                        @foreach($coordenadores as $coord)
                            <option value="{{ $coord->id }}" {{ old('coordenador_id', $equipe->coordenador_id) == $coord->id ? 'selected' : '' }}>
                                {{ $coord->nome }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="meta_mensal" class="form-label">Meta Mensal</label>
                    <input type="number" class="form-control" id="meta_mensal" name="meta_mensal" 
                           value="{{ old('meta_mensal', $equipe->meta_mensal) }}" min="0">
                </div>
                <div class="col-md-6">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="ativo" {{ old('status', $equipe->status) === 'ativo' ? 'selected' : '' }}>Ativo</option>
                        <option value="inativo" {{ old('status', $equipe->status) === 'inativo' ? 'selected' : '' }}>Inativo</option>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Especialistas</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    @foreach($especialistas as $esp)
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="especialistas[]" 
                                   value="{{ $esp->id }}" id="esp{{ $esp->id }}"
                                   {{ in_array($esp->id, $especialistasVinculados) ? 'checked' : '' }}>
                            <label class="form-check-label" for="esp{{ $esp->id }}">
                                {{ $esp->nome }}
                            </label>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.equipes.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

