@extends('layouts.admin')

@section('title', 'Equipes')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Equipes</h1>
        <p class="content-subtitle">Gerenciamento de equipes de vendas</p>
    </div>
    <a href="{{ route('admin.equipes.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Equipe
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Coordenador</th>
                        <th>Especialistas</th>
                        <th>Meta Mensal</th>
                        <th>Status</th>
                        <th>Data Criação</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($equipes as $equipe)
                    <tr>
                        <td><strong>{{ $equipe->nome }}</strong></td>
                        <td>{{ $equipe->coordenador?->nome ?? '-' }}</td>
                        <td>
                            <span class="badge bg-primary">{{ $equipe->especialistas_count ?? 0 }}</span>
                        </td>
                        <td>{{ $equipe->meta_mensal > 0 ? number_format($equipe->meta_mensal, 0) : '-' }}</td>
                        <td>
                            <span class="badge bg-{{ $equipe->status === 'ativo' ? 'success' : 'secondary' }}">
                                {{ ucfirst($equipe->status) }}
                            </span>
                        </td>
                        <td>-</td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.equipes.show', $equipe->id) }}" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.equipes.edit', $equipe->id) }}" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma equipe encontrada</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($equipes->hasPages())
            <div class="mt-3">
                {{ $equipes->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

