@if($leadsAguardando->count() > 0)
    @foreach($leadsAguardando as $lead)
        <div class="lead-card border rounded p-3 bg-white" draggable="true" data-lead-id="{{ $lead->id }}" style="cursor: move;">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <h6 class="fw-bold mb-1">
                        <i class="fas fa-grip-vertical me-2 text-muted"></i>
                        {{ $lead->nome }}
                    </h6>
                    <small class="text-muted d-block">
                        <i class="fas fa-envelope me-1"></i>
                        {{ $lead->email }}
                    </small>
                    <small class="text-muted d-block">
                        <i class="fas fa-phone me-1"></i>
                        {{ $lead->telefone }}
                    </small>
                    @if($lead->data_cadastro)
                    <small class="text-muted d-block">
                        <i class="fas fa-calendar me-1"></i>
                        {{ \Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y H:i') }}
                    </small>
                    @endif
                </div>
                <div>
                    @php
                        $statusDisplay = ucfirst(str_replace('_', ' ', $lead->etapa ?? 'novo'));
                        $badgeClass = 'bg-warning text-dark';
                        
                        switch($lead->etapa) {
                            case 'novo':
                                $badgeClass = 'bg-warning text-dark';
                                break;
                            case 'demo':
                                $badgeClass = 'bg-info text-white';
                                $statusDisplay = 'Em Negociação';
                                break;
                            case 'fechamento':
                                $badgeClass = 'bg-success';
                                $statusDisplay = 'Aprovada';
                                break;
                            case 'perdido':
                                $badgeClass = 'bg-danger';
                                $statusDisplay = 'Perdida';
                                break;
                        }
                    @endphp
                    <span class="badge {{ $badgeClass }} mb-2">{{ $statusDisplay }}</span>
                    <br>
                    <small class="text-muted">ID: {{ $lead->id }}</small>
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="text-center py-5 text-muted">
        <i class="fas fa-check-circle fa-3x mb-3"></i>
        <p>Nenhum lead aguardando.</p>
    </div>
@endif

