@extends('layouts.admin')

@section('title', 'Detalhes do Lead')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.leads.index') }}">Leads</a></li>
            <li class="breadcrumb-item active">Lead #{{ $lead->id }}</li>
        </ol>
    </nav>
    <h1 class="content-title">{{ $lead->nome }}</h1>
</div>

<div class="row">
    <!-- Informações do Lead -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações do Lead</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="150">Nome:</th>
                        <td>{{ $lead->nome }}</td>
                    </tr>
                    <tr>
                        <th>Email:</th>
                        <td>{{ $lead->email }}</td>
                    </tr>
                    <tr>
                        <th>Telefone:</th>
                        <td>{{ $lead->telefone }}</td>
                    </tr>
                    <tr>
                        <th>WhatsApp:</th>
                        <td>{{ $lead->whatsapp ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            @php
                                $statusBadges = [
                                    'novo' => 'info',
                                    'em_contato' => 'primary',
                                    'negociacao' => 'warning',
                                    'proposta_enviada' => 'success',
                                    'convertido' => 'success',
                                    'perdido' => 'danger',
                                ];
                                $badge = $statusBadges[$lead->status] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badge }}">{{ ucfirst(str_replace('_', ' ', $lead->status)) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Origem:</th>
                        <td>{{ ucfirst($lead->origem ?? '-') }}</td>
                    </tr>
                    <tr>
                        <th>Especialista:</th>
                        <td>{{ $lead->especialista?->nome ?? 'Não distribuído' }}</td>
                    </tr>
                    <tr>
                        <th>Equipe:</th>
                        <td>{{ $lead->equipe?->nome ?? '-' }}</td>
                    </tr>
                    <tr>
                        <th>Data Cadastro:</th>
                        <td>{{ $lead->data_cadastro ? \Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y H:i') : '-' }}</td>
                    </tr>
                    <tr>
                        <th>Data Distribuição:</th>
                        <td>{{ $lead->data_distribuicao ? \Carbon\Carbon::parse($lead->data_distribuicao)->format('d/m/Y H:i') : '-' }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <!-- Atendimentos -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Histórico de Atendimentos</h5>
            </div>
            <div class="card-body">
                @forelse($lead->atendimentos as $atendimento)
                    <div class="mb-3 pb-3 border-bottom">
                        <div class="d-flex justify-content-between">
                            <strong>{{ ucfirst($atendimento->tipo) }}</strong>
                            <small class="text-muted">
                                {{ $atendimento->data_realizacao ? \Carbon\Carbon::parse($atendimento->data_realizacao)->format('d/m/Y H:i') : '-' }}
                            </small>
                        </div>
                        <p class="mb-0 mt-2">{{ $atendimento->observacoes }}</p>
                        @if($atendimento->resultado)
                            <span class="badge bg-{{ $atendimento->resultado === 'positivo' ? 'success' : ($atendimento->resultado === 'negativo' ? 'danger' : 'secondary') }}">
                                {{ ucfirst($atendimento->resultado) }}
                            </span>
                        @endif
                    </div>
                @empty
                    <p class="text-muted text-center">Nenhum atendimento registrado</p>
                @endforelse
            </div>
        </div>
    </div>
</div>

<!-- Negociações -->
@if($negociacoes->count() > 0)
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Negociações</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Valor Total</th>
                        <th>Entrada</th>
                        <th>Parcelas</th>
                        <th>Status</th>
                        <th>Data</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($negociacoes as $neg)
                    <tr>
                        <td>#{{ $neg->id }}</td>
                        <td><strong>R$ {{ number_format($neg->valor_total, 2, ',', '.') }}</strong></td>
                        <td>R$ {{ number_format($neg->valor_entrada ?? 0, 2, ',', '.') }}</td>
                        <td>{{ $neg->num_parcelas }}x de R$ {{ number_format($neg->valor_parcela ?? 0, 2, ',', '.') }}</td>
                        <td>
                            @php
                                $statusBadges = [
                                    'pendente' => 'warning',
                                    'aprovada' => 'success',
                                    'finalizada' => 'success',
                                    'rejeitada' => 'danger',
                                ];
                                $badge = $statusBadges[$neg->status] ?? 'secondary';
                            @endphp
                            <span class="badge bg-{{ $badge }}">{{ ucfirst($neg->status) }}</span>
                        </td>
                        <td>{{ \Carbon\Carbon::parse($neg->data_criacao)->format('d/m/Y H:i') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

<!-- Observações -->
@if($lead->observacoes)
<div class="card mt-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Observações</h5>
    </div>
    <div class="card-body">
        <p style="white-space: pre-wrap;">{{ $lead->observacoes }}</p>
    </div>
</div>
@endif
@endsection

