@extends('layouts.admin')

@section('title', 'Detalhes do Link')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.marketing.index') }}">Marketing</a></li>
            <li class="breadcrumb-item active">{{ $link->nome }}</li>
        </ol>
    </nav>
    <h1 class="content-title">{{ $link->nome }}</h1>
</div>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações do Link</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="150">Código:</th>
                        <td><code class="fs-5">{{ $link->codigo }}</code></td>
                    </tr>
                    <tr>
                        <th>Link Curto:</th>
                        <td>
                            <div class="input-group">
                                <input type="text" class="form-control" value="{{ url('/l/' . $link->codigo) }}" id="linkCurto" readonly>
                                <button class="btn btn-outline-secondary" onclick="copiarLink('linkCurto')">
                                    <i class="fas fa-copy"></i> Copiar
                                </button>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>URL Completa:</th>
                        <td>
                            <small class="text-muted" style="word-break: break-all;">{{ $link->url_completa }}</small>
                        </td>
                    </tr>
                    <tr>
                        <th>Parâmetros UTM:</th>
                        <td>
                            <small class="text-muted">{{ $link->descricao ?? '-' }}</small>
                        </td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $link->ativo ? 'success' : 'secondary' }}">
                                {{ $link->ativo ? 'Ativo' : 'Inativo' }}
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Estatísticas</h5>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <h2 class="display-4">{{ $totalClicks }}</h2>
                    <p class="text-muted">Total de Clicks</p>
                </div>
                <div class="text-center">
                    <h3>{{ $leadsGerados }}</h3>
                    <p class="text-muted">Leads Gerados</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Clicks por Dia (Últimos 30 dias)</h5>
    </div>
    <div class="card-body">
        <canvas id="chartClicks" height="80"></canvas>
    </div>
</div>
@endsection

@push('scripts')
<script>
const ctx = document.getElementById('chartClicks').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: {!! json_encode($clicksPorDia->pluck('data')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d/m'))) !!},
        datasets: [{
            label: 'Clicks',
            data: {!! json_encode($clicksPorDia->pluck('total')) !!},
            borderColor: '#3b82f6',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

function copiarLink(inputId) {
    const input = document.getElementById(inputId);
    input.select();
    navigator.clipboard.writeText(input.value).then(() => {
        alert('Link copiado para a área de transferência!');
    });
}
</script>
@endpush

