@extends('layouts.admin')

@section('title', 'Usuários')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Usuários</h1>
        <p class="content-subtitle">Gerenciamento de usuários do sistema</p>
    </div>
    <a href="{{ route('admin.usuarios.create') }}" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Novo Usuário
    </a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.usuarios.index') }}" class="row g-3">
            <div class="col-md-3">
                <label for="categoria_id" class="form-label">Categoria</label>
                <select class="form-select" id="categoria_id" name="categoria_id">
                    <option value="">Todas</option>
                    @foreach($categorias as $categoria)
                        <option value="{{ $categoria->id }}" {{ request('categoria_id') == $categoria->id ? 'selected' : '' }}>
                            {{ $categoria->nome }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" id="status" name="status">
                    <option value="">Todos</option>
                    <option value="ativo" {{ request('status') === 'ativo' ? 'selected' : '' }}>Ativo</option>
                    <option value="inativo" {{ request('status') === 'inativo' ? 'selected' : '' }}>Inativo</option>
                </select>
            </div>
            <div class="col-md-4">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Nome, email ou telefone">
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Telefone</th>
                        <th>Categoria</th>
                        <th>Status</th>
                        <th>Cadastro</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($usuarios as $usuario)
                    <tr>
                        <td>
                            <strong>{{ $usuario->nome }}</strong>
                        </td>
                        <td>{{ $usuario->email }}</td>
                        <td>{{ $usuario->telefone ?? '-' }}</td>
                        <td>
                            @if($usuario->categoria_nome)
                                @php
                                    $badges = [
                                        'admin' => 'danger',
                                        'especialista' => 'primary',
                                        'coordenador' => 'info',
                                        'secretaria' => 'warning',
                                        'professor' => 'success',
                                        'aluno' => 'secondary',
                                        'gestao_pedagogica' => 'purple',
                                        'marketing' => 'pink',
                                    ];
                                    $badge = $badges[$usuario->categoria_slug ?? $usuario->role] ?? 'secondary';
                                @endphp
                                <span class="badge bg-{{ $badge }}">{{ $usuario->categoria_nome }}</span>
                            @else
                                <span class="badge bg-secondary">Sem categoria</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $usuario->status === 'ativo' ? 'success' : 'secondary' }}">
                                {{ ucfirst($usuario->status) }}
                            </span>
                        </td>
                        <td>{{ $usuario->data_cadastro?->format('d/m/Y') ?? '-' }}</td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('admin.usuarios.show', $usuario->id) }}" class="btn btn-outline-primary" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.usuarios.edit', $usuario->id) }}" class="btn btn-outline-secondary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhum usuário encontrado</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($usuarios->hasPages())
            <div class="mt-3">
                {{ $usuarios->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

