@extends('layouts.admin')

@section('title', 'Valor Integral do Curso')

@section('content')
<div class="content-header">
    <h1 class="content-title">
        <i class="fas fa-dollar-sign me-2" style="color: #667eea;"></i>Valor Integral do Curso
    </h1>
    <p class="content-subtitle">Defina o valor integral usado nas negociações do Kanban (descontos aplicados via vouchers)</p>
</div>

<!-- Alertas -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show mb-4 border-0 shadow-sm">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show mb-4 border-0 shadow-sm">
        <i class="fas fa-exclamation-triangle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Estatísticas -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <i class="fas fa-dollar-sign"></i>
            </div>
            <div class="stat-value">R$ {{ number_format($valorIntegralAtual, 2, ',', '.') }}</div>
            <div class="stat-label">Valor Integral Atual</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white;">
                <i class="fas fa-percentage"></i>
            </div>
            <div class="stat-value">R$ {{ number_format($valorComDesconto20, 2, ',', '.') }}</div>
            <div class="stat-label">Com 20% Desconto</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-value">R$ {{ number_format($valorMinimoAprovacao, 2, ',', '.') }}</div>
            <div class="stat-label">Valor Mínimo Aprovação</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%); color: white;">
                <i class="fas fa-history"></i>
            </div>
            <div class="stat-value">{{ number_format($totalAlteracoes) }}</div>
            <div class="stat-label">Total de Alterações</div>
        </div>
    </div>
</div>

<!-- Formulário de Atualização -->
<div class="card mb-4 border-0 shadow-sm">
    <div class="card-header bg-white border-bottom">
        <h5 class="mb-0">
            <i class="fas fa-edit me-2"></i>Atualizar Valor Integral
        </h5>
    </div>
    <div class="card-body p-4">
        <div class="row g-4">
            <!-- Valor Atual -->
            <div class="col-md-6">
                <div class="border rounded-3 p-4 h-100 shadow-sm text-center" style="border-left: 4px solid #0d6efd !important; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                    <div class="mb-3">
                        <div class="rounded-circle d-inline-flex p-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <i class="fas fa-graduation-cap fa-2x text-white"></i>
                        </div>
                    </div>
                    <h6 class="text-muted mb-2 text-uppercase" style="letter-spacing: 1px;">Valor Atual</h6>
                    <h1 class="display-3 mb-3" style="font-weight: 700; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                        R$ {{ number_format($valorAtual->valor_integral ?? 0, 2, ',', '.') }}
                    </h1>
                    <div class="text-muted">
                        <small>
                            <i class="fas fa-clock me-1"></i>
                            Atualizado em {{ \Carbon\Carbon::parse($valorAtual->data_criacao)->format('d/m/Y') }}
                            @if($valorAtual->criado_por_nome ?? false)
                                por {{ $valorAtual->criado_por_nome }}
                            @endif
                        </small>
                    </div>
                </div>
            </div>
            
            <!-- Formulário -->
            <div class="col-md-6">
                <div class="border rounded-3 p-4 h-100 shadow-sm" style="border-left: 4px solid #198754 !important;">
                    <div class="mb-3">
                        <div class="rounded-circle d-inline-flex p-3" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                            <i class="fas fa-edit fa-2x text-white"></i>
                        </div>
                    </div>
                    <h5 class="mb-4">Definir Novo Valor</h5>
                    <form method="POST" action="{{ route('admin.valores-curso.atualizar') }}">
                        @csrf
                        
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-dollar-sign me-1"></i>
                                Novo Valor Integral (R$) <span class="text-danger">*</span>
                            </label>
                            <div class="input-group input-group-lg shadow-sm">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-dollar-sign text-success"></i>
                                </span>
                                <input type="number" 
                                       name="valor_integral" 
                                       class="form-control form-control-lg border-start-0" 
                                       value="{{ $valorAtual->valor_integral ?? 0 }}"
                                       step="0.01" 
                                       min="0.01" 
                                       required
                                       placeholder="0,00"
                                       style="font-size: 1.5rem; font-weight: 600;">
                            </div>
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Valor base do treinamento antes dos descontos
                            </small>
                        </div>
                        
                        <button type="submit" class="btn btn-success btn-lg w-100 shadow-sm">
                            <i class="fas fa-save me-2"></i>Salvar Novo Valor
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Histórico de Alterações -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-header bg-white border-bottom d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            <i class="fas fa-history me-2"></i>Histórico de Alterações
        </h5>
        <span class="badge bg-info fs-6">{{ count($historicoValores) }} registro(s)</span>
    </div>
    <div class="card-body">
        @if(empty($historicoValores))
            <div class="text-center py-5">
                <i class="fas fa-history fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum histórico disponível</h5>
                <p class="text-muted">As alterações de valor serão registradas aqui quando a tabela valores_curso for criada.</p>
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Valor Integral</th>
                            <th>Status</th>
                            <th>Alterado Por</th>
                            <th>Data/Hora</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($historicoValores as $historico)
                            <tr class="{{ $historico->ativo ? 'table-success' : '' }}">
                                <td>
                                    <h5 class="mb-0 text-primary fw-bold">
                                        <i class="fas fa-dollar-sign me-1"></i>
                                        R$ {{ number_format($historico->valor_integral, 2, ',', '.') }}
                                    </h5>
                                </td>
                                <td>
                                    @if($historico->ativo)
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle me-1"></i>ATIVO
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">Histórico</span>
                                    @endif
                                </td>
                                <td>
                                    <i class="fas fa-user me-1 text-primary"></i>
                                    {{ $historico->criado_por_nome ?? 'Sistema' }}
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <i class="fas fa-calendar me-1"></i>
                                        {{ \Carbon\Carbon::parse($historico->data_criacao)->format('d/m/Y H:i') }}
                                    </small>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>

<!-- Informações Importantes -->
<div class="alert alert-info border-0 shadow-sm">
    <div class="d-flex align-items-start">
        <i class="fas fa-info-circle fa-2x me-3"></i>
        <div>
            <h6 class="alert-heading mb-2 fw-bold">Como Funciona o Sistema de Valores</h6>
            <ul class="mb-0 small">
                <li class="mb-2"><strong>Valor Integral:</strong> Este é o valor base do treinamento exibido no modal de negociação do Kanban</li>
                <li class="mb-2"><strong>Descontos:</strong> Os descontos são aplicados através de vouchers criados na página "Vouchers"</li>
                <li class="mb-2"><strong>Negociação:</strong> Especialista vê o valor integral e aplica voucher para calcular o valor final</li>
                <li class="mb-2"><strong>Histórico:</strong> Todas as alterações são registradas e apenas o último valor fica ativo</li>
                <li><strong>Impacto:</strong> Alterações afetam apenas novas negociações, não modificam as existentes</li>
            </ul>
        </div>
    </div>
</div>
@endsection
