@extends('layouts.admin')

@php
use Illuminate\Support\Facades\DB;
@endphp

@section('title', 'Aguardando Aprovação')

@section('content')
<div class="content-header">
    <h1 class="content-title">Aguardando Aprovação</h1>
    <p class="content-subtitle">Negociações aguardando aprovação para criação de matrícula</p>
</div>

<!-- Estatísticas -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-value">{{ $stats['aguardando_aprovacao'] }}</div>
            <div class="stat-label">Aguardando Aprovação</div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-value">{{ $stats['aprovadas'] }}</div>
            <div class="stat-label">Aprovadas</div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="stat-card">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-dollar-sign"></i>
            </div>
            <div class="stat-value">R$ {{ number_format($stats['total_mes'], 2, ',', '.') }}</div>
            <div class="stat-label">Total do Mês</div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.vendas.index') }}" class="row g-3">
            <div class="col-md-4">
                <label for="search" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="Nome, email ou telefone do lead">
            </div>
            <div class="col-md-4">
                <label for="especialista_id" class="form-label">Especialista</label>
                <select class="form-select" id="especialista_id" name="especialista_id">
                    <option value="">Todos</option>
                    @php
                        $especialistas = DB::table('usuarios')
                            ->where('role', 'especialista')
                            ->where('status', 'ativo')
                            ->get();
                    @endphp
                    @foreach($especialistas as $esp)
                    <option value="{{ $esp->id }}" {{ request('especialista_id') == $esp->id ? 'selected' : '' }}>{{ $esp->nome }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-search me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Tabela -->
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Lead</th>
                        <th>Contato</th>
                        <th>Especialista</th>
                        <th>Valor Proposta</th>
                        <th>Data Criação</th>
                        <th width="150">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($vendas as $venda)
                    <tr>
                        <td><strong>#{{ $venda->id }}</strong></td>
                        <td>
                            <strong>{{ $venda->lead_nome }}</strong>
                        </td>
                        <td>
                            <div><small>{{ $venda->lead_email }}</small></div>
                            <div><small>{{ $venda->lead_telefone }}</small></div>
                        </td>
                        <td>{{ $venda->especialista_nome }}</td>
                        <td><strong>R$ {{ number_format($venda->valor_proposta ?? $venda->valor_total ?? 0, 2, ',', '.') }}</strong></td>
                        <td>{{ \Carbon\Carbon::parse($venda->data_criacao)->format('d/m/Y H:i') }}</td>
                        <td>
                            <button type="button" class="btn btn-success btn-sm" onclick="aprovarVenda({{ $venda->id }}, '{{ $venda->lead_nome }}', {{ $venda->valor_proposta ?? $venda->valor_total ?? 0 }})" title="Aprovar">
                                <i class="fas fa-check me-1"></i>Aprovar
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma negociação aguardando aprovação</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($vendas->hasPages())
            <div class="mt-3">
                {{ $vendas->links() }}
            </div>
        @endif
    </div>
</div>

<!-- Modal de Aprovação -->
<div class="modal fade" id="modalAprovar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Aprovar Negociação</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formAprovar">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Lead</label>
                        <input type="text" class="form-control" id="lead_nome_modal" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="curso" class="form-label">Curso <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="curso" name="curso" required placeholder="Nome do curso">
                    </div>
                    <div class="mb-3">
                        <label for="valor_total" class="form-label">Valor Total <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="valor_total" name="valor_total" step="0.01" min="0" required placeholder="0.00">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">Aprovar e Criar Matrícula</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
let vendaIdAprovar = null;

function aprovarVenda(id, leadNome, valorProposta) {
    vendaIdAprovar = id;
    document.getElementById('lead_nome_modal').value = leadNome;
    document.getElementById('valor_total').value = valorProposta;
    document.getElementById('curso').value = '';
    new bootstrap.Modal(document.getElementById('modalAprovar')).show();
}

document.getElementById('formAprovar').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const curso = document.getElementById('curso').value;
    const valorTotal = document.getElementById('valor_total').value;
    
    if (!curso.trim()) {
        alert('Por favor, informe o curso');
        return;
    }
    
    if (!valorTotal || parseFloat(valorTotal) <= 0) {
        alert('Por favor, informe um valor total válido');
        return;
    }

    fetch(`/admin/vendas/${vendaIdAprovar}/aprovar`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            curso: curso,
            valor_total: parseFloat(valorTotal)
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        alert('Erro ao aprovar negociação');
        console.error(error);
    });
});
</script>
@endpush
