@extends('layouts.admin')

@section('title', 'Novo Voucher')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.vouchers.index') }}">Vouchers</a></li>
            <li class="breadcrumb-item active">Novo</li>
        </ol>
    </nav>
    <h1 class="content-title">Novo Voucher</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.vouchers.store') }}">
            @csrf

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="codigo" class="form-label">Código *</label>
                    <input type="text" class="form-control @error('codigo') is-invalid @enderror" 
                           id="codigo" name="codigo" value="{{ old('codigo') }}" required>
                    @error('codigo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Será convertido para maiúsculas</small>
                </div>
                <div class="col-md-4">
                    <label for="nome" class="form-label">Nome do Voucher</label>
                    <input type="text" class="form-control" id="nome" name="nome" value="{{ old('nome') }}">
                    <small class="text-muted">Nome descritivo (opcional)</small>
                </div>
                <div class="col-md-4">
                    <label for="tipo" class="form-label">Tipo de Desconto *</label>
                    <select class="form-select @error('tipo') is-invalid @enderror" id="tipo" name="tipo" required onchange="toggleTipo()">
                        <option value="">Selecione...</option>
                        <option value="desconto" {{ old('tipo') === 'desconto' ? 'selected' : '' }}>Desconto</option>
                        <option value="brinde" {{ old('tipo') === 'brinde' ? 'selected' : '' }}>Brinde</option>
                    </select>
                    @error('tipo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="abrangencia" class="form-label">Abrangência *</label>
                    <select class="form-select" id="abrangencia" name="abrangencia" required onchange="toggleAbrangencia()">
                        <option value="global" {{ old('abrangencia') === 'global' ? 'selected' : '' }}>Global (Todos os Especialistas)</option>
                        <option value="individual" {{ old('abrangencia') === 'individual' ? 'selected' : '' }}>Individual (Especialistas Específicos)</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="tipo_quantidade" class="form-label">Tipo de Quantidade *</label>
                    <select class="form-select" id="tipo_quantidade" name="tipo_quantidade" required>
                        <option value="coletiva" {{ old('tipo_quantidade') === 'coletiva' ? 'selected' : '' }}>Coletiva (Total geral)</option>
                        <option value="individual" {{ old('tipo_quantidade') === 'individual' ? 'selected' : '' }}>Individual (Por especialista)</option>
                    </select>
                    <small class="text-muted">Coletiva: limite total | Individual: limite por pessoa</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="percentual_desconto" class="form-label">Percentual de Desconto (%)</label>
                    <input type="number" class="form-control" id="percentual_desconto" name="percentual_desconto" 
                           value="{{ old('percentual_desconto') }}" min="0" max="100" step="0.01">
                </div>
                <div class="col-md-4">
                    <label for="valor_desconto" class="form-label">Valor do Desconto (R$)</label>
                    <input type="number" class="form-control" id="valor_desconto" name="valor_desconto" 
                           value="{{ old('valor_desconto') }}" min="0" step="0.01">
                </div>
                <div class="col-md-4">
                    <label for="quantidade_total" class="form-label">Quantidade Total *</label>
                    <input type="number" class="form-control" id="quantidade_total" name="quantidade_total" 
                           value="{{ old('quantidade_total', 1) }}" min="1" required>
                    <small class="text-muted">Qtd de usos permitidos</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="validade" class="form-label">Data de Validade</label>
                    <input type="date" class="form-control" id="validade" name="validade" value="{{ old('validade') }}">
                    <small class="text-muted">Deixe em branco para sem limite</small>
                </div>
                <div class="col-md-6">
                    <label for="valor_minimo" class="form-label">Valor Mínimo de Compra (R$)</label>
                    <input type="number" class="form-control" id="valor_minimo" name="valor_minimo" 
                           value="{{ old('valor_minimo') }}" min="0" step="0.01">
                    <small class="text-muted">Opcional</small>
                </div>
            </div>

            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="3">{{ old('descricao') }}</textarea>
                <small class="text-muted">Descrição interna do voucher (opcional)</small>
            </div>

            <div class="mb-3" id="campo_especialistas" style="display: none;">
                <label class="form-label">Especialistas Autorizados *</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    @forelse($especialistas as $esp)
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="especialistas[]" 
                                   value="{{ $esp->id }}" id="esp{{ $esp->id }}">
                            <label class="form-check-label" for="esp{{ $esp->id }}">
                                {{ $esp->nome }}
                            </label>
                        </div>
                    @empty
                        <p class="text-muted">Nenhum especialista disponível</p>
                    @endforelse
                </div>
                <small class="text-muted">Selecione os especialistas que podem usar este voucher</small>
            </div>

            <hr class="my-4">

            <div class="alert alert-info">
                <strong>📋 Resumo:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>Global:</strong> Todos os especialistas podem usar</li>
                    <li><strong>Individual:</strong> Apenas especialistas selecionados</li>
                    <li><strong>Quantidade Coletiva:</strong> Limite total de usos (ex: 100 usos no total)</li>
                    <li><strong>Quantidade Individual:</strong> Limite por especialista (ex: cada um pode usar 5 vezes)</li>
                </ul>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.vouchers.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Voucher
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleAbrangencia() {
    const abrangencia = document.getElementById('abrangencia').value;
    document.getElementById('campo_especialistas').style.display = abrangencia === 'individual' ? 'block' : 'none';
}

// Executar ao carregar
document.addEventListener('DOMContentLoaded', function() {
    toggleAbrangencia();
});
</script>
@endpush

