@extends('layouts.admin')

@section('title', 'Editar Voucher')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.vouchers.index') }}">Vouchers</a></li>
            <li class="breadcrumb-item active">Editar</li>
        </ol>
    </nav>
    <h1 class="content-title">Editar Voucher</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('admin.vouchers.update', $voucher->id) }}">
            @csrf
            @method('PUT')

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="codigo" class="form-label">Código *</label>
                    <input type="text" class="form-control" id="codigo" name="codigo" 
                           value="{{ old('codigo', $voucher->codigo) }}" required>
                </div>
                <div class="col-md-6">
                    <label for="tipo" class="form-label">Tipo *</label>
                    <select class="form-select" id="tipo" name="tipo" required onchange="toggleTipo()">
                        <option value="percentual" {{ old('tipo', $voucher->tipo) === 'percentual' ? 'selected' : '' }}>Percentual</option>
                        <option value="valor" {{ old('tipo', $voucher->tipo) === 'valor' ? 'selected' : '' }}>Valor Fixo</option>
                    </select>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6" id="campo_percentual">
                    <label for="percentual_desconto" class="form-label">Percentual (%)</label>
                    <input type="number" class="form-control" id="percentual_desconto" name="percentual_desconto" 
                           value="{{ old('percentual_desconto', $voucher->percentual_desconto) }}" min="0" max="100" step="0.01">
                </div>
                <div class="col-md-6" id="campo_valor">
                    <label for="valor_desconto" class="form-label">Valor (R$)</label>
                    <input type="number" class="form-control" id="valor_desconto" name="valor_desconto" 
                           value="{{ old('valor_desconto', $voucher->valor_desconto) }}" min="0" step="0.01">
                </div>
                <div class="col-md-6">
                    <label for="data_validade" class="form-label">Data de Validade</label>
                    <input type="date" class="form-control" id="data_validade" name="data_validade" 
                           value="{{ old('data_validade', $voucher->validade) }}">
                </div>
            </div>

            <div class="mb-3">
                <label for="status" class="form-label">Status *</label>
                <select class="form-select" id="status" name="status" required>
                    <option value="ativo" {{ old('status', $voucher->status) === 'ativo' ? 'selected' : '' }}>Ativo</option>
                    <option value="inativo" {{ old('status', $voucher->status) === 'inativo' ? 'selected' : '' }}>Inativo</option>
                    <option value="expirado" {{ old('status', $voucher->status) === 'expirado' ? 'selected' : '' }}>Expirado</option>
                </select>
            </div>

            <div class="text-end">
                <a href="{{ route('admin.vouchers.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Alterações
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function toggleTipo() {
    const tipo = document.getElementById('tipo').value;
    document.getElementById('campo_percentual').style.display = tipo === 'percentual' ? 'block' : 'none';
    document.getElementById('campo_valor').style.display = tipo === 'valor' ? 'block' : 'none';
}
document.addEventListener('DOMContentLoaded', toggleTipo);
</script>
@endpush

