@extends('layouts.admin')

@section('title', 'Detalhes do Voucher')

@section('content')
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.vouchers.index') }}">Vouchers</a></li>
            <li class="breadcrumb-item active">{{ $voucher->codigo }}</li>
        </ol>
    </nav>
    <h1 class="content-title">Voucher {{ $voucher->codigo }}</h1>
</div>

<div class="card">
    <div class="card-body">
        <table class="table table-borderless">
            <tr>
                <th width="200">Código:</th>
                <td><code class="fs-4">{{ $voucher->codigo }}</code></td>
            </tr>
            <tr>
                <th>Nome:</th>
                <td>{{ $voucher->nome ?? '-' }}</td>
            </tr>
            <tr>
                <th>Tipo:</th>
                <td><span class="badge bg-info">{{ ucfirst($voucher->tipo) }}</span></td>
            </tr>
            <tr>
                <th>Desconto:</th>
                <td>
                    @if($voucher->percentual_desconto)
                        <strong>{{ $voucher->percentual_desconto }}%</strong>
                    @elseif($voucher->valor_desconto)
                        <strong>R$ {{ number_format($voucher->valor_desconto, 2, ',', '.') }}</strong>
                    @else
                        -
                    @endif
                </td>
            </tr>
            <tr>
                <th>Quantidade:</th>
                <td>
                    <span class="badge bg-primary">{{ $voucher->quantidade_usada }}/{{ $voucher->quantidade_total }}</span>
                </td>
            </tr>
            <tr>
                <th>Validade:</th>
                <td>{{ $voucher->validade ? \Carbon\Carbon::parse($voucher->validade)->format('d/m/Y') : 'Sem limite' }}</td>
            </tr>
            <tr>
                <th>Status:</th>
                <td>
                    @php
                        $statusBadge = match($voucher->status) {
                            'ativo' => 'success',
                            'inativo' => 'secondary',
                            'expirado' => 'danger',
                            default => 'secondary',
                        };
                    @endphp
                    <span class="badge bg-{{ $statusBadge }}">{{ ucfirst($voucher->status) }}</span>
                </td>
            </tr>
            <tr>
                <th>Criado Por:</th>
                <td>{{ $voucher->criador?->nome ?? '-' }}</td>
            </tr>
            <tr>
                <th>Data Criação:</th>
                <td>{{ $voucher->data_criacao ? \Carbon\Carbon::parse($voucher->data_criacao)->format('d/m/Y H:i') : '-' }}</td>
            </tr>
        </table>

        <div class="text-end mt-4">
            <a href="{{ route('admin.vouchers.edit', $voucher->id) }}" class="btn btn-primary">
                <i class="fas fa-edit me-2"></i>Editar
            </a>
        </div>
    </div>
</div>
@endsection

