<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - Portal Vencer Leitura</title>
    
    <!-- Google Fonts - Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-purple: #5a3e9a;
            --gradient-primary: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --light-purple-bg: #f3f0ff;
            --page-bg: #f5f7fa;
            --form-bg: #FFFFFF;
            --text-primary: #1f2937;
            --text-secondary: #6b7280;
            --border-color: #e5e7eb;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background-color: #f5f7fa;
            background-image: 
                repeating-linear-gradient(
                    45deg,
                    transparent,
                    transparent 10px,
                    rgba(255, 140, 0, 0.03) 10px,
                    rgba(255, 140, 0, 0.03) 20px
                ),
                repeating-linear-gradient(
                    -45deg,
                    transparent,
                    transparent 10px,
                    rgba(255, 140, 0, 0.02) 10px,
                    rgba(255, 140, 0, 0.02) 20px
                );
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
        }
        
        .login-wrapper {
            width: 100%;
            max-width: 1200px;
            background: var(--form-bg);
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12), 0 2px 8px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            display: flex;
            min-height: 600px;
            max-height: 90vh;
            position: relative;
            z-index: 1;
        }
        
        /* Lado Esquerdo - Imagem */
        .login-image-side {
            flex: 0 0 45%;
            position: relative;
            background-image: url('{{ asset("images/login-bg.jpg") }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            border: 3px solid #ff8c00;
            border-right: none;
            border-radius: 12px 0 0 12px;
        }
        
        /* Lado Direito - Formulário */
        .login-form-side {
            flex: 0 0 55%;
            background: var(--form-bg);
            padding: 60px 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            border: 3px solid #ff8c00;
            border-left: none;
            border-radius: 0 12px 12px 0;
        }
        
        .login-logo {
            display: none;
        }
        
        .login-title {
            font-size: 32px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 40px;
            line-height: 1.2;
        }
        
        .form-label {
            font-weight: 500;
            color: var(--text-primary);
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-control::placeholder {
            color: var(--text-secondary);
        }
        
        .form-control {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            padding: 12px 16px;
            font-size: 14px;
            transition: all 0.3s ease;
            background: var(--form-bg);
        }
        
        .form-control:focus {
            border-color: #ff8c00;
            box-shadow: 0 0 0 3px rgba(255, 140, 0, 0.1);
            outline: none;
        }
        
        
        .password-wrapper {
            position: relative;
        }
        
        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--text-secondary);
            cursor: pointer;
            padding: 5px;
            z-index: 10;
        }
        
        .password-toggle:hover {
            color: #ff8c00;
        }
        
        .btn-signin {
            width: 100%;
            background: #ff8c00;
            color: white;
            border: none;
            border-radius: 8px;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn-signin:hover {
            background: #e67e00;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(255, 140, 0, 0.4);
        }
        
        .btn-signin:active {
            transform: translateY(0);
        }
        
        .ssl-secure {
            position: absolute;
            bottom: 30px;
            right: 50px;
            display: flex;
            align-items: center;
            gap: 6px;
            color: var(--text-secondary);
            font-size: 12px;
        }
        
        .ssl-secure i {
            font-size: 14px;
        }
        
        .alert {
            border-radius: 8px;
            border: none;
            padding: 12px 16px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        
        .alert-danger {
            background-color: #fee;
            color: #c33;
        }
        
        .alert-success {
            background-color: #efe;
            color: #3c3;
        }
        
        /* Responsividade */
        @media (max-width: 992px) {
            .login-wrapper {
                flex-direction: column;
                max-height: none;
            }
            
            .login-image-side {
                flex: 0 0 200px;
                min-height: 200px;
            }
            
            .login-form-side {
                flex: 1;
                padding: 40px 30px;
            }
            
            .ssl-secure {
                position: static;
                margin-top: 20px;
                justify-content: flex-end;
            }
        }
        
        @media (max-width: 576px) {
            body {
                padding: 10px;
            }
            
            .login-wrapper {
                border-radius: 8px;
            }
            
            .login-form-side {
                padding: 30px 20px;
            }
            
            .login-title {
                font-size: 24px;
                margin-bottom: 30px;
            }
            
            .login-image-side {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="login-wrapper">
        <!-- Lado Esquerdo - Imagem -->
        <div class="login-image-side"></div>
        
        <!-- Lado Direito - Formulário -->
        <div class="login-form-side">
            <!-- Título -->
            <h1 class="login-title">Bem-vindo de Volta</h1>
            
            <!-- Alertas -->
            @if ($errors->any())
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    {{ $errors->first() }}
                </div>
            @endif
            
            @if (session('success'))
                <div class="alert alert-success">
                    <i class="fas fa-check-circle me-2"></i>
                    {{ session('success') }}
                </div>
            @endif
            
            @if (session('error'))
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    {{ session('error') }}
                </div>
            @endif
            
            <!-- Formulário -->
            <form method="POST" action="{{ route('login.post') }}" id="loginForm">
                @csrf
                
                <!-- Campo Email -->
                <div class="mb-3">
                    <label for="email" class="form-label">E-mail Corporativo</label>
                    <input 
                        type="email" 
                        class="form-control @error('email') is-invalid @enderror" 
                        id="email" 
                        name="email" 
                        value="{{ old('email') }}" 
                        placeholder="Business Email"
                        required 
                        autofocus
                    >
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <!-- Campo Senha -->
                <div class="mb-4">
                    <label for="senha" class="form-label">Senha</label>
                    <div class="password-wrapper">
                        <input 
                            type="password" 
                            class="form-control @error('senha') is-invalid @enderror" 
                            id="senha" 
                            name="senha" 
                            placeholder="Password"
                            required
                        >
                        <button type="button" class="password-toggle" onclick="togglePassword()">
                            <i class="fas fa-eye" id="passwordIcon"></i>
                        </button>
                    </div>
                    @error('senha')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                
                <!-- Botão Sign In -->
                <button type="submit" class="btn-signin">
                    Entrar
                </button>
            </form>
            
            <!-- SSL Secure -->
            <div class="ssl-secure">
                <i class="fas fa-lock"></i>
                <span>SSL Seguro</span>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle de visibilidade da senha
        function togglePassword() {
            const passwordInput = document.getElementById('senha');
            const passwordIcon = document.getElementById('passwordIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                passwordIcon.classList.remove('fa-eye');
                passwordIcon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                passwordIcon.classList.remove('fa-eye-slash');
                passwordIcon.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>
