@extends('layouts.coordenador')

@section('title', 'Dashboard')

@section('content')
<div class="content-header">
    <h1 class="content-title">Dashboard do Coordenador</h1>
    <p class="content-subtitle">Visão consolidada das suas equipes</p>
</div>

<!-- Filtro de Período -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('coordenador.dashboard') }}" class="row g-3">
            <div class="col-md-4">
                <label for="start_date" class="form-label">Data Início</label>
                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $start }}">
            </div>
            <div class="col-md-4">
                <label for="end_date" class="form-label">Data Fim</label>
                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $end }}">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

@if(session('error'))
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>{{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(isset($equipes) && $equipes->isNotEmpty())
<!-- KPIs -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value">{{ $totalEspecialistas ?? 0 }}</div>
        <div class="stat-label">Especialistas Ativos</div>
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-user-plus"></i>
            </div>
        </div>
        <div class="stat-value">{{ $leadsAtivos ?? 0 }}</div>
        <div class="stat-label">Leads Ativos</div>
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $vendasPeriodo ?? 0 }}</div>
        <div class="stat-label">Vendas no Período</div>
    </div>

    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #e9d5ff; color: #a855f7;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($receitaPeriodo ?? 0, 2, ',', '.') }}</div>
        <div class="stat-label">Receita Total</div>
    </div>
</div>

@if(isset($performanceEquipes) && !empty($performanceEquipes))
<!-- Performance por Equipe -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Performance por Equipe</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Equipe</th>
                        <th>Especialistas</th>
                        <th>Leads</th>
                        <th>Vendas</th>
                        <th>Receita</th>
                        <th>Taxa Conversão</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($performanceEquipes as $perf)
                    <tr>
                        <td><strong>{{ $perf['equipe']->nome }}</strong></td>
                        <td>{{ $perf['especialistas'] }}</td>
                        <td>{{ $perf['leads'] }}</td>
                        <td>{{ $perf['vendas'] }}</td>
                        <td>R$ {{ number_format($perf['receita'], 2, ',', '.') }}</td>
                        <td>
                            <span class="badge bg-{{ $perf['taxa_conversao'] >= 20 ? 'success' : ($perf['taxa_conversao'] >= 10 ? 'warning' : 'danger') }}">
                                {{ number_format($perf['taxa_conversao'], 1) }}%
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

@if(isset($rankingEspecialistas) && !empty($rankingEspecialistas))
<!-- Ranking de Especialistas -->
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Top 10 Especialistas</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Posição</th>
                        <th>Especialista</th>
                        <th>Vendas</th>
                        <th>Receita</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($rankingEspecialistas as $index => $esp)
                    <tr>
                        <td>
                            @if($index < 3)
                                <span class="badge bg-warning">🏆 {{ $index + 1 }}º</span>
                            @else
                                <span class="badge bg-secondary">{{ $index + 1 }}º</span>
                            @endif
                        </td>
                        <td><strong>{{ $esp->nome }}</strong></td>
                        <td>{{ $esp->vendas_periodo }}</td>
                        <td>R$ {{ number_format($esp->receita_periodo ?? 0, 2, ',', '.') }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif
@endif
@endsection

