@extends('layouts.coordenador')

@section('title', 'Equipes')

@section('content')
<div class="content-header">
    <h1 class="content-title">Gerenciar Equipe</h1>
    <p class="content-subtitle">Configure e acompanhe o desempenho da sua equipe</p>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Estatísticas -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsEquipe->total_membros ?? 0 }}</div>
        <div class="stat-label">Total de Membros</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-user-tie"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsEquipe->total_especialistas ?? 0 }}</div>
        <div class="stat-label">Especialistas</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsEquipe->vendas_mes ?? 0 }}</div>
        <div class="stat-label">Vendas Este Mês</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-graduation-cap"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsEquipe->alunos_ativos ?? 0 }}</div>
        <div class="stat-label">Alunos Ativos</div>
    </div>
</div>

<!-- Informações da Equipe -->
<div class="card mb-4">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Informações da Equipe</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalEditarEquipe">
            <i class="fas fa-edit me-2"></i>Editar
        </button>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label text-muted">Nome da Equipe</label>
                <input type="text" class="form-control" value="{{ $equipe->nome }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Coordenador</label>
                <input type="text" class="form-control" value="{{ Auth::user()->nome }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Status</label>
                <div>
                    <span class="badge badge-success">Ativa</span>
                </div>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Meta Mensal de Vendas</label>
                <input type="text" class="form-control" value="{{ number_format($equipe->meta_mensal ?? 0, 0, ',', '.') }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Vendas Este Mês</label>
                <input type="text" class="form-control" value="{{ $statsEquipe->vendas_mes ?? 0 }}" readonly>
            </div>
            <div class="col-md-4">
                <label class="form-label text-muted">Progresso da Meta</label>
                <div class="progress" style="height: 25px;">
                    <div class="progress-bar bg-success" role="progressbar" style="width: {{ min($progressoMeta, 100) }}%">
                        {{ number_format($progressoMeta, 1) }}%
                    </div>
                </div>
                <small class="text-muted">{{ number_format($progressoMeta, 1) }}% da meta mensal</small>
            </div>
            @if($equipe->descricao)
            <div class="col-12">
                <label class="form-label text-muted">Descrição</label>
                <textarea class="form-control" rows="3" readonly>{{ $equipe->descricao }}</textarea>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- Gráfico de Histórico -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">Histórico de Vendas (Últimos 6 Meses)</h5>
    </div>
    <div class="card-body">
        <canvas id="historicoVendasChart" height="80"></canvas>
    </div>
</div>

<!-- Membros da Equipe -->
<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Membros da Equipe</h5>
        <div class="col-md-4">
            <input type="text" class="form-control" id="searchMembros" placeholder="Buscar membro...">
        </div>
    </div>
    <div class="card-body">
        @if($membros->isNotEmpty())
            <div class="table-container">
                <table class="table" id="tabelaMembros">
                    <thead>
                        <tr>
                            <th>Membro</th>
                            <th>Categoria</th>
                            <th>Data de Entrada</th>
                            <th>Total Alunos</th>
                            <th>Alunos Ativos</th>
                            <th>Vendas Este Mês</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($membros as $membro)
                            <tr>
                                <td>
                                    <strong>{{ $membro->nome }}</strong><br>
                                    <small class="text-muted">{{ $membro->email }}</small>
                                </td>
                                <td>
                                    @php
                                        $categoria_cores = [
                                            'coordenador' => 'badge-primary',
                                            'especialista' => 'badge-info',
                                            'admin' => 'badge-danger'
                                        ];
                                    @endphp
                                    <span class="badge {{ $categoria_cores[$membro->categoria] ?? 'badge-secondary' }}">
                                        {{ ucfirst($membro->categoria) }}
                                    </span>
                                </td>
                                <td>{{ \Carbon\Carbon::parse($membro->data_entrada)->format('d/m/Y') }}</td>
                                <td><span class="badge badge-info">{{ $membro->total_alunos }}</span></td>
                                <td><span class="badge badge-success">{{ $membro->alunos_ativos }}</span></td>
                                <td><span class="badge badge-primary">{{ $membro->vendas_mes }}</span></td>
                                <td><span class="badge badge-success">Ativo</span></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum membro na equipe</h5>
                <p class="text-muted">Adicione especialistas à sua equipe para começar.</p>
            </div>
        @endif
    </div>
</div>

<!-- Modal Editar Equipe -->
<div class="modal fade" id="modalEditarEquipe" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Informações da Equipe</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('coordenador.equipes.update', $equipe->id) }}">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nome da Equipe *</label>
                        <input type="text" name="nome" class="form-control" value="{{ $equipe->nome }}" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Meta Mensal de Vendas</label>
                        <input type="number" name="meta_mensal" class="form-control" value="{{ $equipe->meta_mensal ?? 0 }}" min="0" placeholder="0">
                        <small class="text-muted">Deixe em branco ou 0 para não definir meta</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea name="descricao" class="form-control" rows="3" placeholder="Descrição opcional da equipe...">{{ $equipe->descricao }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Salvar Alterações
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Busca em tempo real
document.getElementById('searchMembros')?.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#tabelaMembros tbody tr');
    
    rows.forEach(row => {
        const nome = row.cells[0].textContent.toLowerCase();
        const email = row.cells[0].textContent.toLowerCase();
        const categoria = row.cells[1].textContent.toLowerCase();
        
        if (nome.includes(searchTerm) || email.includes(searchTerm) || categoria.includes(searchTerm)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

// Gráfico
const historicoData = @json($historicoVendas);
const labels = historicoData.map(item => {
    const [ano, mes] = item.mes.split('-');
    const meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
    return `${meses[parseInt(mes) - 1]} ${ano}`;
});
const vendas = historicoData.map(item => item.vendas);

const ctx = document.getElementById('historicoVendasChart').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: labels,
        datasets: [{
            label: 'Vendas',
            data: vendas,
            borderColor: '#22c55e',
            backgroundColor: 'rgba(34, 197, 94, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});
</script>
@endpush


