@extends('layouts.coordenador')

@section('title', 'Especialistas')

@section('content')
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Gerenciar Especialistas</h1>
        <p class="content-subtitle">Gerencie os especialistas da sua equipe e acompanhe o desempenho</p>
    </div>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdicionar">
        <i class="fas fa-plus me-2"></i>Adicionar Especialista
    </button>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error') || $errors->any())
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        {{ session('error') ?? $errors->first() }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('warning'))
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>{{ session('warning') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if($equipes->isNotEmpty())
    @php $equipe = $equipes->first(); @endphp
    
    <!-- Informações da Equipe -->
    <div class="card mb-4">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Equipe: {{ $equipe->nome }}</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4">
                    <label class="form-label text-muted">Total de Especialistas</label>
                    <div class="h4 mb-0">{{ $especialistasEquipe->count() }}</div>
                </div>
                <div class="col-md-4">
                    <label class="form-label text-muted">Status da Equipe</label>
                    <div>
                        <span class="badge badge-success">Ativa</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Lista de Especialistas -->
    <div class="card">
        <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Especialistas da Equipe</h5>
            <div class="col-md-4">
                <input type="text" class="form-control" id="searchEspecialistas" placeholder="Buscar especialista...">
            </div>
        </div>
        <div class="card-body">
            @if($especialistasEquipe->isNotEmpty())
                <div class="table-container">
                    <table class="table" id="tabelaEspecialistas">
                        <thead>
                            <tr>
                                <th>Especialista</th>
                                <th>Email</th>
                                <th>Data de Entrada</th>
                                <th>Total Alunos</th>
                                <th>Alunos Ativos</th>
                                <th>Alunos Concluídos</th>
                                <th>Taxa de Conclusão</th>
                                <th>Performance</th>
                                <th width="120">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($especialistasEquipe as $esp)
                                <tr>
                                    <td><strong>{{ $esp->nome }}</strong></td>
                                    <td>{{ $esp->email }}</td>
                                    <td>{{ \Carbon\Carbon::parse($esp->data_entrada)->format('d/m/Y') }}</td>
                                    <td><span class="badge badge-info">{{ $esp->total_alunos }}</span></td>
                                    <td><span class="badge badge-success">{{ $esp->alunos_ativos }}</span></td>
                                    <td><span class="badge badge-info">{{ $esp->alunos_concluidos }}</span></td>
                                    <td>
                                        <div class="progress" style="height: 8px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $esp->taxa_conclusao ?? 0 }}%"></div>
                                        </div>
                                        <small class="text-muted">{{ number_format($esp->taxa_conclusao ?? 0, 1) }}%</small>
                                    </td>
                                    <td>
                                        @php
                                            $taxa = $esp->taxa_conclusao ?? 0;
                                        @endphp
                                        @if($taxa >= 80)
                                            <span class="badge badge-success">Excelente</span>
                                        @elseif($taxa >= 60)
                                            <span class="badge badge-info">Bom</span>
                                        @elseif($taxa >= 40)
                                            <span class="badge badge-warning">Regular</span>
                                        @else
                                            <span class="badge badge-danger">Baixo</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-danger" onclick="removerEspecialista({{ $esp->usuario_equipe_id }}, '{{ $esp->nome }}')">
                                            <i class="fas fa-user-minus"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="fas fa-users fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Nenhum especialista na equipe</h5>
                    <p class="text-muted">Adicione especialistas para começar a gerenciar sua equipe.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalAdicionar">
                        <i class="fas fa-plus me-2"></i>Adicionar Primeiro Especialista
                    </button>
                </div>
            @endif
        </div>
    </div>
@endif

<!-- Modal Adicionar Especialista -->
<div class="modal fade" id="modalAdicionar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adicionar Especialista à Equipe</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('coordenador.especialistas.adicionar') }}">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="equipe_id" value="{{ $equipes->first()->id ?? '' }}">
                    
                    <div class="mb-3">
                        <label class="form-label">Selecionar Especialista *</label>
                        <select name="especialista_id" class="form-select" required>
                            <option value="">Selecione um especialista...</option>
                            @foreach($especialistasDisponiveis as $esp)
                                <option value="{{ $esp->id }}">{{ $esp->nome }} ({{ $esp->email }})</option>
                            @endforeach
                        </select>
                    </div>
                    
                    @if($especialistasDisponiveis->isEmpty())
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            Todos os especialistas já estão em equipes. Para adicionar novos especialistas, 
                            primeiro crie-os no sistema através do portal administrativo.
                        </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary" {{ $especialistasDisponiveis->isEmpty() ? 'disabled' : '' }}>
                        <i class="fas fa-plus me-2"></i>Adicionar à Equipe
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Busca em tempo real
document.getElementById('searchEspecialistas')?.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#tabelaEspecialistas tbody tr');
    
    rows.forEach(row => {
        const nome = row.cells[0].textContent.toLowerCase();
        const email = row.cells[1].textContent.toLowerCase();
        
        if (nome.includes(searchTerm) || email.includes(searchTerm)) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
});

function removerEspecialista(usuarioEquipeId, nomeEspecialista) {
    if (confirm(`Tem certeza que deseja remover ${nomeEspecialista} da equipe?`)) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '{{ route("coordenador.especialistas.remover") }}';
        form.style.display = 'none';
        
        const csrfInput = document.createElement('input');
        csrfInput.type = 'hidden';
        csrfInput.name = '_token';
        csrfInput.value = '{{ csrf_token() }}';
        
        const idInput = document.createElement('input');
        idInput.type = 'hidden';
        idInput.name = 'usuario_equipe_id';
        idInput.value = usuarioEquipeId;
        
        form.appendChild(csrfInput);
        form.appendChild(idInput);
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endpush


