@extends('layouts.coordenador')

@section('title', 'Relatórios')

@section('content')
<div class="content-header">
    <h1 class="content-title">Relatórios Consolidados</h1>
    <p class="content-subtitle">Relatórios detalhados sobre especialistas, alunos e performance da equipe</p>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('coordenador.relatorios.index') }}" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">Mês</label>
                <select name="mes" class="form-select">
                    @for($i = 1; $i <= 12; $i++)
                        <option value="{{ str_pad($i, 2, '0', STR_PAD_LEFT) }}" {{ $mes == str_pad($i, 2, '0', STR_PAD_LEFT) ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::create(null, $i, 1)->locale('pt_BR')->translatedFormat('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Ano</label>
                <select name="ano" class="form-select">
                    @for($i = date('Y'); $i >= date('Y') - 5; $i--)
                        <option value="{{ $i }}" {{ $ano == $i ? 'selected' : '' }}>{{ $i }}</option>
                    @endfor
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Especialista</label>
                <select name="especialista_id" class="form-select">
                    <option value="">Todos os especialistas</option>
                    @foreach($especialistas as $esp)
                        <option value="{{ $esp->id }}" {{ $especialistaId == $esp->id ? 'selected' : '' }}>
                            {{ $esp->nome }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Tipo de Relatório</label>
                <select name="tipo" class="form-select">
                    <option value="geral" {{ $tipoRelatorio == 'geral' ? 'selected' : '' }}>Geral</option>
                    <option value="especialistas" {{ $tipoRelatorio == 'especialistas' ? 'selected' : '' }}>Por Especialista</option>
                    <option value="alunos" {{ $tipoRelatorio == 'alunos' ? 'selected' : '' }}>Evolução dos Alunos</option>
                    <option value="vendas" {{ $tipoRelatorio == 'vendas' ? 'selected' : '' }}>Vendas por Período</option>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Estatísticas -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->total_alunos ?? 0 }}</div>
        <div class="stat-label">Total de Alunos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->vendas_mes ?? 0 }}</div>
        <div class="stat-label">Vendas {{ \Carbon\Carbon::create($ano, $mes, 1)->locale('pt_BR')->translatedFormat('F') }}</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->alunos_ativos ?? 0 }}</div>
        <div class="stat-label">Alunos Ativos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-graduation-cap"></i>
            </div>
        </div>
        <div class="stat-value">{{ $statsGerais->alunos_concluidos ?? 0 }}</div>
        <div class="stat-label">Alunos Concluídos</div>
    </div>
</div>

<!-- Relatório por Especialista -->
@if($tipoRelatorio == 'especialistas' || $tipoRelatorio == 'geral')
<div class="card mb-4">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Performance por Especialista</h5>
        <button type="button" class="btn btn-primary" onclick="exportarRelatorioEspecialistas()">
            <i class="fas fa-download me-2"></i>Exportar
        </button>
    </div>
    <div class="card-body">
        @if($relatorioEspecialistas->isNotEmpty())
            <div class="table-container">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Especialista</th>
                            <th>Total Alunos</th>
                            <th>Vendas {{ \Carbon\Carbon::create($ano, $mes, 1)->locale('pt_BR')->translatedFormat('F') }}</th>
                            <th>Alunos Ativos</th>
                            <th>Alunos Concluídos</th>
                            <th>Taxa de Conclusão</th>
                            <th>Valor Médio</th>
                            <th>Faturamento Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($relatorioEspecialistas as $esp)
                            <tr>
                                <td><strong>{{ $esp->nome }}</strong></td>
                                <td>{{ $esp->total_alunos }}</td>
                                <td><span class="badge badge-primary">{{ $esp->vendas_mes }}</span></td>
                                <td><span class="badge badge-success">{{ $esp->alunos_ativos }}</span></td>
                                <td><span class="badge badge-info">{{ $esp->alunos_concluidos }}</span></td>
                                <td>
                                    <div class="progress" style="height: 8px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $esp->taxa_conclusao ?? 0 }}%"></div>
                                    </div>
                                    <small class="text-muted">{{ number_format($esp->taxa_conclusao ?? 0, 1) }}%</small>
                                </td>
                                <td>
                                    <span class="text-success fw-bold">
                                        R$ {{ number_format($esp->valor_medio_curso ?? 0, 2, ',', '.') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="text-success fw-bold">
                                        R$ {{ number_format($esp->faturamento_total ?? 0, 2, ',', '.') }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-chart-bar fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum dado encontrado</h5>
                <p class="text-muted">Não há dados para o período selecionado.</p>
            </div>
        @endif
    </div>
</div>
@endif

<!-- Relatório Evolução Alunos -->
@if($tipoRelatorio == 'alunos' || $tipoRelatorio == 'geral')
<div class="card mb-4">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Evolução dos Alunos</h5>
        <button type="button" class="btn btn-primary" onclick="exportarRelatorioAlunos()">
            <i class="fas fa-download me-2"></i>Exportar
        </button>
    </div>
    <div class="card-body">
        @if($relatorioAlunos->isNotEmpty())
            <div class="table-container">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Aluno</th>
                            <th>Especialista</th>
                            <th>Data Cadastro</th>
                            <th>Status</th>
                            <th>Módulo Atual</th>
                            <th>Progresso</th>
                            <th>Valor do Curso</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($relatorioAlunos as $aluno)
                            <tr>
                                <td>
                                    <strong>{{ $aluno->nome }}</strong><br>
                                    <small class="text-muted">{{ $aluno->email }}</small>
                                </td>
                                <td><span class="badge badge-info">{{ $aluno->especialista_nome }}</span></td>
                                <td>{{ \Carbon\Carbon::parse($aluno->data_cadastro)->format('d/m/Y') }}</td>
                                <td>
                                    @php
                                        $status_cores = [
                                            'ativo' => 'badge-success',
                                            'concluido' => 'badge-info',
                                            'parado' => 'badge-warning'
                                        ];
                                        $status_formatado = [
                                            'ativo' => 'Em andamento',
                                            'concluido' => 'Concluído',
                                            'parado' => 'Parado'
                                        ];
                                    @endphp
                                    <span class="badge {{ $status_cores[$aluno->status] ?? 'badge-secondary' }}">
                                        {{ $status_formatado[$aluno->status] ?? $aluno->status }}
                                    </span>
                                </td>
                                <td>{{ $aluno->modulo_atual ?? 'N/A' }}</td>
                                <td>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $aluno->progresso ?? 0 }}%">
                                            {{ number_format($aluno->progresso ?? 0, 1) }}%
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="text-success fw-bold">
                                        R$ {{ number_format($aluno->valor_curso ?? 0, 2, ',', '.') }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum aluno encontrado</h5>
                <p class="text-muted">Não há alunos registrados para a equipe.</p>
            </div>
        @endif
    </div>
</div>
@endif

<!-- Relatório Vendas por Período -->
@if($tipoRelatorio == 'vendas' || $tipoRelatorio == 'geral')
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Vendas por Período (Últimos 12 Meses)</h5>
    </div>
    <div class="card-body">
        @if($relatorioVendasPeriodo->isNotEmpty())
            <canvas id="vendasPeriodoChart" height="80"></canvas>
            
            <div class="table-container mt-4">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Período</th>
                            <th>Vendas</th>
                            <th>Faturamento</th>
                            <th>Alunos Ativos</th>
                            <th>Alunos Concluídos</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($relatorioVendasPeriodo as $periodo)
                            <tr>
                                <td>
                                    <strong>
                                        {{ \Carbon\Carbon::createFromFormat('Y-m', $periodo->mes)->locale('pt_BR')->translatedFormat('F/Y') }}
                                    </strong>
                                </td>
                                <td><span class="badge badge-primary">{{ $periodo->vendas }}</span></td>
                                <td>
                                    <span class="text-success fw-bold">
                                        R$ {{ number_format($periodo->faturamento ?? 0, 2, ',', '.') }}
                                    </span>
                                </td>
                                <td><span class="badge badge-success">{{ $periodo->alunos_ativos }}</span></td>
                                <td><span class="badge badge-info">{{ $periodo->alunos_concluidos }}</span></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-chart-line fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum dado de vendas encontrado</h5>
                <p class="text-muted">Não há dados de vendas para o período selecionado.</p>
            </div>
        @endif
    </div>
</div>
@endif
@endsection

@push('scripts')
<script>
// Gráfico vendas por período
@if($relatorioVendasPeriodo->isNotEmpty())
const vendasPeriodoData = @json($relatorioVendasPeriodo);
const labelsPeriodo = vendasPeriodoData.map(item => {
    const [ano, mes] = item.mes.split('-');
    const meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
    return `${meses[parseInt(mes) - 1]} ${ano}`;
});
const vendasPeriodo = vendasPeriodoData.map(item => item.vendas);
const faturamentoPeriodo = vendasPeriodoData.map(item => item.faturamento);

const ctxPeriodo = document.getElementById('vendasPeriodoChart').getContext('2d');
new Chart(ctxPeriodo, {
    type: 'bar',
    data: {
        labels: labelsPeriodo,
        datasets: [
            {
                label: 'Vendas',
                data: vendasPeriodo,
                backgroundColor: 'rgba(34, 197, 94, 0.8)',
                borderColor: '#22c55e',
                borderWidth: 1,
                yAxisID: 'y'
            },
            {
                label: 'Faturamento (R$)',
                data: faturamentoPeriodo,
                backgroundColor: 'rgba(59, 130, 246, 0.8)',
                borderColor: '#3b82f6',
                borderWidth: 1,
                yAxisID: 'y1',
                type: 'line'
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: true
            }
        },
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                beginAtZero: true,
                grid: {
                    drawOnChartArea: false,
                },
                ticks: {
                    callback: function(value) {
                        return 'R$ ' + value.toLocaleString('pt-BR');
                    }
                }
            }
        }
    }
});
@endif

function exportarRelatorioEspecialistas() {
    const dados = @json($relatorioEspecialistas);
    const headers = ['Especialista', 'Total Alunos', 'Vendas do Mês', 'Alunos Ativos', 'Alunos Concluídos', 'Taxa de Conclusão', 'Valor Médio', 'Faturamento Total'];
    
    const csvContent = [
        headers.join(','),
        ...dados.map(row => [
            row.nome,
            row.total_alunos,
            row.vendas_mes,
            row.alunos_ativos,
            row.alunos_concluidos,
            (row.taxa_conclusao || 0) + '%',
            'R$ ' + (row.valor_medio_curso || 0).toFixed(2).replace('.', ','),
            'R$ ' + (row.faturamento_total || 0).toFixed(2).replace('.', ',')
        ].join(','))
    ].join('\n');
    
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = `relatorio_especialistas_${{{ $mes }}}_${{{ $ano }}}.csv`;
    link.click();
}

function exportarRelatorioAlunos() {
    const dados = @json($relatorioAlunos);
    const headers = ['Aluno', 'Email', 'Especialista', 'Data Cadastro', 'Status', 'Módulo Atual', 'Progresso', 'Valor do Curso'];
    
    const csvContent = [
        headers.join(','),
        ...dados.map(row => [
            row.nome,
            row.email,
            row.especialista_nome,
            row.data_cadastro,
            row.status,
            row.modulo_atual || 'N/A',
            (row.progresso || 0) + '%',
            'R$ ' + (row.valor_curso || 0).toFixed(2).replace('.', ',')
        ].join(','))
    ].join('\n');
    
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = `relatorio_alunos_${{{ $mes }}}_${{{ $ano }}}.csv`;
    link.click();
}
</script>
@endpush


