@extends('layouts.especialista')

@section('title', 'Comissões')

@section('content')
<div class="content-header">
    <h1 class="content-title">Minhas Comissões</h1>
    <p class="content-subtitle">Acompanhe seus ganhos e comissões de vendas</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-list-alt"></i>
            </div>
        </div>
        <div class="stat-value">{{ $stats['total_comissoes'] }}</div>
        <div class="stat-label">Total de Comissões</div>
        <small class="text-muted">No período</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($stats['valor_pendente'], 0, ',', '.') }}</div>
        <div class="stat-label">A Receber</div>
        <small class="text-muted">{{ $stats['qtd_pendente'] }} comissões</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($stats['valor_pago'], 0, ',', '.') }}</div>
        <div class="stat-label">Recebido</div>
        <small class="text-muted">{{ $stats['qtd_paga'] }} comissões</small>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($stats['valor_total'], 0, ',', '.') }}</div>
        <div class="stat-label">Total Ganho</div>
        <small class="text-muted">No período</small>
    </div>
</div>

<!-- Gráfico de Evolução -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-chart-line me-2"></i>
            Evolução de Comissões (Últimos 6 Meses)
        </h5>
    </div>
    <div class="card-body">
        <canvas id="graficoComissoes" height="80"></canvas>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('especialista.comissoes.index') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Status</label>
                <select name="status" class="form-select" onchange="this.form.submit()">
                    <option value="todas" {{ $filtroStatus == 'todas' ? 'selected' : '' }}>Todas</option>
                    <option value="pendente" {{ $filtroStatus == 'pendente' ? 'selected' : '' }}>Pendentes</option>
                    <option value="paga" {{ $filtroStatus == 'paga' ? 'selected' : '' }}>Pagas</option>
                </select>
            </div>
            
            <div class="col-md-4">
                <label class="form-label">Período</label>
                <select name="periodo" class="form-select" onchange="this.form.submit()">
                    <option value="semana" {{ $filtroPeriodo == 'semana' ? 'selected' : '' }}>Esta Semana</option>
                    <option value="mes" {{ $filtroPeriodo == 'mes' ? 'selected' : '' }}>Este Mês</option>
                    <option value="trimestre" {{ $filtroPeriodo == 'trimestre' ? 'selected' : '' }}>Este Trimestre</option>
                    <option value="ano" {{ $filtroPeriodo == 'ano' ? 'selected' : '' }}>Este Ano</option>
                </select>
            </div>
            
            <div class="col-md-4 d-flex align-items-end">
                <a href="{{ route('especialista.comissoes.index') }}" class="btn btn-secondary w-100">
                    <i class="fas fa-redo me-2"></i>Limpar Filtros
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Lista de Comissões -->
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-list me-2"></i>
            Minhas Comissões ({{ $comissoes->count() }})
        </h5>
    </div>
    <div class="card-body">
        @if($comissoes->isEmpty())
            <div class="text-center py-5 text-muted">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p>Nenhuma comissão encontrada no período selecionado</p>
            </div>
        @else
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Cliente</th>
                            <th>Lead Origem</th>
                            <th>Valor da Venda</th>
                            <th>Comissão (10%)</th>
                            <th>Status</th>
                            <th>Data Geração</th>
                            <th>Data Pagamento</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($comissoes as $com)
                            <tr>
                                <td><strong>#{{ $com->id }}</strong></td>
                                <td>
                                    <div>
                                        <strong>{{ $com->aluno_nome }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $com->aluno_email }}</small>
                                    </div>
                                </td>
                                <td>
                                    @if($com->lead_nome)
                                        <span class="badge bg-info">
                                            <i class="fas fa-user-tag"></i> {{ $com->lead_nome }}
                                        </span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <strong class="text-primary">R$ {{ number_format($com->valor_venda, 2, ',', '.') }}</strong>
                                    @if($com->num_parcelas)
                                        <br>
                                        <small class="text-muted">
                                            {{ $com->num_parcelas }}x parcelas
                                        </small>
                                    @endif
                                </td>
                                <td>
                                    <strong class="text-success fs-5">R$ {{ number_format($com->valor, 2, ',', '.') }}</strong>
                                </td>
                                <td>
                                    @if($com->status == 'pendente')
                                        <span class="badge bg-warning">
                                            <i class="fas fa-clock"></i> Pendente
                                        </span>
                                    @elseif($com->status == 'paga')
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle"></i> Paga
                                        </span>
                                    @elseif($com->status == 'liberada')
                                        <span class="badge bg-info">
                                            <i class="fas fa-unlock"></i> Liberada
                                        </span>
                                    @else
                                        <span class="badge bg-secondary">
                                            {{ ucfirst($com->status) }}
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted">
                                        @if(isset($com->data_negociacao))
                                            {{ \Carbon\Carbon::parse($com->data_negociacao)->format('d/m/Y') }}
                                        @elseif(isset($com->data_prevista))
                                            {{ \Carbon\Carbon::parse($com->data_prevista)->format('d/m/Y') }}
                                        @else
                                            -
                                        @endif
                                    </small>
                                </td>
                                <td>
                                    @if($com->status == 'paga' && isset($com->data_prevista))
                                        <small class="text-success">
                                            <i class="fas fa-calendar-check"></i>
                                            {{ \Carbon\Carbon::parse($com->data_prevista)->format('d/m/Y') }}
                                        </small>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-secondary">
                            <td colspan="4" class="text-end"><strong>TOTAL:</strong></td>
                            <td><strong class="text-success fs-5">R$ {{ number_format($stats['valor_total'], 2, ',', '.') }}</strong></td>
                            <td colspan="3"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @endif
    </div>
</div>

<div class="alert alert-info mt-4">
    <h6><i class="fas fa-info-circle me-2"></i>Como Funcionam as Comissões:</h6>
    <ul class="mb-0">
        <li>Você recebe <strong>10% do valor total</strong> de cada venda aprovada</li>
        <li>A comissão é gerada automaticamente quando a venda é aprovada pelo admin</li>
        <li>Status <strong>Pendente</strong>: Aguardando processamento do pagamento</li>
        <li>Status <strong>Paga</strong>: Comissão já foi creditada para você</li>
        <li>O pagamento geralmente ocorre até o 5º dia útil do mês seguinte</li>
    </ul>
</div>

@push('scripts')
<script>
const comissoesPorMes = {!! json_encode($comissoesPorMes) !!};

const ctx = document.getElementById('graficoComissoes').getContext('2d');
new Chart(ctx, {
    type: 'bar',
    data: {
        labels: comissoesPorMes.map(c => {
            const [ano, mes] = c.mes.split('-');
            const meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
            return meses[parseInt(mes) - 1] + '/' + ano.substr(2);
        }),
        datasets: [{
            label: 'Comissões Geradas (R$)',
            data: comissoesPorMes.map(c => c.valor_total),
            backgroundColor: 'rgba(59, 130, 246, 0.6)',
            borderColor: 'rgb(59, 130, 246)',
            borderWidth: 2
        }, {
            label: 'Comissões Pagas (R$)',
            data: comissoesPorMes.map(c => c.valor_pago),
            backgroundColor: 'rgba(34, 197, 94, 0.6)',
            borderColor: 'rgb(34, 197, 94)',
            borderWidth: 2
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        interaction: {
            mode: 'index',
            intersect: false
        },
        plugins: {
            legend: {
                display: true,
                position: 'top'
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        let label = context.dataset.label || '';
                        if (label) {
                            label += ': ';
                        }
                        if (context.parsed.y !== null) {
                            label += 'R$ ' + context.parsed.y.toFixed(2).replace('.', ',');
                        }
                        return label;
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                title: {
                    display: true,
                    text: 'Valor (R$)'
                },
                ticks: {
                    callback: function(value) {
                        return 'R$ ' + value.toFixed(0);
                    }
                }
            }
        }
    }
});
</script>
@endpush

@endsection

