@extends('layouts.especialista')

@section('title', 'Logs de Pagamento')

@section('content')
<div class="content-header">
    <h1 class="content-title">Logs de Negociações</h1>
    <p class="content-subtitle">Acompanhe suas negociações e status dos pagamentos</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-list"></i>
            </div>
        </div>
        <div class="stat-value">{{ $logs->count() }}</div>
        <div class="stat-label">Total de Negociações</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-link"></i>
            </div>
        </div>
        <div class="stat-value">{{ $logs->where('status', 'fechado')->count() }}</div>
        <div class="stat-label">Negociações Fechadas</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ $totalPagos }}</div>
        <div class="stat-label">Pagamentos Confirmados</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ {{ number_format($valorPago, 0, ',', '.') }}</div>
        <div class="stat-label">Total Pago</div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-history me-2"></i>
            Histórico de Negociações ({{ $logs->count() }})
        </h5>
    </div>
    <div class="card-body p-0">
        @if($logs->isEmpty())
            <div class="text-center py-5 text-muted">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p>Nenhuma negociação encontrada</p>
                <small>Crie uma negociação na página de Atendimentos</small>
            </div>
        @else
            <div class="logs-container">
                @foreach($logs as $log)
                    <div class="log-card">
                        <div class="log-header">
                            <div class="log-info-main">
                                <div class="log-title">
                                    <strong>Negociação #{{ $log->negociacao_id }}</strong>
                                    <span class="ms-2 text-muted">|</span>
                                    <span class="ms-2">{{ $log->aluno_nome }}</span>
                                    @if($log->lead_nome)
                                        <span class="badge bg-info ms-2">
                                            <i class="fas fa-user-tag"></i> {{ $log->lead_nome }}
                                        </span>
                                    @endif
                                </div>
                                <div class="log-meta">
                                    <span class="text-muted">
                                        <i class="fas fa-calendar"></i> {{ \Carbon\Carbon::parse($log->data_criacao)->format('d/m/Y H:i') }}
                                    </span>
                                    <span class="text-success ms-3">
                                        <i class="fas fa-dollar-sign"></i> <strong>R$ {{ number_format($log->valor_total, 2, ',', '.') }}</strong>
                                    </span>
                                    @if($log->status == 'fechado' && $log->valor_pago > 0)
                                        <span class="badge bg-success ms-3">
                                            <i class="fas fa-check-circle"></i> Pago
                                        </span>
                                    @elseif($log->status == 'fechado')
                                        <span class="badge bg-info ms-3">
                                            <i class="fas fa-check"></i> Fechado
                                        </span>
                                    @else
                                        <span class="badge bg-warning ms-3">
                                            <i class="fas fa-clock"></i> Em Andamento
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="log-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-dollar-sign"></i> Valor Total
                                    </small>
                                    <strong class="text-primary">R$ {{ number_format($log->valor_total ?? 0, 2, ',', '.') }}</strong>
                                </div>
                                
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-wallet"></i> Valor Pago
                                    </small>
                                    <strong class="text-success">R$ {{ number_format($log->valor_pago ?? 0, 2, ',', '.') }}</strong>
                                </div>
                                
                                @if($log->saldo_restante > 0)
                                    <div class="col-md-6">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-exclamation-circle"></i> Saldo Restante
                                        </small>
                                        <strong class="text-warning">R$ {{ number_format($log->saldo_restante, 2, ',', '.') }}</strong>
                                    </div>
                                @endif
                                
                                <div class="col-md-6">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-info-circle"></i> Status
                                    </small>
                                    @if($log->status == 'fechado')
                                        <span class="badge bg-success">
                                            <i class="fas fa-check-circle"></i> Fechado
                                        </span>
                                    @elseif($log->status == 'perdido')
                                        <span class="badge bg-danger">
                                            <i class="fas fa-times-circle"></i> Perdido
                                        </span>
                                    @else
                                        <span class="badge bg-warning">
                                            <i class="fas fa-clock"></i> Em Andamento
                                        </span>
                                    @endif
                                </div>
                                
                                @if($log->data_fechamento)
                                    <div class="col-md-6">
                                        <small class="text-muted d-block mb-1">
                                            <i class="fas fa-check"></i> Fechado em
                                        </small>
                                        <span class="text-success">{{ \Carbon\Carbon::parse($log->data_fechamento)->format('d/m/Y H:i:s') }}</span>
                                    </div>
                                @endif
                                
                                <div class="col-md-12">
                                    <small class="text-muted d-block mb-1">
                                        <i class="fas fa-user"></i> Cliente
                                    </small>
                                    <div>
                                        {{ $log->aluno_nome }}
                                        <span class="text-muted ms-2">|</span>
                                        <span class="text-muted ms-2">{{ $log->aluno_email }}</span>
                                        @if($log->aluno_celular)
                                            <span class="text-muted ms-2">|</span>
                                            <a href="https://wa.me/55{{ preg_replace('/[^0-9]/', '', $log->aluno_celular) }}" 
                                               target="_blank" class="text-success text-decoration-none ms-2">
                                                <i class="fab fa-whatsapp"></i> {{ $log->aluno_celular }}
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>

@push('styles')
<style>
.logs-container {
    padding: 1rem;
}

.log-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 1rem;
    overflow: hidden;
}

.log-card:hover {
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.log-header {
    padding: 1rem;
    background: #f8f9fa;
    border-bottom: 1px solid #e0e0e0;
}

.log-title {
    font-size: 15px;
    margin-bottom: 6px;
}

.log-meta {
    font-size: 13px;
    margin-top: 4px;
}

.log-body {
    padding: 1rem;
}

.font-monospace {
    font-family: 'Courier New', Courier, monospace;
    font-size: 12px;
}
</style>
@endpush


@endsection

