<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Admin') - Vencer Leitura</title>
    
    <!-- Fontes -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        :root {
            --surface-bg: #ffffff;
            --border-color: #e5e7eb;
            --text-dark: #1f2937;
            --text-secondary: #6b7280;
            --primary-purple: #5a3e9a;
            --light-purple-bg: #f3f0ff;
            --gradient-primary: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --danger: #ef4444;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
        }
        
        .app-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 260px;
            min-width: 260px;
            max-width: 260px;
            flex-shrink: 0;
            background: var(--surface-bg);
            border-right: 1px solid var(--border-color);
            padding: 1.5rem 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            transition: all 0.3s ease;
            z-index: 1000;
            box-shadow: none;
        }
        
        /* Estilização da Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: #d1d5db;
            border-radius: 10px;
            transition: background 0.2s;
        }
        
        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #9ca3af;
        }
        
        /* Firefox */
        .sidebar {
            scrollbar-width: thin;
            scrollbar-color: #d1d5db transparent;
        }
        
        .sidebar-header {
            padding: 0 1.5rem 1.5rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 1.5rem;
        }
        
        .sidebar-brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
        }
        
        .sidebar-logo {
            width: 38px;
            height: 38px;
            background: var(--gradient-primary);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            color: white;
        }
        
        .sidebar-brand-text {
            font-size: 1.15rem;
            font-weight: 600;
            color: var(--text-dark);
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0 1rem;
        }
        
        .sidebar-menu li {
            margin-bottom: 0.25rem;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 0.8rem;
            padding: 0.75rem 1rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s ease;
            font-weight: 500;
        }
        
        .sidebar-menu a:hover {
            background: var(--light-purple-bg);
            color: var(--primary-purple);
        }
        
        .sidebar-menu a.active {
            background: var(--gradient-primary);
            color: white;
            box-shadow: 0 4px 12px rgba(90, 62, 154, 0.25);
        }
        
        .sidebar-menu a i {
            font-size: 1rem;
            width: 20px;
            text-align: center;
        }
        
        .sidebar-logout {
            margin-top: 1.5rem;
            border-top: 1px solid var(--border-color);
            padding-top: 1rem;
        }
        
        .sidebar-logout button {
            color: var(--text-secondary) !important;
            padding: 0.75rem 1rem !important;
            border-radius: 8px !important;
            transition: background-color 0.2s ease, color 0.2s ease !important;
            display: flex;
            align-items: center;
            gap: 0.8rem;
        }
        
        .sidebar-logout button:hover {
            background: rgba(239, 68, 68, 0.1) !important;
            color: var(--danger) !important;
        }
        
        .main-content {
            flex: 1;
            margin-left: 260px;
            padding: 30px;
        }
        
        .content-header {
            margin-bottom: 30px;
        }
        
        .content-title {
            font-size: 28px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 5px;
        }
        
        .content-subtitle {
            color: #64748b;
            font-size: 14px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #64748b;
            font-size: 14px;
        }
        
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border: none;
        }
        
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.mobile-visible {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <nav class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <a href="{{ route('admin.dashboard') }}" class="sidebar-brand">
                    <div class="sidebar-logo">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <div class="sidebar-brand-text">
                        Vencer <strong>Admin</strong>
                    </div>
                </a>
            </div>
            
            <ul class="sidebar-menu">
                <li>
                    <a href="{{ route('admin.dashboard') }}" class="{{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.usuarios.index') }}" class="{{ request()->routeIs('admin.usuarios.*') ? 'active' : '' }}">
                        <i class="fas fa-users"></i>
                        <span>Usuários</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.categorias.index') }}" class="{{ request()->routeIs('admin.categorias.*') ? 'active' : '' }}">
                        <i class="fas fa-tags"></i>
                        <span>Categorias</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.leads.index') }}" class="{{ request()->routeIs('admin.leads.*') ? 'active' : '' }}">
                        <i class="fas fa-user-plus"></i>
                        <span>Gestão de Leads</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.gestao.index') }}" class="{{ request()->routeIs('admin.gestao.*') ? 'active' : '' }}">
                        <i class="fas fa-tasks"></i>
                        <span>Gestão Avançada</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.marketing.index') }}" class="{{ request()->routeIs('admin.marketing.*') ? 'active' : '' }}">
                        <i class="fas fa-bullhorn"></i>
                        <span>Marketing</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.contratos.index') }}" class="{{ request()->routeIs('admin.contratos.*') ? 'active' : '' }}">
                        <i class="fas fa-file-contract"></i>
                        <span>Contratos</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.vouchers.index') }}" class="{{ request()->routeIs('admin.vouchers.*') ? 'active' : '' }}">
                        <i class="fas fa-ticket-alt"></i>
                        <span>Vouchers</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.equipes.index') }}" class="{{ request()->routeIs('admin.equipes.*') ? 'active' : '' }}">
                        <i class="fas fa-layer-group"></i>
                        <span>Equipes</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.valores-curso.index') }}" class="{{ request()->routeIs('admin.valores-curso.*') ? 'active' : '' }}">
                        <i class="fas fa-dollar-sign"></i>
                        <span>Valor Treinamento</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.vendas.index') }}" class="{{ request()->routeIs('admin.vendas.*') ? 'active' : '' }}">
                        <i class="fas fa-check-circle"></i>
                        <span>Aprovar Vendas</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.horarios.index') }}" class="{{ request()->routeIs('admin.horarios.*') ? 'active' : '' }}">
                        <i class="fas fa-clock"></i>
                        <span>Horários de Funcionamento</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.atendimentos.index') }}" class="{{ request()->routeIs('admin.atendimentos.*') ? 'active' : '' }}">
                        <i class="fas fa-columns"></i>
                        <span>Kanban Geral</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.financeiro.index') }}" class="{{ request()->routeIs('admin.financeiro.*') ? 'active' : '' }}">
                        <i class="fas fa-money-bill-wave"></i>
                        <span>Financeiro</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.comissoes.index') }}" class="{{ request()->routeIs('admin.comissoes.*') ? 'active' : '' }}">
                        <i class="fas fa-percentage"></i>
                        <span>Comissões</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.relatorios.index') }}" class="{{ request()->routeIs('admin.relatorios.*') ? 'active' : '' }}">
                        <i class="fas fa-chart-bar"></i>
                        <span>Relatórios</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('admin.configuracoes.index') }}" class="{{ request()->routeIs('admin.configuracoes.*') ? 'active' : '' }}">
                        <i class="fas fa-cog"></i>
                        <span>Configurações</span>
                    </a>
                </li>
                <li class="mt-4 sidebar-logout">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="btn btn-link text-white text-decoration-none w-100 text-start" style="padding: 12px 15px;">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Sair</span>
                        </button>
                    </form>
                </li>
            </ul>
        </nav>

        <!-- Main Content -->
        <div class="main-content">
            @yield('content')
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle mobile sidebar
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('mobile-visible');
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            
            if (sidebar && window.innerWidth <= 992 && 
                !sidebar.contains(event.target) &&
                sidebar.classList.contains('mobile-visible')) {
                sidebar.classList.remove('mobile-visible');
            }
        });
    </script>
    
    @stack('scripts')
</body>
</html>

