<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Especialista') - Vencer Leitura</title>
    
    <!-- Fontes -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        :root {
            --surface-bg: #ffffff;
            --border-color: #e5e7eb;
            --text-dark: #1f2937;
            --text-secondary: #6b7280;
            --primary-blue: #3b82f6;
            --light-blue-bg: #eff6ff;
            --gradient-primary: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            --danger: #ef4444;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fa;
        }
        
        .app-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 260px;
            min-width: 260px;
            max-width: 260px;
            flex-shrink: 0;
            background: var(--surface-bg);
            border-right: 1px solid var(--border-color);
            padding: 1.5rem 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
            transition: all 0.3s ease;
            z-index: 1000;
            box-shadow: none;
        }
        
        /* Estilização da Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: #d1d5db;
            border-radius: 10px;
            transition: background 0.2s;
        }
        
        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #9ca3af;
        }
        
        /* Firefox */
        .sidebar {
            scrollbar-width: thin;
            scrollbar-color: #d1d5db transparent;
        }
        
        .sidebar-header {
            padding: 0 1.5rem 1.5rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 1.5rem;
        }
        
        .sidebar-brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
        }
        
        .sidebar-logo {
            width: 38px;
            height: 38px;
            background: var(--gradient-primary);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            color: white;
        }
        
        .sidebar-brand-text {
            font-size: 1.15rem;
            font-weight: 600;
            color: var(--text-dark);
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 0 1rem;
        }
        
        .sidebar-menu li {
            margin-bottom: 0.25rem;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 0.8rem;
            padding: 0.75rem 1rem;
            color: var(--text-secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s ease;
            font-weight: 500;
        }
        
        .sidebar-menu a:hover {
            background: var(--light-blue-bg);
            color: var(--primary-blue);
        }
        
        .sidebar-menu a.active {
            background: var(--gradient-primary);
            color: white;
            font-weight: 600;
        }
        
        .sidebar-menu a i {
            width: 20px;
            text-align: center;
        }
        
        .sidebar-logout {
            margin-top: 1.5rem;
            border-top: 1px solid var(--border-color);
            padding-top: 1rem;
        }
        
        .sidebar-logout button {
            color: var(--text-secondary) !important;
            padding: 0.75rem 1rem !important;
            border-radius: 8px !important;
            transition: background-color 0.2s ease, color 0.2s ease !important;
            display: flex;
            align-items: center;
            gap: 0.8rem;
            width: 100%;
            text-align: left;
            border: none;
            background: none;
        }
        
        .sidebar-logout button:hover {
            background: rgba(239, 68, 68, 0.1) !important;
            color: var(--danger) !important;
        }
        
        .main-content {
            flex: 1;
            margin-left: 260px;
            padding: 30px;
        }
        
        .content-header {
            margin-bottom: 30px;
        }
        
        .content-title {
            font-size: 28px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 5px;
        }
        
        .content-subtitle {
            color: #64748b;
            font-size: 14px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }
        
        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #64748b;
            font-size: 14px;
        }
        
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border: none;
            margin-bottom: 20px;
        }
        
        .card-header {
            padding: 1.25rem 1.5rem;
            border-bottom: 1px solid var(--border-color);
            background: white;
            border-radius: 15px 15px 0 0;
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        .btn-primary {
            background: var(--gradient-primary);
            border: none;
            color: white;
            padding: 0.625rem 1.25rem;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }
        
        .btn-success {
            background: var(--primary-blue);
            border: none;
            color: white;
        }
        
        .table-container {
            overflow-x: auto;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .table thead th {
            background: #f9fafb;
            color: var(--text-dark);
            font-weight: 600;
            padding: 0.875rem 1rem;
            text-align: left;
            border-bottom: 2px solid var(--border-color);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .table tbody td {
            padding: 1rem;
            border-bottom: 1px solid var(--border-color);
            color: var(--text-dark);
        }
        
        .table tbody tr:hover {
            background: #f9fafb;
        }
        
        .badge {
            padding: 0.375rem 0.75rem;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .badge-success {
            background: #dcfce7;
            color: #16a34a;
        }
        
        .badge-info {
            background: #dbeafe;
            color: #2563eb;
        }
        
        .badge-warning {
            background: #fef3c7;
            color: #d97706;
        }
        
        .badge-danger {
            background: #fee2e2;
            color: #dc2626;
        }
        
        .badge-primary {
            background: var(--light-blue-bg);
            color: var(--primary-blue);
        }
        
        .form-control, .form-select {
            border: 1px solid var(--border-color);
            border-radius: 8px;
            padding: 0.625rem 0.875rem;
            transition: all 0.2s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
            outline: none;
        }
        
        .alert {
            border-radius: 10px;
            padding: 1rem 1.25rem;
            border: none;
        }
        
        .alert-success {
            background: #dcfce7;
            color: #16a34a;
        }
        
        .alert-info {
            background: #dbeafe;
            color: #2563eb;
        }
        
        .alert-warning {
            background: #fef3c7;
            color: #d97706;
        }
        
        .alert-danger {
            background: #fee2e2;
            color: #dc2626;
        }
        
        .progress {
            height: 8px;
            background: #e5e7eb;
            border-radius: 10px;
            overflow: hidden;
        }
        
        .progress-bar {
            height: 100%;
            background: var(--gradient-primary);
            transition: width 0.3s ease;
        }
        
        .bg-success {
            background: var(--primary-blue) !important;
        }
        
        .btn-outline-danger {
            border: 1px solid var(--danger);
            color: var(--danger);
            background: transparent;
        }
        
        .btn-outline-danger:hover {
            background: var(--danger);
            color: white;
        }
        
        .btn-secondary {
            background: #6b7280;
            border: none;
            color: white;
        }
        
        .btn-sm {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
        }
        
        .text-success {
            color: var(--primary-blue) !important;
        }
        
        .fw-bold {
            font-weight: 700;
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }
        
        .empty-state-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
        
        .empty-state-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--text-dark);
            margin-bottom: 0.5rem;
        }
        
        .empty-state-description {
            color: var(--text-secondary);
            margin-bottom: 1.5rem;
        }
        
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.mobile-visible {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <nav class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <a href="{{ route('especialista.dashboard') }}" class="sidebar-brand">
                    <div class="sidebar-logo">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <div class="sidebar-brand-text">
                        Vencer <strong>Vendas</strong>
                    </div>
                </a>
            </div>
            
            <ul class="sidebar-menu">
                <li>
                    <a href="{{ route('especialista.dashboard') }}" class="{{ request()->routeIs('especialista.dashboard') ? 'active' : '' }}">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.atendimentos.index') }}" class="{{ request()->routeIs('especialista.atendimentos.*') ? 'active' : '' }}">
                        <i class="fas fa-headset"></i>
                        <span>Atendimentos</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.meu-link.index') }}" class="{{ request()->routeIs('especialista.meu-link.*') ? 'active' : '' }}">
                        <i class="fas fa-link"></i>
                        <span>Meu Link</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.meus-alunos.index') }}" class="{{ request()->routeIs('especialista.meus-alunos.*') ? 'active' : '' }}">
                        <i class="fas fa-users"></i>
                        <span>Meus Alunos</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.logs-pagamento.index') }}" class="{{ request()->routeIs('especialista.logs-pagamento.*') ? 'active' : '' }}">
                        <i class="fas fa-file-invoice"></i>
                        <span>Logs Pagar.me</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.comissoes.index') }}" class="{{ request()->routeIs('especialista.comissoes.*') ? 'active' : '' }}">
                        <i class="fas fa-percentage"></i>
                        <span>Comissões</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.vouchers.index') }}" class="{{ request()->routeIs('especialista.vouchers.*') ? 'active' : '' }}">
                        <i class="fas fa-ticket-alt"></i>
                        <span>Vouchers</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('especialista.perfil.index') }}" class="{{ request()->routeIs('especialista.perfil.*') ? 'active' : '' }}">
                        <i class="fas fa-user-circle"></i>
                        <span>Meu Perfil</span>
                    </a>
                </li>
            </ul>
            
            <div class="sidebar-logout">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>Sair</span>
                    </button>
                </form>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="main-content">
            @yield('content')
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle mobile sidebar
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('mobile-visible');
        }

        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            
            if (sidebar && window.innerWidth <= 992 && 
                !sidebar.contains(event.target) &&
                sidebar.classList.contains('mobile-visible')) {
                sidebar.classList.remove('mobile-visible');
            }
        });
    </script>
    
    @stack('scripts')
</body>
</html>
