

<?php $__env->startSection('title', 'Vouchers'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Meus Vouchers de Desconto</h1>
    <p class="content-subtitle">Visualize os vouchers disponíveis para usar nas negociações</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-ticket-alt"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(count($vouchers)); ?></div>
        <div class="stat-label">Vouchers Disponíveis</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($stats->total_usos ?? 0); ?></div>
        <div class="stat-label">Vezes Utilizados</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-dollar-sign"></i>
            </div>
        </div>
        <div class="stat-value">R$ <?php echo e(number_format($stats->valor_total_vendas ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Total em Vendas</div>
    </div>
</div>

<div class="alert alert-info">
    <i class="fas fa-info-circle me-2"></i>
    <strong>Informação:</strong> Apenas o administrador pode criar novos vouchers. 
    Os vouchers criados pelo admin aparecerão automaticamente aqui.
</div>

<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            <i class="fas fa-list me-2"></i>
            Vouchers Disponíveis para Uso
        </h5>
        <span class="badge bg-primary"><?php echo e(count($vouchers)); ?></span>
    </div>
    <div class="card-body">
        <?php if(empty($vouchers)): ?>
            <div class="text-center py-5">
                <i class="fas fa-ticket-alt fa-3x text-muted mb-3"></i>
                <p class="text-muted">Nenhum voucher disponível no momento</p>
                <small class="text-muted">O administrador pode criar vouchers para você em: Admin → Vouchers</small>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Desconto</th>
                            <th>Tipo</th>
                            <th>Quantidade Disponível</th>
                            <th>Validade</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $hoje = now()->format('Y-m-d');
                                $expirado = $voucher->valido_ate && $voucher->valido_ate < $hoje;
                                $disponiveis = $voucher->quantidade_total - $voucher->quantidade_usada;
                                $esgotado = $disponiveis <= 0;
                                
                                if ($esgotado) {
                                    $status_class = 'secondary';
                                    $status_text = 'Esgotado';
                                } elseif ($expirado) {
                                    $status_class = 'warning';
                                    $status_text = 'Expirado';
                                } else {
                                    $status_class = 'success';
                                    $status_text = 'Disponível';
                                }
                            ?>
                            <tr class="<?php echo e($esgotado || $expirado ? 'table-secondary' : ''); ?>">
                                <td>
                                    <strong class="text-primary" style="font-size: 1.1rem;">
                                        <?php echo e($voucher->codigo); ?>

                                    </strong>
                                </td>
                                <td>
                                    <span class="badge bg-success" style="font-size: 1rem;">
                                        <?php echo e(number_format($voucher->percentual_desconto, 0)); ?>%
                                    </span>
                                </td>
                                <td>
                                    <?php if($voucher->tipo === 'global'): ?>
                                        <span class="badge bg-warning text-dark">
                                            <i class="fas fa-globe me-1"></i>GLOBAL
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-info">
                                            <i class="fas fa-user me-1"></i>INDIVIDUAL
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong class="text-<?php echo e($disponiveis > 0 ? 'success' : 'danger'); ?>">
                                        <?php echo e($disponiveis); ?>

                                    </strong>
                                    <small class="text-muted">
                                        / <?php echo e($voucher->quantidade_total); ?>

                                    </small>
                                    <?php if($disponiveis <= 0): ?>
                                        <span class="badge bg-danger ms-2">Esgotado</span>
                                    <?php endif; ?>
                                    <?php if($voucher->tipo === 'global'): ?>
                                        <br><small class="text-info">
                                            <i class="fas fa-info-circle me-1"></i>Por especialista
                                        </small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($voucher->valido_ate): ?>
                                        <?php echo e(\Carbon\Carbon::parse($voucher->valido_ate)->format('d/m/Y')); ?>

                                        <?php if($expirado): ?>
                                            <span class="badge bg-warning">Expirado</span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="text-success">Sem prazo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($status_class); ?>">
                                        <?php echo e($status_text); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="alert alert-info mt-4">
    <h6><i class="fas fa-info-circle me-2"></i>Como funcionam os vouchers:</h6>
    <ul class="mb-0">
        <li><strong>Vouchers GLOBAIS:</strong> Criados pelo admin e disponíveis para todos os especialistas ativos</li>
        <li><strong>Vouchers INDIVIDUAIS:</strong> Criados pelo admin e atribuídos especificamente a você</li>
        <li><strong>Quantidade:</strong> Cada voucher tem um número limitado de usos disponíveis</li>
        <li><strong>Uso:</strong> Ao criar uma negociação no Kanban, selecione o voucher desejado para aplicar o desconto</li>
        <li><strong>Validade:</strong> Alguns vouchers podem ter prazo de expiração definido pelo admin</li>
    </ul>
</div>

<div class="alert alert-warning mt-4">
    <i class="fas fa-user-shield me-2"></i>
    <strong>Atenção:</strong> Para solicitar novos vouchers, entre em contato com o administrador do sistema.
</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.especialista', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/vouchers/index.blade.php ENDPATH**/ ?>