

<?php $__env->startSection('title', 'Gestão Avançada'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1 class="content-title mb-2">
                <i class="fas fa-tasks me-2" style="color: #667eea;"></i>Gestão Avançada de Leads
            </h1>
            <p class="content-subtitle mb-0">Busque, filtre e transfira leads entre especialistas e equipes</p>
        </div>
        <a href="<?php echo e(route('admin.leads.index')); ?>" class="btn btn-outline-primary">
            <i class="fas fa-list me-2"></i>Ver Todos os Leads
        </a>
    </div>
</div>

<!-- Alertas -->
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4 shadow-sm border-0">
        <div class="d-flex align-items-center">
            <div class="flex-shrink-0">
                <i class="fas fa-check-circle fs-4 me-3"></i>
            </div>
            <div class="flex-grow-1">
                <?php echo e(session('success')); ?>

            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show mb-4 shadow-sm border-0">
        <div class="d-flex align-items-center">
            <div class="flex-shrink-0">
                <i class="fas fa-exclamation-circle fs-4 me-3"></i>
            </div>
            <div class="flex-grow-1">
                <?php echo e(session('error')); ?>

            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    </div>
<?php endif; ?>

<!-- Estatísticas -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="stat-card-modern">
            <div class="d-flex align-items-center">
                <div class="stat-icon-modern" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <i class="fas fa-users"></i>
                </div>
                <div class="ms-3">
                    <div class="stat-value-modern"><?php echo e(number_format($stats->total_leads ?? 0)); ?></div>
                    <div class="stat-label-modern">Total de Leads</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card-modern">
            <div class="d-flex align-items-center">
                <div class="stat-icon-modern" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                    <i class="fas fa-user-tie"></i>
                </div>
                <div class="ms-3">
                    <div class="stat-value-modern"><?php echo e(number_format($stats->com_especialista ?? 0)); ?></div>
                    <div class="stat-label-modern">Com Especialista</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card-modern">
            <div class="d-flex align-items-center">
                <div class="stat-icon-modern" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <i class="fas fa-users-cog"></i>
                </div>
                <div class="ms-3">
                    <div class="stat-value-modern"><?php echo e(number_format($stats->com_equipe ?? 0)); ?></div>
                    <div class="stat-label-modern">Com Equipe</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card-modern">
            <div class="d-flex align-items-center">
                <div class="stat-icon-modern" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="ms-3">
                    <div class="stat-value-modern"><?php echo e(number_format($stats->aguardando ?? 0)); ?></div>
                    <div class="stat-label-modern">Aguardando</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Busca e Filtros -->
<div class="card mb-4 border-0 shadow-sm">
    <div class="card-body p-4">
        <!-- Busca Rápida -->
        <form method="GET" action="<?php echo e(route('admin.gestao.index')); ?>" class="mb-4">
            <div class="search-section">
                <label class="form-label fw-semibold mb-3">
                    <i class="fas fa-search me-2" style="color: #667eea;"></i>Busca Rápida
                </label>
                <div class="input-group input-group-lg shadow-sm">
                    <span class="input-group-text bg-white border-end-0">
                        <i class="fas fa-search text-muted"></i>
                    </span>
                    <input type="text" 
                           name="busca" 
                           class="form-control border-start-0 ps-0" 
                           placeholder="Digite o nome ou telefone do lead..." 
                           value="<?php echo e($busca); ?>"
                           style="font-size: 1rem;">
                    <button type="submit" class="btn btn-primary px-4">
                        Buscar
                    </button>
                </div>
                <small class="text-muted d-block mt-2">
                    <i class="fas fa-info-circle me-1"></i>Pesquise por nome ou telefone do lead
                </small>
            </div>
        </form>
        
        <div class="divider my-4">
            <span class="divider-text">OU</span>
        </div>
        
        <!-- Filtros por Especialista/Equipe -->
        <form method="GET" action="<?php echo e(route('admin.gestao.index')); ?>">
            <label class="form-label fw-semibold mb-3">
                <i class="fas fa-filter me-2" style="color: #667eea;"></i>Filtrar por Responsável
            </label>
            <div class="row g-3">
                <div class="col-md-4">
                    <select name="tipo" id="filtro-tipo" class="form-select form-select-lg shadow-sm" required>
                        <option value="">Selecione o tipo...</option>
                        <option value="especialista" <?php echo e($filtroTipo === 'especialista' ? 'selected' : ''); ?>>
                            <i class="fas fa-user-tie"></i> Especialista
                        </option>
                        <option value="equipe" <?php echo e($filtroTipo === 'equipe' ? 'selected' : ''); ?>>
                            <i class="fas fa-users"></i> Equipe
                        </option>
                    </select>
                </div>
                <div class="col-md-5">
                    <select name="id" id="filtro-id" class="form-select form-select-lg shadow-sm" required>
                        <option value="">Escolha o tipo primeiro...</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary btn-lg w-100 shadow-sm">
                        <i class="fas fa-filter me-2"></i>Filtrar
                    </button>
                </div>
            </div>
            <div class="mt-3 text-end">
                <a href="<?php echo e(route('admin.gestao.index')); ?>" class="btn btn-link text-muted">
                    <i class="fas fa-times me-1"></i>Limpar Filtros
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Leads -->
<?php if($leads->count() > 0): ?>
<div class="mb-3 d-flex justify-content-between align-items-center">
    <div>
        <h5 class="mb-1">
            <i class="fas fa-th-large me-2" style="color: #667eea;"></i>Resultados
            <?php if(!empty($filtroNome)): ?>
                <span class="badge bg-gradient-primary ms-2"><?php echo e($filtroNome); ?></span>
            <?php endif; ?>
        </h5>
        <small class="text-muted"><?php echo e($leads->count()); ?> lead(s) encontrado(s)</small>
    </div>
</div>

<!-- Grid de Cards de Leads -->
<div class="row g-4">
            <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $statusBadges = [
                        'aguardando' => ['class' => 'bg-warning text-dark', 'label' => 'Aguardando'],
                        'aguardando_coordenador' => ['class' => 'bg-info', 'label' => 'Aguardando Coordenador'],
                        'contatado' => ['class' => 'bg-primary', 'label' => 'Contatado'],
                        'em_negociacao' => ['class' => 'bg-purple', 'label' => 'Em Negociação'],
                        'negociacao' => ['class' => 'bg-purple', 'label' => 'Em Negociação'],
                        'aprovada' => ['class' => 'bg-success', 'label' => 'Aprovada'],
                        'rejeitada' => ['class' => 'bg-danger', 'label' => 'Perdida'],
                        'perdida' => ['class' => 'bg-danger', 'label' => 'Perdida'],
                    ];
                    $statusInfo = $statusBadges[$lead->status] ?? ['class' => 'bg-secondary', 'label' => ucfirst($lead->status)];
                ?>
                <div class="col-md-6 col-lg-4">
                    <div class="lead-card-modern">
                        <div class="lead-card-header">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="lead-id-badge">#<?php echo e(str_pad($lead->id, 4, '0', STR_PAD_LEFT)); ?></div>
                                <span class="badge <?php echo e($statusInfo['class']); ?> px-3 py-2"><?php echo e($statusInfo['label']); ?></span>
                            </div>
                        </div>
                        
                        <div class="lead-card-body">
                            <h5 class="lead-name mb-3">
                                <i class="fas fa-user-circle me-2" style="color: #667eea;"></i><?php echo e($lead->nome); ?>

                            </h5>
                            
                            <div class="lead-info-group">
                                <div class="lead-info-item">
                                    <i class="fas fa-envelope"></i>
                                    <span><?php echo e($lead->email); ?></span>
                                </div>
                                <div class="lead-info-item">
                                    <i class="fas fa-phone"></i>
                                    <span><?php echo e($lead->telefone); ?></span>
                                </div>
                                <div class="lead-info-item">
                                    <i class="fas fa-calendar"></i>
                                    <span><?php echo e(\Carbon\Carbon::parse($lead->data_cadastro)->format('d/m/Y')); ?></span>
                                </div>
                            </div>
                            
                            <?php if($lead->especialista): ?>
                            <div class="lead-assignment-tag especialista-tag">
                                <i class="fas fa-user-tie"></i>
                                <span><?php echo e($lead->especialista->nome); ?></span>
                            </div>
                            <?php elseif($lead->equipe): ?>
                            <div class="lead-assignment-tag equipe-tag">
                                <i class="fas fa-users"></i>
                                <span><?php echo e($lead->equipe->nome); ?></span>
                            </div>
                            <?php else: ?>
                            <div class="lead-assignment-tag nao-atribuido-tag">
                                <i class="fas fa-exclamation-triangle"></i>
                                <span>Não atribuído</span>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="lead-card-footer">
                            <button class="btn btn-transfer w-100" 
                                    onclick="transferirLead(<?php echo e($lead->id); ?>, '<?php echo e(addslashes($lead->nome)); ?>')">
                                <i class="fas fa-exchange-alt me-2"></i>Transferir Lead
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
<?php elseif($busca || ($filtroTipo && $filtroId)): ?>
<div class="empty-state">
    <div class="empty-state-icon">
        <i class="fas fa-search"></i>
    </div>
    <h4 class="empty-state-title">Nenhum lead encontrado</h4>
    <p class="empty-state-text">Não foram encontrados leads com os filtros aplicados.</p>
    <a href="<?php echo e(route('admin.gestao.index')); ?>" class="btn btn-outline-primary mt-3">
        <i class="fas fa-redo me-2"></i>Limpar Filtros
    </a>
</div>
<?php else: ?>
<div class="empty-state">
    <div class="empty-state-icon">
        <i class="fas fa-filter"></i>
    </div>
    <h4 class="empty-state-title">Use os filtros acima</h4>
    <p class="empty-state-text">Busque por nome/telefone ou filtre por especialista/equipe para visualizar os leads.</p>
</div>
<?php endif; ?>

<!-- Modal Transferir -->
<div class="modal fade" id="modalTransferir" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('admin.gestao.transferir')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Transferir Lead</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="lead_id" id="transfer-lead-id">
                    <p>Lead: <strong id="transfer-lead-nome"></strong></p>
                    <div class="mb-3">
                        <label class="form-label">Transferir para</label>
                        <select name="tipo_destino" id="transfer-tipo" class="form-select" required>
                            <option value="">Selecione...</option>
                            <option value="especialista">Especialista</option>
                            <option value="equipe">Equipe</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Destino</label>
                        <select name="destino_id" id="transfer-destino" class="form-select" required>
                            <option value="">Escolha o tipo primeiro...</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-exchange-alt me-2"></i>Transferir
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
const especialistas = <?php echo json_encode($especialistas, 15, 512) ?>;
const equipes = <?php echo json_encode($equipes, 15, 512) ?>;

// Atualizar dropdown de seleção baseado no tipo
document.getElementById('filtro-tipo').addEventListener('change', function() {
    const select = document.getElementById('filtro-id');
    select.innerHTML = '<option value="">Selecione...</option>';
    const lista = this.value === 'especialista' ? especialistas : equipes;
    lista.forEach(item => {
        select.innerHTML += `<option value="${item.id}">${item.nome}</option>`;
    });
});

// Atualizar dropdown de transferência
document.getElementById('transfer-tipo').addEventListener('change', function() {
    const select = document.getElementById('transfer-destino');
    select.innerHTML = '<option value="">Selecione...</option>';
    const lista = this.value === 'especialista' ? especialistas : equipes;
    lista.forEach(item => {
        select.innerHTML += `<option value="${item.id}">${item.nome}</option>`;
    });
});

// Inicializar na carga se já tiver valor
if (document.getElementById('filtro-tipo').value) {
    document.getElementById('filtro-tipo').dispatchEvent(new Event('change'));
    document.getElementById('filtro-id').value = '<?php echo e($filtroId); ?>';
}

function transferirLead(id, nome) {
    document.getElementById('transfer-lead-id').value = id;
    document.getElementById('transfer-lead-nome').textContent = nome;
    new bootstrap.Modal(document.getElementById('modalTransferir')).show();
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Cards de Estatísticas Modernos */
.stat-card-modern {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    transition: all 0.3s ease;
    border: 1px solid #f1f5f9;
}

.stat-card-modern:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
}

.stat-icon-modern {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    flex-shrink: 0;
}

.stat-value-modern {
    font-size: 2rem;
    font-weight: 700;
    color: #1e293b;
    line-height: 1;
    margin-bottom: 0.25rem;
}

.stat-label-modern {
    font-size: 0.875rem;
    color: #64748b;
    font-weight: 500;
}

/* Divider */
.divider {
    display: flex;
    align-items: center;
    text-align: center;
    color: #94a3b8;
    font-size: 0.875rem;
    font-weight: 600;
}

.divider::before,
.divider::after {
    content: '';
    flex: 1;
    border-bottom: 2px solid #e2e8f0;
}

.divider-text {
    padding: 0 1rem;
    background: white;
}

/* Search Section */
.search-section .input-group {
    border-radius: 12px;
    overflow: hidden;
    border: 2px solid #e2e8f0;
    transition: border-color 0.2s;
}

.search-section .input-group:focus-within {
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.search-section .input-group-text {
    border: none;
}

.search-section .form-control {
    border: none;
}

.search-section .form-control:focus {
    box-shadow: none;
}

/* Lead Cards Modernos */
.lead-card-modern {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    transition: all 0.3s ease;
    border: 1px solid #f1f5f9;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.lead-card-modern:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 32px rgba(0, 0, 0, 0.1);
    border-color: #667eea;
}

.lead-card-header {
    padding: 1.25rem;
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-bottom: 1px solid #e2e8f0;
}

.lead-id-badge {
    font-size: 0.75rem;
    font-weight: 700;
    color: #667eea;
    background: white;
    padding: 0.375rem 0.75rem;
    border-radius: 8px;
    border: 1px solid #e0e7ff;
}

.lead-card-body {
    padding: 1.25rem;
    flex: 1;
}

.lead-name {
    font-size: 1.125rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 1rem;
}

.lead-info-group {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.lead-info-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    font-size: 0.875rem;
    color: #64748b;
}

.lead-info-item i {
    width: 18px;
    text-align: center;
    color: #94a3b8;
}

.lead-assignment-tag {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    border-radius: 10px;
    font-size: 0.8125rem;
    font-weight: 600;
    margin-top: 0.75rem;
}

.especialista-tag {
    background: linear-gradient(135deg, #e0f2fe 0%, #dbeafe 100%);
    color: #0369a1;
    border: 1px solid #bae6fd;
}

.equipe-tag {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    color: #92400e;
    border: 1px solid #fde047;
}

.nao-atribuido-tag {
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    color: #991b1b;
    border: 1px solid #fca5a5;
}

.lead-card-footer {
    padding: 1rem 1.25rem;
    background: #fafbfc;
    border-top: 1px solid #e2e8f0;
}

.btn-transfer {
    background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
    border: none;
    color: white;
    font-weight: 600;
    padding: 0.625rem 1.25rem;
    border-radius: 10px;
    transition: all 0.2s;
}

.btn-transfer:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(245, 158, 11, 0.3);
    color: white;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 4rem 2rem;
    background: white;
    border-radius: 16px;
    border: 2px dashed #e2e8f0;
}

.empty-state-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 1.5rem;
    background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    color: #94a3b8;
}

.empty-state-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 0.5rem;
}

.empty-state-text {
    color: #64748b;
    font-size: 1rem;
    margin-bottom: 0;
}

/* Badge Gradiente */
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none !important;
}

.bg-purple {
    background: linear-gradient(135deg, #9c27b0, #8e24aa) !important;
    color: white !important;
}

/* Melhorias nos Selects */
.form-select-lg {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    transition: all 0.2s;
}

.form-select-lg:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

/* Botões */
.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    font-weight: 600;
    transition: all 0.2s;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
}

.btn-outline-primary:hover {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-color: transparent;
}
</style>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/gestao/index.blade.php ENDPATH**/ ?>