

<?php $__env->startSection('title', 'Alunos'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Acompanhamento de Alunos</h1>
    <p class="content-subtitle">Monitore o progresso dos alunos da sua equipe</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid mb-4">
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($statsAlunos->total_alunos ?? 0); ?></div>
        <div class="stat-label">Total de Alunos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($statsAlunos->alunos_ativos ?? 0); ?></div>
        <div class="stat-label">Alunos Ativos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-graduation-cap"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e($statsAlunos->alunos_concluidos ?? 0); ?></div>
        <div class="stat-label">Alunos Concluídos</div>
    </div>
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($statsAlunos->progresso_medio ?? 0, 1)); ?>%</div>
        <div class="stat-label">Progresso Médio</div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('coordenador.alunos.index')); ?>" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">Todos os status</option>
                    <option value="ativo" <?php echo e($status == 'ativo' ? 'selected' : ''); ?>>Ativo</option>
                    <option value="concluido" <?php echo e($status == 'concluido' ? 'selected' : ''); ?>>Concluído</option>
                    <option value="trancado" <?php echo e($status == 'trancado' ? 'selected' : ''); ?>>Trancado</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Especialista</label>
                <select name="especialista_id" class="form-select">
                    <option value="">Todos os especialistas</option>
                    <?php $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($esp->id); ?>" <?php echo e($especialistaId == $esp->id ? 'selected' : ''); ?>>
                            <?php echo e($esp->nome); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Módulo</label>
                <select name="modulo" class="form-select">
                    <option value="">Todos os módulos</option>
                    <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($mod); ?>" <?php echo e($modulo == $mod ? 'selected' : ''); ?>><?php echo e($mod); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Buscar</label>
                <input type="text" name="search" class="form-control" value="<?php echo e($search); ?>" placeholder="Nome, email ou telefone...">
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter me-2"></i>Filtrar
                </button>
                <a href="<?php echo e(route('coordenador.alunos.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Gráficos -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Distribuição por Status</h5>
            </div>
            <div class="card-body">
                <canvas id="statusChart" height="200"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Distribuição por Módulo</h5>
            </div>
            <div class="card-body">
                <canvas id="moduloChart" height="200"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Lista de Alunos -->
<div class="card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Alunos da Equipe</h5>
        <button type="button" class="btn btn-primary" onclick="exportarAlunos()">
            <i class="fas fa-download me-2"></i>Exportar
        </button>
    </div>
    <div class="card-body">
        <?php if($alunos->isNotEmpty()): ?>
            <div class="table-container">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Aluno</th>
                            <th>Especialista</th>
                            <th>Status</th>
                            <th>Módulo Atual</th>
                            <th>Progresso</th>
                            <th>Data Cadastro</th>
                            <th>Nível</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($aluno->nome); ?></strong><br>
                                    <small class="text-muted"><?php echo e($aluno->email); ?></small>
                                    <?php if($aluno->telefone): ?>
                                        <br><small class="text-muted"><?php echo e($aluno->telefone); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge badge-info"><?php echo e($aluno->especialista_nome); ?></span><br>
                                    <small class="text-muted"><?php echo e($aluno->especialista_email); ?></small>
                                </td>
                                <td>
                                    <?php
                                        $status_cores = [
                                            'ativo' => 'badge-success',
                                            'inativo' => 'badge-secondary',
                                            'trancado' => 'badge-warning',
                                            'cancelado' => 'badge-danger'
                                        ];
                                        $status_formatado = [
                                            'ativo' => 'Em andamento',
                                            'inativo' => 'Inativo',
                                            'trancado' => 'Trancado',
                                            'cancelado' => 'Cancelado'
                                        ];
                                        $status_display = $aluno->status;
                                        if ($aluno->data_conclusao) {
                                            $status_display = 'concluido';
                                            $status_cores['concluido'] = 'badge-info';
                                            $status_formatado['concluido'] = 'Concluído';
                                        }
                                    ?>
                                    <span class="badge <?php echo e($status_cores[$status_display] ?? 'badge-secondary'); ?>">
                                        <?php echo e($status_formatado[$status_display] ?? $aluno->status); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($aluno->modulo_atual): ?>
                                        <span class="badge badge-primary"><?php echo e($aluno->modulo_atual); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Não definido</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="progress" style="height: 20px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($aluno->progresso_geral ?? 0); ?>%">
                                            <?php echo e(number_format($aluno->progresso_geral ?? 0, 1)); ?>%
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo e(\Carbon\Carbon::parse($aluno->data_cadastro)->format('d/m/Y')); ?></td>
                                <td>
                                    <?php
                                        $progresso = $aluno->progresso_geral ?? 0;
                                        $nivel = 'Novo';
                                        $nivel_cor = 'badge-secondary';
                                        if ($progresso >= 80) {
                                            $nivel = 'Avançado';
                                            $nivel_cor = 'badge-success';
                                        } elseif ($progresso >= 50) {
                                            $nivel = 'Intermediário';
                                            $nivel_cor = 'badge-info';
                                        } elseif ($progresso >= 20) {
                                            $nivel = 'Iniciante';
                                            $nivel_cor = 'badge-warning';
                                        }
                                    ?>
                                    <span class="badge <?php echo e($nivel_cor); ?>"><?php echo e($nivel); ?></span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Nenhum aluno encontrado</h5>
                <p class="text-muted">
                    <?php if($status || $especialistaId || $modulo || $search): ?>
                        Não há alunos que correspondam aos filtros aplicados.
                    <?php else: ?>
                        Não há alunos registrados para a equipe.
                    <?php endif; ?>
                </p>
                <?php if($status || $especialistaId || $modulo || $search): ?>
                    <a href="<?php echo e(route('coordenador.alunos.index')); ?>" class="btn btn-primary">
                        <i class="fas fa-times me-2"></i>Limpar Filtros
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Gráfico de distribuição por status
const statusData = <?php echo json_encode($distribuicaoStatus, 15, 512) ?>;
const statusLabels = statusData.map(item => {
    const labels = {
        'ativo': 'Ativo',
        'inativo': 'Inativo',
        'trancado': 'Trancado',
        'cancelado': 'Cancelado'
    };
    return labels[item.status] || item.status;
});
const statusValues = statusData.map(item => item.total);
const statusColors = ['#22c55e', '#3b82f6', '#f59e0b'];

const ctxStatus = document.getElementById('statusChart').getContext('2d');
new Chart(ctxStatus, {
    type: 'doughnut',
    data: {
        labels: statusLabels,
        datasets: [{
            data: statusValues,
            backgroundColor: statusColors,
            borderWidth: 2,
            borderColor: '#ffffff'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

// Gráfico de distribuição por módulo
const moduloData = <?php echo json_encode($distribuicaoModulo, 15, 512) ?>;
const moduloLabels = moduloData.map(item => item.modulo);
const moduloValues = moduloData.map(item => item.total);
const moduloColors = [
    '#3b82f6', '#22c55e', '#f59e0b', '#ef4444', '#8b5cf6',
    '#06b6d4', '#84cc16', '#f97316', '#ec4899', '#6366f1'
];

const ctxModulo = document.getElementById('moduloChart').getContext('2d');
new Chart(ctxModulo, {
    type: 'bar',
    data: {
        labels: moduloLabels,
        datasets: [{
            label: 'Alunos',
            data: moduloValues,
            backgroundColor: moduloColors,
            borderColor: moduloColors,
            borderWidth: 1
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});

function exportarAlunos() {
    const dados = <?php echo json_encode($alunos, 15, 512) ?>;
    const headers = ['Nome', 'Email', 'Telefone', 'Especialista', 'Status', 'Módulo Atual', 'Progresso', 'Data Cadastro', 'Nível'];
    
    const csvContent = [
        headers.join(','),
        ...dados.map(row => [
            row.nome,
            row.email,
            row.telefone || '',
            row.especialista_nome,
            row.status,
            row.modulo_atual || 'Não definido',
            (row.progresso_geral || 0) + '%',
            row.data_cadastro,
            row.progresso_geral >= 80 ? 'Avançado' : (row.progresso_geral >= 50 ? 'Intermediário' : (row.progresso_geral >= 20 ? 'Iniciante' : 'Novo'))
        ].join(','))
    ].join('\n');
    
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = `alunos_equipe_${new Date().toISOString().split('T')[0]}.csv`;
    link.click();
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.coordenador', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/coordenador/alunos/index.blade.php ENDPATH**/ ?>