

<?php $__env->startSection('title', 'Horários de Funcionamento'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Horários de Funcionamento</h1>
    <p class="content-subtitle">Configure os horários de atendimento</p>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <!-- Horários Semanais -->
    <div class="col-md-8 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Horários da Semana</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.horarios.update')); ?>">
                    <?php echo csrf_field(); ?>
                    
                    <?php
                        $diasSemana = [
                            0 => 'Domingo',
                            1 => 'Segunda-feira',
                            2 => 'Terça-feira',
                            3 => 'Quarta-feira',
                            4 => 'Quinta-feira',
                            5 => 'Sexta-feira',
                            6 => 'Sábado',
                        ];
                        $horariosIndexados = $horarios->keyBy('dia_semana');
                    ?>

                    <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $horario = $horariosIndexados->get($num);
                        ?>
                        <div class="row mb-3 align-items-center">
                            <div class="col-md-3">
                                <strong><?php echo e($dia); ?></strong>
                                <input type="hidden" name="horarios[<?php echo e($num); ?>][dia_semana]" value="<?php echo e($num); ?>">
                            </div>
                            <div class="col-md-3">
                                <input type="time" class="form-control" name="horarios[<?php echo e($num); ?>][hora_inicio]" 
                                       value="<?php echo e($horario->hora_inicio ?? '08:00'); ?>" required>
                            </div>
                            <div class="col-md-3">
                                <input type="time" class="form-control" name="horarios[<?php echo e($num); ?>][hora_fim]" 
                                       value="<?php echo e($horario->hora_fim ?? '18:00'); ?>" required>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="horarios[<?php echo e($num); ?>][ativo]">
                                    <option value="1" <?php echo e(($horario->ativo ?? 1) ? 'selected' : ''); ?>>Ativo</option>
                                    <option value="0" <?php echo e(!($horario->ativo ?? 1) ? 'selected' : ''); ?>>Fechado</option>
                                </select>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save me-2"></i>Salvar Horários
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Exceções -->
    <div class="col-md-4 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Exceções (Feriados)</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.horarios.excecao')); ?>" class="mb-4">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="form-label">Data</label>
                        <input type="date" class="form-control" name="data" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Motivo</label>
                        <input type="text" class="form-control" name="motivo" placeholder="Ex: Feriado Nacional" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tipo</label>
                        <select class="form-select" name="fechado">
                            <option value="1">Fechado</option>
                            <option value="0">Horário Especial</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success w-100">
                        <i class="fas fa-plus me-2"></i>Adicionar Exceção
                    </button>
                </form>

                <hr>

                <div class="list-group">
                    <?php $__empty_1 = true; $__currentLoopData = $excecoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $excecao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <strong><?php echo e(\Carbon\Carbon::parse($excecao->data)->format('d/m/Y')); ?></strong>
                                <small class="d-block text-muted"><?php echo e($excecao->motivo); ?></small>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="excluirExcecao(<?php echo e($excecao->id); ?>)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted text-center">Nenhuma exceção cadastrada</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function excluirExcecao(id) {
    if (!confirm('Deseja excluir esta exceção?')) return;

    fetch(`/equipe/public/admin/horarios/excecao/${id}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/horarios/index.blade.php ENDPATH**/ ?>