

<?php $__env->startSection('title', 'Novo Voucher'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.vouchers.index')); ?>">Vouchers</a></li>
            <li class="breadcrumb-item active">Novo</li>
        </ol>
    </nav>
    <h1 class="content-title">Novo Voucher</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="<?php echo e(route('admin.vouchers.store')); ?>">
            <?php echo csrf_field(); ?>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="codigo" class="form-label">Código *</label>
                    <input type="text" class="form-control <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="codigo" name="codigo" value="<?php echo e(old('codigo')); ?>" required>
                    <?php $__errorArgs = ['codigo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="text-muted">Será convertido para maiúsculas</small>
                </div>
                <div class="col-md-4">
                    <label for="nome" class="form-label">Nome do Voucher</label>
                    <input type="text" class="form-control" id="nome" name="nome" value="<?php echo e(old('nome')); ?>">
                    <small class="text-muted">Nome descritivo (opcional)</small>
                </div>
                <div class="col-md-4">
                    <label for="tipo" class="form-label">Tipo de Desconto *</label>
                    <select class="form-select <?php $__errorArgs = ['tipo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="tipo" name="tipo" required onchange="toggleTipo()">
                        <option value="">Selecione...</option>
                        <option value="desconto" <?php echo e(old('tipo') === 'desconto' ? 'selected' : ''); ?>>Desconto</option>
                        <option value="brinde" <?php echo e(old('tipo') === 'brinde' ? 'selected' : ''); ?>>Brinde</option>
                    </select>
                    <?php $__errorArgs = ['tipo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="abrangencia" class="form-label">Abrangência *</label>
                    <select class="form-select" id="abrangencia" name="abrangencia" required onchange="toggleAbrangencia()">
                        <option value="global" <?php echo e(old('abrangencia') === 'global' ? 'selected' : ''); ?>>Global (Todos os Especialistas)</option>
                        <option value="individual" <?php echo e(old('abrangencia') === 'individual' ? 'selected' : ''); ?>>Individual (Especialistas Específicos)</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="tipo_quantidade" class="form-label">Tipo de Quantidade *</label>
                    <select class="form-select" id="tipo_quantidade" name="tipo_quantidade" required>
                        <option value="coletiva" <?php echo e(old('tipo_quantidade') === 'coletiva' ? 'selected' : ''); ?>>Coletiva (Total geral)</option>
                        <option value="individual" <?php echo e(old('tipo_quantidade') === 'individual' ? 'selected' : ''); ?>>Individual (Por especialista)</option>
                    </select>
                    <small class="text-muted">Coletiva: limite total | Individual: limite por pessoa</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <label for="percentual_desconto" class="form-label">Percentual de Desconto (%)</label>
                    <input type="number" class="form-control" id="percentual_desconto" name="percentual_desconto" 
                           value="<?php echo e(old('percentual_desconto')); ?>" min="0" max="100" step="0.01">
                </div>
                <div class="col-md-4">
                    <label for="valor_desconto" class="form-label">Valor do Desconto (R$)</label>
                    <input type="number" class="form-control" id="valor_desconto" name="valor_desconto" 
                           value="<?php echo e(old('valor_desconto')); ?>" min="0" step="0.01">
                </div>
                <div class="col-md-4">
                    <label for="quantidade_total" class="form-label">Quantidade Total *</label>
                    <input type="number" class="form-control" id="quantidade_total" name="quantidade_total" 
                           value="<?php echo e(old('quantidade_total', 1)); ?>" min="1" required>
                    <small class="text-muted">Qtd de usos permitidos</small>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="validade" class="form-label">Data de Validade</label>
                    <input type="date" class="form-control" id="validade" name="validade" value="<?php echo e(old('validade')); ?>">
                    <small class="text-muted">Deixe em branco para sem limite</small>
                </div>
                <div class="col-md-6">
                    <label for="valor_minimo" class="form-label">Valor Mínimo de Compra (R$)</label>
                    <input type="number" class="form-control" id="valor_minimo" name="valor_minimo" 
                           value="<?php echo e(old('valor_minimo')); ?>" min="0" step="0.01">
                    <small class="text-muted">Opcional</small>
                </div>
            </div>

            <div class="mb-3">
                <label for="descricao" class="form-label">Descrição</label>
                <textarea class="form-control" id="descricao" name="descricao" rows="3"><?php echo e(old('descricao')); ?></textarea>
                <small class="text-muted">Descrição interna do voucher (opcional)</small>
            </div>

            <div class="mb-3" id="campo_especialistas" style="display: none;">
                <label class="form-label">Especialistas Autorizados *</label>
                <div class="border rounded p-3" style="max-height: 300px; overflow-y: auto;">
                    <?php $__empty_1 = true; $__currentLoopData = $especialistas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $esp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="especialistas[]" 
                                   value="<?php echo e($esp->id); ?>" id="esp<?php echo e($esp->id); ?>">
                            <label class="form-check-label" for="esp<?php echo e($esp->id); ?>">
                                <?php echo e($esp->nome); ?>

                            </label>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-muted">Nenhum especialista disponível</p>
                    <?php endif; ?>
                </div>
                <small class="text-muted">Selecione os especialistas que podem usar este voucher</small>
            </div>

            <hr class="my-4">

            <div class="alert alert-info">
                <strong>📋 Resumo:</strong>
                <ul class="mb-0 mt-2">
                    <li><strong>Global:</strong> Todos os especialistas podem usar</li>
                    <li><strong>Individual:</strong> Apenas especialistas selecionados</li>
                    <li><strong>Quantidade Coletiva:</strong> Limite total de usos (ex: 100 usos no total)</li>
                    <li><strong>Quantidade Individual:</strong> Limite por especialista (ex: cada um pode usar 5 vezes)</li>
                </ul>
            </div>

            <div class="text-end">
                <a href="<?php echo e(route('admin.vouchers.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times me-2"></i>Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i>Salvar Voucher
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleAbrangencia() {
    const abrangencia = document.getElementById('abrangencia').value;
    document.getElementById('campo_especialistas').style.display = abrangencia === 'individual' ? 'block' : 'none';
}

// Executar ao carregar
document.addEventListener('DOMContentLoaded', function() {
    toggleAbrangencia();
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/vouchers/create.blade.php ENDPATH**/ ?>