

<?php $__env->startSection('title', 'Kanban de Atendimentos'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <h1 class="content-title">Atendimentos - Meus Leads</h1>
    <p class="content-subtitle">Gerencie seus leads e negociações através do Kanban</p>
</div>

<!-- Estatísticas -->
<div class="stats-grid">
    <!-- Total de Leads -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-users"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats->total ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Total de Leads</div>
    </div>

    <!-- Aguardando -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #fef3c7; color: #f59e0b;">
                <i class="fas fa-clock"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats->aguardando ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Aguardando</div>
    </div>

    <!-- Em Negociação -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dbeafe; color: #3b82f6;">
                <i class="fas fa-handshake"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats->negociacao ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Em Negociação</div>
    </div>

    <!-- Aprovados -->
    <div class="stat-card">
        <div class="stat-header">
            <div class="stat-icon" style="background: #dcfce7; color: #22c55e;">
                <i class="fas fa-check-circle"></i>
            </div>
        </div>
        <div class="stat-value"><?php echo e(number_format($stats->aprovada ?? 0, 0, ',', '.')); ?></div>
        <div class="stat-label">Aprovados</div>
    </div>
</div>

<!-- Kanban Board -->
<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">
            <i class="fas fa-columns me-2"></i>
            Kanban Board - Gestão de Atendimentos
        </h5>
    </div>
    <div class="card-body">
        <div class="kanban-container">
            <div class="kanban-board" id="kanban-board">
                <!-- Colunas serão geradas via JavaScript -->
            </div>
        </div>
    </div>
</div>

<!-- Modal para Detalhes do Lead -->
<div class="details-modal" id="detailsModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title">
                <i class="fas fa-info-circle me-2"></i>Detalhes do Lead
            </h3>
            <button class="modal-close" onclick="closeDetailsModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="modal-body" id="detailsContent">
            <!-- Conteúdo será inserido via JavaScript -->
        </div>
    </div>
</div>

<!-- Modal para Nova Negociação -->
<div class="details-modal" id="negociacaoModal">
    <div class="modal-content" style="max-width: 800px;">
        <div class="modal-header">
            <h3 class="modal-title">
                <i class="fas fa-handshake me-2"></i>Nova Negociação para Lead
            </h3>
            <button class="modal-close" onclick="closeNegociacaoModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <div id="negociacaoModalContent">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Carregando...</span>
                    </div>
                    <p class="mt-2 text-muted">Carregando dados do lead...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Link de Pagamento -->
<div class="details-modal" id="linkPagamentoModal">
    <div class="modal-content" style="max-width: 700px;">
        <div class="modal-header bg-success text-white">
            <h3 class="modal-title">
                <i class="fas fa-check-circle me-2"></i>Negociação Criada com Sucesso!
            </h3>
            <button class="modal-close" onclick="closeLinkPagamentoModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="modal-body">
            <div class="alert alert-success">
                <i class="fas fa-thumbs-up me-2"></i>
                <strong>Vínculo criado!</strong> O aluno foi vinculado ao lead e a negociação está registrada no sistema.
            </div>
            
            <div id="linkPagamentoContent">
                <!-- Conteúdo será inserido via JavaScript -->
            </div>
            
            <div class="text-center mt-4">
                <p class="text-muted">Próximos passos:</p>
                <ol class="text-start">
                    <li>Copie o link de pagamento acima</li>
                    <li>Envie para o cliente via WhatsApp ou Email</li>
                    <li>Aguarde a confirmação do pagamento</li>
                    <li>Quando o pagamento for confirmado, o lead irá automaticamente para "Aprovada"</li>
                </ol>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary" onclick="copiarLinkPagamento()">
                <i class="fas fa-copy me-2"></i>Copiar Link
            </button>
            <button type="button" class="btn btn-success" onclick="enviarViaWhatsApp()">
                <i class="fab fa-whatsapp me-2"></i>Enviar via WhatsApp
            </button>
            <button type="button" class="btn btn-secondary" onclick="closeLinkPagamentoModal()">
                Fechar
            </button>
        </div>
    </div>
</div>

<!-- Modal para Motivo da Perda -->
<div class="details-modal" id="motivoPerdaModal">
    <div class="modal-content" style="max-width: 500px;">
        <div class="modal-header">
            <h3 class="modal-title">
                <i class="fas fa-exclamation-triangle me-2"></i>Motivo da Perda
            </h3>
            <button class="modal-close" onclick="closeMotivoPerdaModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="modal-body">
            <p class="mb-3">Por favor, informe o motivo pelo qual este lead foi perdido:</p>
            <form id="motivoPerdaForm">
                <div class="mb-3">
                    <label for="motivoPerda" class="form-label">Motivo *</label>
                    <textarea 
                        class="form-control" 
                        id="motivoPerda" 
                        name="motivo" 
                        rows="4" 
                        placeholder="Descreva o motivo da perda deste lead..."
                        required></textarea>
                    <small class="text-muted">Este motivo será salvo nas observações do lead.</small>
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <button type="button" class="btn btn-secondary" onclick="closeMotivoPerdaModal(true)">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-save me-2"></i>Salvar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Estilos específicos para o Kanban do Especialista - Cores Azuis */
.kanban-container {
    width: 100%;
    overflow-x: auto;
    padding: 20px 0;
}

.kanban-board {
    display: flex;
    gap: 20px;
    min-width: fit-content;
}

.kanban-column {
    flex: 0 0 300px;
    background: #f8f9fa;
    border-radius: 12px;
    padding: 16px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    display: flex;
    flex-direction: column;
    min-height: 500px;
}

.kanban-column.drag-over {
    background: rgba(59, 130, 246, 0.05);
    border: 2px dashed #3b82f6;
}

.kanban-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 16px;
    padding-bottom: 12px;
    border-bottom: 2px solid rgba(0,0,0,0.1);
}

.kanban-title {
    display: flex;
    align-items: center;
    gap: 8px;
    font-weight: 600;
    font-size: 14px;
    color: #333;
}

.kanban-title i {
    font-size: 18px;
}

.kanban-count {
    background: white;
    padding: 4px 12px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 14px;
}

.kanban-cards {
    display: flex;
    flex-direction: column;
    gap: 12px;
    min-height: 400px;
    flex: 1;
}

.kanban-card {
    background: white;
    border-radius: 8px;
    padding: 16px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    cursor: move;
    transition: all 0.2s;
    position: relative;
}

.kanban-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.kanban-card.lead-distribuido {
    border-left: 4px solid #3b82f6;
}

.kanban-card[draggable="true"] {
    cursor: move;
}

.kanban-card.dragging {
    opacity: 0.5;
    transform: rotate(3deg) scale(0.95);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
}

.kanban-column.drag-over .kanban-cards {
    background: rgba(59, 130, 246, 0.15);
    border-radius: 8px;
}

.kanban-card[draggable="true"]::before {
    content: '\f0c9';
    font-family: 'Font Awesome 6 Free';
    font-weight: 900;
    position: absolute;
    left: 8px;
    top: 50%;
    transform: translateY(-50%);
    color: #ddd;
    font-size: 12px;
    opacity: 0;
    transition: opacity 0.2s;
}

.kanban-card[draggable="true"]:hover::before {
    opacity: 1;
}

.negociacao-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.negociacao-id {
    font-size: 12px;
    color: #666;
    font-weight: 600;
}

.negociacao-title {
    font-size: 16px;
    font-weight: 600;
    margin: 8px 0;
    color: #333;
}

.negociacao-meta {
    display: flex;
    flex-direction: column;
    gap: 6px;
    margin-top: 12px;
}

.meta-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 13px;
    color: #666;
}

.meta-item i {
    font-size: 14px;
    width: 16px;
}

.whatsapp-link {
    color: #25D366;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 6px;
    transition: color 0.2s;
}

.whatsapp-link:hover {
    color: #128C7E;
}

.view-details-btn {
    position: absolute;
    top: 12px;
    right: 12px;
    background: white;
    border: 1px solid #ddd;
    border-radius: 6px;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.2s;
    z-index: 10;
}

.view-details-btn:hover {
    background: #f0f0f0;
    border-color: #999;
}

.kanban-empty {
    text-align: center;
    padding: 40px 20px;
    color: #999;
}

.kanban-empty i {
    font-size: 48px;
    margin-bottom: 12px;
    opacity: 0.3;
}

.details-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    z-index: 9999;
    overflow-y: auto;
}

.details-modal.show {
    display: flex;
    align-items: center;
    justify-content: center;
}

.details-modal .modal-content {
    background: white;
    border-radius: 12px;
    width: 90%;
    max-width: 600px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
}

.details-modal .modal-header {
    padding: 20px;
    border-bottom: 1px solid #dee2e6;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.details-modal .modal-title {
    font-size: 20px;
    font-weight: 600;
    margin: 0;
}

.details-modal .modal-close {
    background: none;
    border: none;
    font-size: 24px;
    cursor: pointer;
    color: #666;
    padding: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 4px;
    transition: all 0.2s;
}

.details-modal .modal-close:hover {
    background: #f0f0f0;
    color: #333;
}

.details-modal .modal-body {
    padding: 20px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Dados dos leads vindos do Laravel
const LEADS_DATA = <?php echo json_encode($leadsDb); ?>;

// Configuração das colunas do kanban - Cores Azuis
const kanbanConfig = {
    'aguardando': {
        label: 'Aguardando Contato',
        icon: 'fas fa-clock',
        color: 'linear-gradient(90deg, #ff9800, #ffc107)'
    },
    'contatado': {
        label: 'Contatado',
        icon: 'fas fa-phone',
        color: 'linear-gradient(90deg, #3b82f6, #2563eb)'
    },
    'negociacao': {
        label: 'Em Negociação',
        icon: 'fas fa-handshake',
        color: 'linear-gradient(90deg, #3b82f6, #1d4ed8)'
    },
    'aprovada': {
        label: 'Aprovada',
        icon: 'fas fa-check-circle',
        color: 'linear-gradient(90deg, #22c55e, #16a34a)'
    },
    'rejeitada': {
        label: 'Perdida',
        icon: 'fas fa-times-circle',
        color: 'linear-gradient(90deg, #f44336, #e53935)'
    }
};

// Organizar leads por status
function organizeLeadsByStatus() {
    const organized = {
        'aguardando': [],
        'contatado': [],
        'negociacao': [],
        'aprovada': [],
        'rejeitada': []
    };
    
    LEADS_DATA.forEach(lead => {
        let targetStatus = lead.status_kanban || 'aguardando';
        
        if (!lead.status_kanban && lead.etapa) {
            const etapaMap = {
                'novo': 'aguardando',
                'contato': 'contatado',
                'demo': 'negociacao',
                'fechamento': 'aprovada',
                'perdido': 'rejeitada'
            };
            targetStatus = etapaMap[lead.etapa] || 'aguardando';
        }
        
        if (!organized[targetStatus]) {
            targetStatus = 'aguardando';
        }
        
        organized[targetStatus].push(lead);
    });
    
    return organized;
}

// Estado para drag and drop
let draggedCard = null;

// Criar card de lead
function createLeadCard(lead) {
    // Validar e converter lead.id
    const leadId = parseInt(lead.id);
    if (!leadId || isNaN(leadId)) {
        return null;
    }
    
    const card = document.createElement('div');
    card.className = 'kanban-card';
    card.dataset.id = `lead-${leadId}`;
    card.dataset.leadId = leadId; // Garantir que seja número
    card.dataset.tipo = lead.tipo || 'lead';
    
    // Determinar status do kanban
    let statusKanban = lead.status_kanban || 'aguardando';
    if (!lead.status_kanban && lead.etapa) {
        const etapaMap = {
            'novo': 'aguardando',
            'contato': 'contatado',
            'demo': 'negociacao',
            'fechamento': 'aprovada',
            'perdido': 'rejeitada'
        };
        statusKanban = etapaMap[lead.etapa] || 'aguardando';
    }
    
    card.dataset.status = statusKanban;
    
    // Especialista pode arrastar TODOS os cards
    card.draggable = true;
    card.addEventListener('dragstart', handleDragStart);
    card.addEventListener('dragend', handleDragEnd);
    
    // Adicionar classe se está distribuído
    if (lead.distribuido_para_mim) {
        card.classList.add('lead-distribuido');
    }
    
    // Formatar telefone para WhatsApp
    let whatsappLink = '#';
    let telefoneDisplay = lead.telefone || 'Sem telefone';
    
    if (lead.telefone) {
        const telefoneNumeros = lead.telefone.replace(/\D/g, '');
        if (telefoneNumeros.length >= 10) {
            whatsappLink = `https://wa.me/55${telefoneNumeros}`;
        }
    }
    
    // Formatar data
    let dataExibicao = 'Sem data';
    if (lead.horario_preferencia) {
        dataExibicao = lead.horario_preferencia;
    } else if (lead.data_cadastro) {
        const data = new Date(lead.data_cadastro);
        dataExibicao = data.toLocaleDateString('pt-BR');
    }
    
    card.innerHTML = `
        <div class="negociacao-header">
            <span class="negociacao-id">#${String(lead.id).padStart(4, '0')}</span>
            <i class="fas fa-grip-vertical text-muted" style="font-size: 12px;" title="Arraste para mover"></i>
        </div>
        
        <button class="view-details-btn" 
                onclick="event.stopPropagation(); openDetailsModal(${lead.id})" 
                draggable="false"
                title="Ver detalhes completos">
            <i class="fas fa-eye"></i>
        </button>
        
        <h4 class="negociacao-title">${escapeHtml(lead.nome || 'Lead sem nome')}</h4>
        
        <div class="negociacao-meta">
            <div class="meta-item">
                <a href="${whatsappLink}" 
                   target="_blank" 
                   class="whatsapp-link" 
                   draggable="false"
                   onclick="event.stopPropagation()"
                   title="Abrir WhatsApp">
                    <i class="fab fa-whatsapp"></i>
                    <span>${escapeHtml(telefoneDisplay)}</span>
                </a>
            </div>
            <div class="meta-item">
                <i class="fas fa-calendar"></i>
                <span>${dataExibicao}</span>
            </div>
        </div>
    `;
    
    return card;
}

// Renderizar o kanban board
function renderKanbanBoard() {
    const board = document.getElementById('kanban-board');
    if (!board) {
        return;
    }
    
    const organizedData = organizeLeadsByStatus();
    board.innerHTML = '';
    
    Object.entries(kanbanConfig).forEach(([status, config]) => {
        const leads = organizedData[status] || [];
        
        // Criar coluna
        const column = document.createElement('div');
        column.className = 'kanban-column';
        column.dataset.status = status;
        column.style.setProperty('--column-color', config.color);
        
        // Header da coluna
        const header = document.createElement('div');
        header.className = 'kanban-header';
        header.innerHTML = `
            <div class="kanban-title">
                <i class="${config.icon}"></i>
                <span>${config.label}</span>
            </div>
            <div class="kanban-count">${leads.length}</div>
        `;
        
        // Container dos cards
        const cardsContainer = document.createElement('div');
        cardsContainer.className = 'kanban-cards';
        
        if (leads.length === 0) {
            cardsContainer.innerHTML = `
                <div class="kanban-empty">
                    <i class="${config.icon}"></i>
                    <p>Nenhum lead</p>
                </div>
            `;
        } else {
            leads.forEach(lead => {
                const card = createLeadCard(lead);
                if (card) {
                    cardsContainer.appendChild(card);
                }
            });
        }
        
        column.appendChild(header);
        column.appendChild(cardsContainer);
        board.appendChild(column);
        
        // Adicionar eventos de drop em TODAS as colunas (especialista pode mover entre todas)
        column.addEventListener('dragover', handleDragOver);
        column.addEventListener('dragleave', handleDragLeave);
        column.addEventListener('drop', handleDrop);
    });
}

// Handlers para drag and drop
function handleDragStart(e) {
    const target = e.target;
    
    if (target.closest('a') || target.closest('button') || target.tagName === 'A' || target.tagName === 'BUTTON') {
        e.preventDefault();
        return false;
    }
    
    const card = target.closest('.kanban-card');
    if (!card) {
        e.preventDefault();
        return false;
    }
    
    draggedCard = card;
    card.classList.add('dragging');
    e.dataTransfer.effectAllowed = 'move';
    e.dataTransfer.setData('text/html', card.outerHTML);
}

function handleDragEnd(e) {
    const card = e.target.closest('.kanban-card') || draggedCard;
    if (card) {
        card.classList.remove('dragging');
    }
    // Não limpar draggedCard se estiver aguardando motivo (status rejeitada)
    // Ele será limpo quando o modal for fechado ou quando a requisição for concluída
    // Verificar se o modal está aberto antes de limpar
    const modalAberto = document.getElementById('motivoPerdaModal').classList.contains('show');
    if (!pendingStatusUpdate && !modalAberto) {
        draggedCard = null;
    }
}

function handleDragOver(e) {
    e.preventDefault();
    e.dataTransfer.dropEffect = 'move';
    
    const targetColumn = e.target.closest('.kanban-column');
    if (targetColumn && draggedCard) {
        targetColumn.classList.add('drag-over');
    }
}

function handleDragLeave(e) {
    const targetColumn = e.target.closest('.kanban-column');
    if (targetColumn) {
        targetColumn.classList.remove('drag-over');
    }
}

// Variáveis globais para o modal de motivo
let pendingStatusUpdate = null;
let pendingLeadId = null;
let pendingOldStatus = null;
let pendingCard = null;
let pendingTargetCards = null;

function handleDrop(e) {
    e.preventDefault();
    e.stopPropagation();
    
    const targetColumn = e.target.closest('.kanban-column');
    
    if (targetColumn) {
        targetColumn.classList.remove('drag-over');
    }
    
    if (!draggedCard) return;
    
    const targetCards = targetColumn ? targetColumn.querySelector('.kanban-cards') : null;
    
    if (targetColumn && targetCards) {
        const currentCardsContainer = draggedCard.parentElement;
        
        if (currentCardsContainer === targetCards) {
            return;
        }
        
        let newStatus = targetColumn.dataset.status;
        const leadId = parseInt(draggedCard.dataset.leadId);
        const oldStatus = draggedCard.dataset.status;
        
        // Garantir que newStatus seja uma string válida
        if (!newStatus || typeof newStatus !== 'string') {
            newStatus = String(newStatus || 'aguardando');
        }
        newStatus = newStatus.trim();
        
        // Validar status permitidos
        const statusPermitidos = ['aguardando', 'contatado', 'negociacao', 'aprovada', 'rejeitada'];
        if (!statusPermitidos.includes(newStatus)) {
            showErrorMessage('❌ Erro: Status inválido: ' + newStatus);
            return;
        }
        
        // Validar leadId
        if (!leadId || isNaN(leadId)) {
            showErrorMessage('❌ Erro: ID do lead inválido');
            return;
        }
        
        
        // Se for mover para "Perdida", abrir modal para capturar motivo
        if (newStatus === 'rejeitada') {
            // Guardar informações para usar depois
            pendingStatusUpdate = newStatus;
            pendingLeadId = leadId;
            pendingOldStatus = oldStatus;
            
            // Guardar referência do card e do container de destino
            pendingCard = draggedCard;
            pendingTargetCards = targetCards;
            
            // Abrir modal de motivo (não mover o card ainda)
            openMotivoPerdaModal(leadId);
            
            // Não mover ainda, aguardar confirmação do motivo
            return;
        }
        
        // Se for mover para "Em Negociação", abrir modal de negociação
        if (newStatus === 'negociacao') {
            // Guardar informações para usar depois
            pendingStatusUpdate = newStatus;
            pendingLeadId = leadId;
            pendingOldStatus = oldStatus;
            
            // Guardar referência do card e do container de destino
            pendingCard = draggedCard;
            pendingTargetCards = targetCards;
            
            // Abrir modal de negociação (não mover o card ainda)
            openNegociacaoModal(leadId);
            
            // Não mover ainda, aguardar criação da negociação
            return;
        }
        
        // Para outros status, mover normalmente
        // Validar leadId antes de continuar
        if (!leadId || isNaN(leadId)) {
            showErrorMessage('❌ Erro: ID do lead inválido');
            return;
        }
        
        // Mover o card para a nova coluna
        targetCards.appendChild(draggedCard);
        draggedCard.dataset.status = newStatus;
        
        // Atualizar interface imediatamente
        updateColumnCounts();
        updateEmptyMessages();
        
        // Atualizar no servidor
        atualizarStatusLead(leadId, newStatus, oldStatus, draggedCard, targetCards);
    }
}

function escapeHtml(text) {
    if (!text) return '';
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Abrir modal de detalhes
function openDetailsModal(leadId) {
    const lead = LEADS_DATA.find(l => l.id == leadId);
    
    if (!lead) {
        alert('Lead não encontrado');
        return;
    }
    
    const modal = document.getElementById('detailsModal');
    const content = document.getElementById('detailsContent');
    
    const telefoneNumeros = (lead.telefone || '').replace(/\D/g, '');
    const whatsappLink = telefoneNumeros.length >= 10 ? `https://wa.me/55${telefoneNumeros}` : '#';
    
    content.innerHTML = `
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>ID:</strong><br>
                <span class="text-muted">#${lead.id}</span>
            </div>
            <div class="col-md-6">
                <strong>Status:</strong><br>
                <span class="badge bg-primary">${escapeHtml(lead.status || lead.etapa || 'N/A')}</span>
            </div>
        </div>
        
        <div class="row mb-3">
            <div class="col-md-12">
                <strong>Nome:</strong><br>
                <span class="text-muted">${escapeHtml(lead.nome)}</span>
            </div>
        </div>
        
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Email:</strong><br>
                <span class="text-muted">${escapeHtml(lead.email || 'Não informado')}</span>
            </div>
            <div class="col-md-6">
                <strong>Telefone:</strong><br>
                <a href="${whatsappLink}" target="_blank" class="text-success">
                    <i class="fab fa-whatsapp me-1"></i>${escapeHtml(lead.telefone || 'Não informado')}
                </a>
            </div>
        </div>
        
        ${lead.profissao ? `
        <div class="row mb-3">
            <div class="col-md-12">
                <strong>Profissão:</strong><br>
                <span class="text-muted">${escapeHtml(lead.profissao)}</span>
            </div>
        </div>
        ` : ''}
        
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Data de Cadastro:</strong><br>
                <span class="text-muted">${lead.data_cadastro ? new Date(lead.data_cadastro).toLocaleDateString('pt-BR') : 'Não informado'}</span>
            </div>
            ${lead.data_distribuicao ? `
            <div class="col-md-6">
                <strong>Data de Distribuição:</strong><br>
                <span class="text-muted">${new Date(lead.data_distribuicao).toLocaleDateString('pt-BR')}</span>
            </div>
            ` : ''}
        </div>
        
        ${lead.observacoes ? `
        <div class="mb-3">
            <strong>Observações:</strong><br>
            <div class="border rounded p-3 bg-light">
                ${escapeHtml(lead.observacoes)}
            </div>
        </div>
        ` : ''}
    `;
    
    modal.classList.add('show');
}

function closeDetailsModal() {
    const modal = document.getElementById('detailsModal');
    modal.classList.remove('show');
}

// Fechar modal clicando fora
document.addEventListener('click', function(e) {
    const modal = document.getElementById('detailsModal');
    if (e.target === modal) {
        closeDetailsModal();
    }
});

// Fechar modal com ESC
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeDetailsModal();
    }
});

// Atualizar contadores das colunas
function updateColumnCounts() {
    document.querySelectorAll('.kanban-column').forEach(column => {
        const cardsContainer = column.querySelector('.kanban-cards');
        const visibleCards = cardsContainer ? cardsContainer.querySelectorAll('.kanban-card').length : 0;
        const countElement = column.querySelector('.kanban-count');
        if (countElement) {
            countElement.textContent = visibleCards;
        }
    });
}

// Atualizar mensagens de coluna vazia
function updateEmptyMessages() {
    document.querySelectorAll('.kanban-column').forEach(column => {
        const cardsContainer = column.querySelector('.kanban-cards');
        if (!cardsContainer) return;
        
        const cards = cardsContainer.querySelectorAll('.kanban-card');
        const emptyMessage = cardsContainer.querySelector('.kanban-empty');
        const status = column.dataset.status;
        const config = kanbanConfig[status];
        
        if (cards.length === 0 && !emptyMessage) {
            // Adicionar mensagem de vazio
            const emptyDiv = document.createElement('div');
            emptyDiv.className = 'kanban-empty';
            emptyDiv.innerHTML = `
                <i class="${config.icon}"></i>
                <p>Nenhum lead</p>
            `;
            cardsContainer.appendChild(emptyDiv);
        } else if (cards.length > 0 && emptyMessage) {
            // Remover mensagem de vazio
            emptyMessage.remove();
        }
    });
}

// Abrir modal de motivo da perda
function openMotivoPerdaModal(leadId) {
    const modal = document.getElementById('motivoPerdaModal');
    const form = document.getElementById('motivoPerdaForm');
    const textarea = document.getElementById('motivoPerda');
    
    // Limpar formulário
    form.reset();
    textarea.value = '';
    
    // Mostrar modal
    modal.classList.add('show');
    
    // Focar no textarea
    setTimeout(() => {
        textarea.focus();
    }, 100);
}

// Fechar modal de motivo da perda
function closeMotivoPerdaModal(reverter = false) {
    const modal = document.getElementById('motivoPerdaModal');
    modal.classList.remove('show');
    
    // Se cancelar, reverter card para posição original
    if (reverter && pendingCard && pendingOldStatus) {
        const originalColumn = document.querySelector(`[data-status="${pendingOldStatus}"] .kanban-cards`);
        if (originalColumn) {
            originalColumn.appendChild(pendingCard);
            pendingCard.dataset.status = pendingOldStatus;
            updateColumnCounts();
            updateEmptyMessages();
        }
    }
    
    // Limpar variáveis pendentes
    pendingStatusUpdate = null;
    pendingLeadId = null;
    pendingOldStatus = null;
    pendingCard = null;
    pendingTargetCards = null;
    draggedCard = null; // Limpar também o draggedCard
}

// Submeter motivo da perda
document.getElementById('motivoPerdaForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const motivo = document.getElementById('motivoPerda').value.trim();
    
    if (!motivo) {
        alert('Por favor, informe o motivo da perda.');
        return;
    }
    
    if (!pendingStatusUpdate || !pendingLeadId) {
        alert('Erro: Informações pendentes não encontradas. Por favor, tente novamente.');
        closeMotivoPerdaModal(true); // Reverter movimento
        return;
    }
    
    // Guardar valores antes de fechar o modal (converter para número)
    const leadIdToUpdate = parseInt(pendingLeadId);
    const statusToUpdate = pendingStatusUpdate;
    const oldStatusToRevert = pendingOldStatus;
    const cardToMove = pendingCard;
    const targetCardsToMove = pendingTargetCards;
    
    // Validar leadId
    if (!leadIdToUpdate || isNaN(leadIdToUpdate)) {
        alert('Erro: ID do lead inválido. Por favor, tente novamente.');
        closeMotivoPerdaModal(true); // Reverter movimento
        return;
    }
    
    // Mover card visualmente para a coluna "Perdida"
    if (targetCardsToMove && cardToMove) {
        targetCardsToMove.appendChild(cardToMove);
        cardToMove.dataset.status = 'rejeitada';
        updateColumnCounts();
        updateEmptyMessages();
    }
    
    // Fechar modal (mas não limpar variáveis ainda)
    document.getElementById('motivoPerdaModal').classList.remove('show');
    document.getElementById('motivoPerdaForm').reset();
    
    // Atualizar no servidor com o motivo
    await atualizarStatusLead(leadIdToUpdate, statusToUpdate, oldStatusToRevert, motivo);
    
    // Limpar variáveis após a requisição
    closeMotivoPerdaModal();
});

// Atualizar status do lead no banco de dados
async function atualizarStatusLead(leadId, novoStatus, statusAnterior, motivo = null, card = null, targetCardsContainer = null) {
    // Validar leadId
    if (!leadId) {
        showErrorMessage('❌ Erro: ID do lead não encontrado');
        return;
    }
    
    // Garantir que novoStatus seja uma string válida
    if (!novoStatus || typeof novoStatus !== 'string') {
        novoStatus = String(novoStatus || 'aguardando');
    }
    novoStatus = novoStatus.trim();
    
    // Validar status permitidos
    const statusPermitidos = ['aguardando', 'contatado', 'negociacao', 'aprovada', 'rejeitada'];
    if (!statusPermitidos.includes(novoStatus)) {
        showErrorMessage('❌ Erro: Status inválido: ' + novoStatus);
        return;
    }
    
    try {
        const bodyData = {
            status: novoStatus
        };
        
        // Se houver motivo, adicionar ao body (garantir que seja string)
        if (motivo) {
            bodyData.motivo = String(motivo).trim();
        }
        
        // Construir URL da rota
        const url = `<?php echo e(url('/especialista/atendimentos')); ?>/${leadId}/status`;
        
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            },
            body: JSON.stringify(bodyData)
        });
        
        const result = await response.json();
        
        if (result.success) {
            // Se o servidor indicar que precisa abrir modal (negociação)
            if (result.open_modal && novoStatus === 'negociacao') {
                // Abrir modal de negociação
                openNegociacaoModal(result.lead_id);
                return;
            }
            
            const statusLabels = {
                'aguardando': 'Aguardando Contato',
                'contatado': 'Contatado',
                'negociacao': 'Em Negociação',
                'aprovada': 'Aprovada',
                'rejeitada': 'Perdida'
            };
            showSuccessMessage(`✅ Lead movido para "${statusLabels[novoStatus] || novoStatus}"`);
            
            // Atualizar contadores e mensagens de coluna vazia
            updateColumnCounts();
            updateEmptyMessages();
        } else {
            showErrorMessage('❌ Erro: ' + result.message);
            
            // Reverter movimento
            const originalColumn = document.querySelector(`[data-status="${statusAnterior}"] .kanban-cards`);
            if (originalColumn && (card || draggedCard)) {
                const cardToRevert = card || draggedCard;
                originalColumn.appendChild(cardToRevert);
                cardToRevert.dataset.status = statusAnterior;
                updateColumnCounts();
                updateEmptyMessages();
            }
        }
    } catch (error) {
        showErrorMessage('❌ Erro ao atualizar status: ' + (error.message || 'Erro desconhecido'));
        
        // Reverter movimento
        const originalColumn = document.querySelector(`[data-status="${statusAnterior}"] .kanban-cards`);
        if (originalColumn && draggedCard) {
            originalColumn.appendChild(draggedCard);
            draggedCard.dataset.status = statusAnterior;
            updateColumnCounts();
            updateEmptyMessages();
        }
    }
}

// Mostrar mensagem de sucesso
function showSuccessMessage(message) {
    const alert = document.createElement('div');
    alert.className = 'alert alert-success alert-dismissible fade show position-fixed';
    alert.style.cssText = 'top: 80px; right: 20px; z-index: 9999; min-width: 300px;';
    alert.innerHTML = `
        <i class="fas fa-check-circle me-2"></i>
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(alert);
    
    setTimeout(() => {
        alert.remove();
    }, 4000);
}

// Mostrar mensagem de erro
function showErrorMessage(message) {
    const alert = document.createElement('div');
    alert.className = 'alert alert-danger alert-dismissible fade show position-fixed';
    alert.style.cssText = 'top: 80px; right: 20px; z-index: 9999; min-width: 300px;';
    alert.innerHTML = `
        <i class="fas fa-exclamation-triangle me-2"></i>
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(alert);
    
    setTimeout(() => {
        alert.remove();
    }, 4000);
}

// ===== FUNÇÕES PARA MODAL DE NEGOCIAÇÃO =====

// Abrir modal de nova negociação para lead
async function openNegociacaoModal(leadId) {
    try {
        const modal = document.getElementById('negociacaoModal');
        const content = document.getElementById('negociacaoModalContent');
        
        // Mostrar loading
        content.innerHTML = `
            <div class="text-center py-4">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Carregando...</span>
                </div>
                <p class="mt-2 text-muted">Carregando dados do lead...</p>
            </div>
        `;
        
        modal.classList.add('show');
        
        // Carregar conteúdo do modal
        const response = await fetch(`<?php echo e(url('/especialista/atendimentos/modal-negociacao')); ?>/${leadId}`, {
            headers: {
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        });
        
        const result = await response.json();
        
        if (result.html) {
            content.innerHTML = result.html;
            
            // Inicializar event listeners após inserir HTML
            setTimeout(() => {
                inicializarModalNegociacaoAtendimentos();
            }, 100);
        } else {
            throw new Error('Erro ao carregar modal');
        }
        
    } catch (error) {
        showErrorMessage('❌ Erro ao carregar modal de negociação: ' + error.message);
        
        // Reverter movimento se houver erro
        if (pendingCard && pendingTargetCards) {
            const originalColumn = document.querySelector(`[data-status="${pendingOldStatus}"] .kanban-cards`);
            if (originalColumn) {
                originalColumn.appendChild(pendingCard);
                updateColumnCounts();
                updateEmptyMessages();
            }
            pendingCard = null;
            pendingTargetCards = null;
        }
        
        closeNegociacaoModal();
    }
}

// Fechar modal de negociação
function closeNegociacaoModal() {
    const modal = document.getElementById('negociacaoModal');
    modal.classList.remove('show');
    
    // Reverter movimento se modal foi fechado sem salvar
    if (pendingCard && pendingTargetCards) {
        const originalColumn = document.querySelector(`[data-status="${pendingOldStatus}"] .kanban-cards`);
        if (originalColumn) {
            originalColumn.appendChild(pendingCard);
            updateColumnCounts();
            updateEmptyMessages();
        }
        pendingCard = null;
        pendingTargetCards = null;
        pendingStatusUpdate = null;
        pendingLeadId = null;
        pendingOldStatus = null;
    }
}

// Inicializar modal de negociação (event listeners e cálculos)
function inicializarModalNegociacaoAtendimentos() {
    const voucherSelect = document.getElementById('voucherModal');
    const formaPagamentoSelect = document.getElementById('formaPagamento');
    const parcelasSelect = document.getElementById('numParcelasModal');
    
    if (!voucherSelect || !formaPagamentoSelect || !parcelasSelect) {
        return;
    }
    
    // Event listener para voucher
    voucherSelect.addEventListener('change', function() {
        updateValorTotalModalAtendimentos();
    });
    
    // Event listener para forma de pagamento
    formaPagamentoSelect.addEventListener('change', function() {
        updateParcelasModalAtendimentos();
    });
    
    // Event listener para parcelas
    parcelasSelect.addEventListener('change', function() {
        updateValorTotalModalAtendimentos();
    });
    
    // Inicializar valores
    updateParcelasModalAtendimentos();
}

// Função para atualizar parcelas baseado na forma de pagamento
function updateParcelasModalAtendimentos() {
    const formaPagamento = document.getElementById('formaPagamento')?.value;
    const selectParcelas = document.getElementById('numParcelasModal');
    const valorIntegralElement = document.querySelector('#formNegociacaoModal input[name="tipo_valor"]');
    const VALOR_INTEGRAL = parseFloat(valorIntegralElement?.closest('.mb-3').querySelector('input[readonly]')?.value.replace(/[^\d,]/g, '').replace(',', '.')) || 2200;
    
    if (!selectParcelas) return;
    
    selectParcelas.innerHTML = '';
    
    if (formaPagamento === 'credito') {
        for (let i = 1; i <= 12; i++) {
            const option = document.createElement('option');
            option.value = i;
            option.textContent = `${i}x`;
            if (i > 1) {
                const valorParcela = (VALOR_INTEGRAL * Math.pow(1.0199, i)) / i;
                option.textContent += ` (R$ ${valorParcela.toFixed(2).replace('.', ',')})`;
            }
            selectParcelas.appendChild(option);
        }
    } else if (formaPagamento === 'pix') {
        selectParcelas.innerHTML = '<option value="1">1x (à vista)</option><option value="2">2x (entrada + 30 dias)</option>';
        
        // Mostrar campo de data segunda parcela
        const segundaParcelaDiv = document.getElementById('segundaParcelaDiv');
        if (segundaParcelaDiv) {
            segundaParcelaDiv.style.display = selectParcelas.value === '2' ? 'block' : 'none';
        }
    }
    
    updateValorTotalModalAtendimentos();
}

// Função para atualizar valor total com desconto do voucher
function updateValorTotalModalAtendimentos() {
    const voucherSelect = document.getElementById('voucherModal');
    const parcelasSelect = document.getElementById('numParcelasModal');
    const formaPagamentoSelect = document.getElementById('formaPagamento');
    const valorTotalSpan = document.getElementById('valorTotalSpanModal');
    const descontoInfo = document.getElementById('descontoInfoModal');
    const descontoPercentual = document.getElementById('descontoPercentualModal');
    const valorOriginal = document.getElementById('valorOriginalModal');
    const valorBox = document.getElementById('valorTotalBoxModal');
    
    // Obter valor integral
    const valorIntegralElement = document.querySelector('#formNegociacaoModal input[name="tipo_valor"]');
    const VALOR_INTEGRAL = parseFloat(valorIntegralElement?.closest('.mb-3').querySelector('input[readonly]')?.value.replace(/[^\d,]/g, '').replace(',', '.')) || 2200;
    
    let valorTotal = VALOR_INTEGRAL;
    let descontoAplicado = 0;
    
    // Aplicar desconto do voucher
    if (voucherSelect && voucherSelect.value) {
        const selectedOption = voucherSelect.options[voucherSelect.selectedIndex];
        descontoAplicado = parseFloat(selectedOption.getAttribute('data-desconto')) || 0;
        valorTotal = VALOR_INTEGRAL * (1 - descontoAplicado / 100);
    }
    
    // Aplicar juros se cartão de crédito parcelado
    const parcelas = parseInt(parcelasSelect?.value || 1);
    const formaPagamento = formaPagamentoSelect?.value || 'credito';
    
    if (formaPagamento === 'credito' && parcelas > 1) {
        valorTotal = valorTotal * Math.pow(1.0199, parcelas);
    }
    
    // Atualizar display
    if (valorTotalSpan) {
        valorTotalSpan.textContent = 'R$ ' + valorTotal.toFixed(2).replace('.', ',');
    }
    
    // Mostrar/esconder informações de desconto
    if (descontoAplicado > 0) {
        if (descontoInfo) descontoInfo.style.display = 'block';
        if (descontoPercentual) descontoPercentual.textContent = descontoAplicado + '%';
        if (valorOriginal) valorOriginal.style.display = 'block';
        if (valorBox) {
            valorBox.classList.remove('alert-success');
            valorBox.classList.add('alert-warning');
        }
    } else {
        if (descontoInfo) descontoInfo.style.display = 'none';
        if (valorOriginal) valorOriginal.style.display = 'none';
        if (valorBox) {
            valorBox.classList.remove('alert-warning');
            valorBox.classList.add('alert-success');
        }
    }
}

// Toggle investimento parcial
function toggleInvestimentoParcial() {
    const checkbox = document.getElementById('investimentoParcialCheck');
    const investimentoGroup = document.getElementById('investimentoParcialGroup');
    const valorInvestidoInput = document.getElementById('valorInvestido');
    
    if (checkbox && checkbox.checked) {
        investimentoGroup.style.display = 'block';
        if (valorInvestidoInput) {
            valorInvestidoInput.required = true;
        }
    } else {
        investimentoGroup.style.display = 'none';
        if (valorInvestidoInput) {
            valorInvestidoInput.required = false;
            valorInvestidoInput.value = '';
        }
        const saldoInfo = document.getElementById('saldoRestanteInfo');
        if (saldoInfo) {
            saldoInfo.style.display = 'none';
        }
    }
}

// Calcular saldo restante
function calcularSaldoRestante() {
    const valorInvestidoInput = document.getElementById('valorInvestido');
    const valorTotalSpan = document.getElementById('valorTotalSpanModal');
    const saldoRestanteInfo = document.getElementById('saldoRestanteInfo');
    const saldoRestanteValor = document.getElementById('saldoRestanteValor');
    
    if (!valorInvestidoInput || !valorTotalSpan) return;
    
    const valorInvestido = parseFloat(valorInvestidoInput.value) || 0;
    const valorTotalText = valorTotalSpan.textContent.replace('R$', '').replace(/\./g, '').replace(',', '.').trim();
    const valorTotal = parseFloat(valorTotalText) || 0;
    const saldoRestante = valorTotal - valorInvestido;
    
    if (valorInvestido > 0) {
        if (saldoRestanteInfo) {
            saldoRestanteInfo.style.display = 'block';
        }
        if (saldoRestanteValor) {
            saldoRestanteValor.textContent = 'R$ ' + saldoRestante.toFixed(2).replace('.', ',');
            
            if (saldoRestante > 0) {
                saldoRestanteInfo.classList.remove('alert-success');
                saldoRestanteInfo.classList.add('alert-info');
            } else if (saldoRestante === 0) {
                saldoRestanteInfo.classList.remove('alert-info');
                saldoRestanteInfo.classList.add('alert-success');
            }
        }
    } else {
        if (saldoRestanteInfo) {
            saldoRestanteInfo.style.display = 'none';
        }
    }
}

// Confirmar criação da negociação
async function confirmNegociacao() {
    const form = document.getElementById('formNegociacaoModal');
    if (!form) return;
    
    const leadId = form.dataset.leadId;
    
    // Capturar dados diretamente dos elementos do formulário
    const alunoSelect = document.getElementById('aluno_existente_id');
    const formaPagamentoSelect = document.getElementById('formaPagamento');
    const numParcelasSelect = document.getElementById('numParcelasModal');
    const voucherSelect = document.getElementById('voucherModal');
    const investimentoParcialCheck = document.getElementById('investimentoParcialCheck');
    const valorInvestidoInput = document.getElementById('valorInvestido');
    const dataSegundaParcelaInput = document.getElementById('data_segunda_parcela');
    const tipoValorInput = form.querySelector('input[name="tipo_valor"]');
    
    // Validar campos obrigatórios
    if (!alunoSelect || !alunoSelect.value) {
        alert('❌ Por favor, selecione um aluno para vincular ao lead.');
        return;
    }
    
    if (!formaPagamentoSelect || !formaPagamentoSelect.value) {
        alert('❌ Por favor, selecione uma forma de pagamento.');
        return;
    }
    
    if (!numParcelasSelect || !numParcelasSelect.value) {
        alert('❌ Por favor, selecione o número de parcelas.');
        return;
    }
    
    // Montar objeto de dados com validação rigorosa
    let tipoValor = 'integral';
    if (tipoValorInput && tipoValorInput.value) {
        tipoValor = String(tipoValorInput.value).trim();
    }
    
    let formaPagamento = 'credito';
    if (formaPagamentoSelect && formaPagamentoSelect.value) {
        formaPagamento = String(formaPagamentoSelect.value).trim();
    }
    
    // Validar valores antes de montar o objeto
    if (!formaPagamento || (formaPagamento !== 'credito' && formaPagamento !== 'pix')) {
        alert('❌ Forma de pagamento inválida. Por favor, selecione uma opção válida.');
        return;
    }
    
    if (!tipoValor || (tipoValor !== 'integral' && tipoValor !== 'bolsista')) {
        tipoValor = 'integral'; // Padrão seguro
    }
    
    const data = {
        lead_id: parseInt(leadId, 10),
        aluno_existente_id: parseInt(alunoSelect.value, 10),
        tipo_valor: tipoValor,
        forma_pagamento: formaPagamento,
        num_parcelas: parseInt(numParcelasSelect.value, 10) || 1,
        voucher_id: voucherSelect && voucherSelect.value && voucherSelect.value !== '' ? parseInt(voucherSelect.value, 10) : null,
        investimento_parcial: investimentoParcialCheck ? investimentoParcialCheck.checked : false,
        valor_investido: valorInvestidoInput && valorInvestidoInput.value && valorInvestidoInput.value !== '' ? parseFloat(valorInvestidoInput.value) : null,
        data_segunda_parcela: dataSegundaParcelaInput && dataSegundaParcelaInput.value && dataSegundaParcelaInput.value !== '' ? String(dataSegundaParcelaInput.value).trim() : null
    };
    
    // Garantir que campos string não sejam null ou undefined
    if (!data.tipo_valor || typeof data.tipo_valor !== 'string') {
        data.tipo_valor = 'integral';
    }
    if (!data.forma_pagamento || typeof data.forma_pagamento !== 'string') {
        data.forma_pagamento = 'credito';
    }
    
    try {
        const response = await fetch('<?php echo e(route("especialista.atendimentos.salvar-negociacao")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (!response.ok) {
            // Erro de validação ou outro erro HTTP
            let errorMessage = result.message || 'Erro ao salvar negociação';
            
            // Se houver erros de validação, formatá-los
            if (result.errors) {
                const errorMessages = [];
                for (const field in result.errors) {
                    errorMessages.push(`${field}: ${result.errors[field][0]}`);
                }
                errorMessage = errorMessages.join(', ');
            }
            
            throw new Error(errorMessage);
        }
        
        if (result.success) {
            // Processar movimento do card
            if (pendingCard && pendingTargetCards) {
                pendingTargetCards.appendChild(pendingCard);
                pendingCard.dataset.status = 'negociacao';
                updateColumnCounts();
                updateEmptyMessages();
                
                // Limpar variáveis pendentes
                pendingCard = null;
                pendingTargetCards = null;
                pendingStatusUpdate = null;
                pendingLeadId = null;
                pendingOldStatus = null;
            }
            
            // Fechar modal de negociação
            closeNegociacaoModal();
            
            // Mostrar mensagem de sucesso
            showSuccessMessage('✅ ' + result.message);
            
            // Abrir modal de link de pagamento
            abrirModalLinkPagamento(result.data);
            
        } else {
            throw new Error(result.message || 'Erro desconhecido ao salvar negociação');
        }
        
    } catch (error) {
        console.error('Erro ao salvar negociação:', error);
        showErrorMessage('❌ ' + error.message);
    }
}

// Variável global para armazenar dados do pagamento
let dadosPagamentoAtual = null;

// Abrir modal de link de pagamento
function abrirModalLinkPagamento(dadosNegociacao) {
    dadosPagamentoAtual = dadosNegociacao;
    
    const modal = document.getElementById('linkPagamentoModal');
    const content = document.getElementById('linkPagamentoContent');
    
    const linkPagamento = dadosNegociacao.payment_link || 'Link não disponível';
    const orderId = dadosNegociacao.order_id || 'N/A';
    
    content.innerHTML = `
        <div class="card bg-light">
            <div class="card-body">
                <h5 class="card-title">
                    <i class="fas fa-link me-2"></i>Link de Pagamento
                </h5>
                
                <div class="alert alert-success mb-3">
                    <div class="row">
                        <div class="col-md-4">
                            <small><strong>Valor a Pagar:</strong></small><br>
                            <h4 class="mb-0">R$ ${dadosNegociacao.valor_total.toFixed(2).replace('.', ',')}</h4>
                        </div>
                        <div class="col-md-4">
                            <small><strong>Negociação ID:</strong></small><br>
                            <h4 class="mb-0">#${dadosNegociacao.negociacao_id}</h4>
                        </div>
                        <div class="col-md-4">
                            <small><strong>Order ID:</strong></small><br>
                            <h6 class="mb-0"><code>${orderId}</code></h6>
                        </div>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label"><strong>Link de Pagamento:</strong></label>
                    <div class="input-group">
                        <input type="text" 
                               class="form-control font-monospace" 
                               id="linkPagamentoInput" 
                               value="${linkPagamento}" 
                               readonly>
                        <button class="btn btn-outline-secondary" type="button" onclick="copiarLinkPagamento()">
                            <i class="fas fa-copy"></i> Copiar
                        </button>
                        ${linkPagamento !== 'Link não disponível' ? 
                            `<a href="${linkPagamento}" target="_blank" class="btn btn-outline-primary">
                                <i class="fas fa-external-link-alt"></i> Abrir
                            </a>` : ''}
                    </div>
                </div>
                
                <div class="alert alert-info">
                    <i class="fas fa-lightbulb me-2"></i>
                    <strong>Dica:</strong> Você pode acompanhar todos os links gerados na página <a href="<?php echo e(route('especialista.logs-pagamento.index')); ?>">Logs Pagar.me</a>
                </div>
            </div>
        </div>
    `;
    
    modal.classList.add('show');
}

// Copiar link de pagamento
function copiarLinkPagamento() {
    const linkInput = document.getElementById('linkPagamentoInput');
    if (linkInput) {
        linkInput.select();
        document.execCommand('copy');
        showSuccessMessage('✅ Link copiado para a área de transferência!');
    }
}

// Enviar via WhatsApp
function enviarViaWhatsApp() {
    if (!dadosPagamentoAtual) {
        alert('Erro: dados de pagamento não disponíveis');
        return;
    }
    
    const linkInput = document.getElementById('linkPagamentoInput');
    const linkPagamento = linkInput ? linkInput.value : '';
    
    // Buscar dados do lead
    const leadId = dadosPagamentoAtual.lead_id;
    const lead = LEADS_DATA.find(item => item.id == leadId);
    
    if (!lead || !lead.telefone) {
        alert('❌ Telefone do lead não encontrado');
        return;
    }
    
    const telefoneNumeros = lead.telefone.replace(/\D/g, '');
    const mensagem = `Olá ${lead.nome}! 😊\n\n` +
                    `Sua negociação foi criada com sucesso! ✅\n\n` +
                    `💰 Valor: R$ ${dadosPagamentoAtual.valor_total.toFixed(2).replace('.', ',')}\n\n` +
                    `Para realizar o pagamento, acesse o link abaixo:\n` +
                    `${linkPagamento}\n\n` +
                    `Qualquer dúvida, estou à disposição!`;
    
    const whatsappUrl = `https://wa.me/55${telefoneNumeros}?text=${encodeURIComponent(mensagem)}`;
    window.open(whatsappUrl, '_blank');
}

// Fechar modal de link de pagamento
function closeLinkPagamentoModal() {
    const modal = document.getElementById('linkPagamentoModal');
    modal.classList.remove('show');
    dadosPagamentoAtual = null;
}

// ===== FIM DAS FUNÇÕES DO MODAL DE NEGOCIAÇÃO =====

// Inicializar quando a página carregar
document.addEventListener('DOMContentLoaded', function() {
    renderKanbanBoard();
});
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.especialista', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/especialista/atendimentos/index.blade.php ENDPATH**/ ?>