

<?php $__env->startSection('title', 'Categorias'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header d-flex justify-content-between align-items-center">
    <div>
        <h1 class="content-title">Categorias de Usuário</h1>
        <p class="content-subtitle">Gerenciamento de categorias e permissões</p>
    </div>
    <a href="<?php echo e(route('admin.categorias.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus me-2"></i>Nova Categoria
    </a>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nome</th>
                        <th>Slug</th>
                        <th>Descrição</th>
                        <th>Nível Acesso</th>
                        <th>Status</th>
                        <th width="120">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong>#<?php echo e($categoria->id); ?></strong></td>
                        <td><strong><?php echo e($categoria->nome); ?></strong></td>
                        <td><code><?php echo e($categoria->slug); ?></code></td>
                        <td><?php echo e($categoria->descricao ?? '-'); ?></td>
                        <td>
                            <span class="badge bg-info"><?php echo e($categoria->nivel_acesso); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($categoria->ativo ? 'success' : 'secondary'); ?>">
                                <?php echo e($categoria->ativo ? 'Ativo' : 'Inativo'); ?>

                            </span>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.categorias.edit', $categoria->id)); ?>" class="btn btn-outline-primary" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-outline-<?php echo e($categoria->ativo ? 'warning' : 'success'); ?>" 
                                        onclick="toggleStatus(<?php echo e($categoria->id); ?>)" 
                                        title="<?php echo e($categoria->ativo ? 'Desativar' : 'Ativar'); ?>">
                                    <i class="fas fa-<?php echo e($categoria->ativo ? 'toggle-on' : 'toggle-off'); ?>"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            <i class="fas fa-inbox fa-2x mb-2"></i>
                            <p>Nenhuma categoria encontrada</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleStatus(id) {
    fetch(`/equipe/public/admin/categorias/${id}/toggle-status`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message);
        }
    })
    .catch(error => {
        alert('Erro ao atualizar status');
        console.error(error);
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/categorias/index.blade.php ENDPATH**/ ?>