

<?php $__env->startSection('title', 'Detalhes do Link'); ?>

<?php $__env->startSection('content'); ?>
<div class="content-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.marketing.index')); ?>">Marketing</a></li>
            <li class="breadcrumb-item active"><?php echo e($link->nome); ?></li>
        </ol>
    </nav>
    <h1 class="content-title"><?php echo e($link->nome); ?></h1>
</div>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Informações do Link</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="150">Código:</th>
                        <td><code class="fs-5"><?php echo e($link->codigo); ?></code></td>
                    </tr>
                    <tr>
                        <th>Link Curto:</th>
                        <td>
                            <div class="input-group">
                                <input type="text" class="form-control" value="<?php echo e(url('/l/' . $link->codigo)); ?>" id="linkCurto" readonly>
                                <button class="btn btn-outline-secondary" onclick="copiarLink('linkCurto')">
                                    <i class="fas fa-copy"></i> Copiar
                                </button>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>URL Completa:</th>
                        <td>
                            <small class="text-muted" style="word-break: break-all;"><?php echo e($link->url_completa); ?></small>
                        </td>
                    </tr>
                    <tr>
                        <th>Parâmetros UTM:</th>
                        <td>
                            <small class="text-muted"><?php echo e($link->descricao ?? '-'); ?></small>
                        </td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-<?php echo e($link->ativo ? 'success' : 'secondary'); ?>">
                                <?php echo e($link->ativo ? 'Ativo' : 'Inativo'); ?>

                            </span>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="mb-0">Estatísticas</h5>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <h2 class="display-4"><?php echo e($totalClicks); ?></h2>
                    <p class="text-muted">Total de Clicks</p>
                </div>
                <div class="text-center">
                    <h3><?php echo e($leadsGerados); ?></h3>
                    <p class="text-muted">Leads Gerados</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header bg-white">
        <h5 class="mb-0">Clicks por Dia (Últimos 30 dias)</h5>
    </div>
    <div class="card-body">
        <canvas id="chartClicks" height="80"></canvas>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
const ctx = document.getElementById('chartClicks').getContext('2d');
new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($clicksPorDia->pluck('data')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d/m'))); ?>,
        datasets: [{
            label: 'Clicks',
            data: <?php echo json_encode($clicksPorDia->pluck('total')); ?>,
            borderColor: '#3b82f6',
            backgroundColor: 'rgba(59, 130, 246, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

function copiarLink(inputId) {
    const input = document.getElementById(inputId);
    input.select();
    navigator.clipboard.writeText(input.value).then(() => {
        alert('Link copiado para a área de transferência!');
    });
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\equipe\resources\views/admin/marketing/show.blade.php ENDPATH**/ ?>